/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.net.sf.webdav.methods;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.opencrx.application.uses.net.sf.webdav.Lock;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.Resource;
import org.opencrx.application.uses.net.sf.webdav.WebDavStore;
import org.opencrx.application.uses.net.sf.webdav.exceptions.LockFailedException;
import org.opencrx.application.uses.net.sf.webdav.fromcatalina.XMLWriter;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.text.conversion.XMLEncoder;

public abstract class WebDavMethod {
    protected static final int INFINITY = 3;
    protected static final ThreadLocal<SimpleDateFormat> CREATION_DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            return format;
        }
    };
    protected static final ThreadLocal<SimpleDateFormat> LAST_MODIFIED_DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            return format;
        }
    };
    protected static int BUF_SIZE = 65536;
    protected static final int DEFAULT_TIMEOUT = 3600;
    protected static final int MAX_TIMEOUT = 604800;
    protected static final boolean TEMPORARY = true;
    protected static final int TEMP_TIMEOUT = 10;
    private static final String NULL_RESOURCE_METHODS_ALLOWED = "OPTIONS, MKCOL, PUT, PROPFIND, LOCK, UNLOCK";
    private static final String RESOURCE_METHODS_ALLOWED = "OPTIONS, GET, HEAD, POST, DELETE, TRACE, PROPPATCH, COPY, MOVE, LOCK, UNLOCK, PROPFIND";
    private static final String FOLDER_METHODS_ALLOWED = "PUT";
    private static final String DEFAULT_METHODS_ALLOWED = "OPTIONS, MKCOL, PUT";

    public abstract void execute(RequestContext var1) throws IOException, LockFailedException;

    protected String getRelativePath(RequestContext requestContext) {
        HttpServletRequest req = requestContext.getHttpServletRequest();
        return req.getServletPath();
    }

    protected String getRelativePath(RequestContext requestContext, String absolutePath) {
        HttpServletRequest req = requestContext.getHttpServletRequest();
        String contextPath = req.getContextPath();
        int pos = absolutePath.indexOf(contextPath);
        return pos > 0 ? absolutePath.substring(pos + contextPath.length()) : absolutePath;
    }

    protected String getParentPath(String path) {
        int slash = path.lastIndexOf(47);
        if (slash != -1) {
            return path.substring(0, slash);
        }
        return null;
    }

    protected String getCleanPath(String path) {
        if (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    protected DocumentBuilder getDocumentBuilder() throws ServiceException {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = null;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ServiceException((Exception)e);
        }
        return documentBuilder;
    }

    protected int getDepth(RequestContext requestContext) {
        HttpServletRequest req = requestContext.getHttpServletRequest();
        int depth = 1;
        String depthStr = req.getHeader("Depth");
        if (depthStr != null) {
            try {
                depth = Integer.parseInt(depthStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return depth;
    }

    protected String encodeURL(HttpServletResponse resp, String path) {
        path = path.replace("%", "%25");
        path = path.replace(" ", "%20");
        path = XMLEncoder.encode((String)path);
        return path;
    }

    protected String getHRef(HttpServletRequest req, String suffix, boolean isCollection) {
        String href = req.getContextPath();
        href = href.endsWith("/") && suffix.startsWith("/") ? href + suffix.substring(1) : href + suffix;
        if (isCollection && !href.endsWith("/")) {
            href = href + "/";
        }
        return href;
    }

    protected String getETag(Resource so) {
        Date lastModified = new Date();
        if (so != null && so.getLastModified() != null) {
            lastModified = so.getLastModified();
        }
        return "W/\"" + Long.toString(lastModified.getTime()) + "\"";
    }

    protected String getVersion() {
        return "1, 2";
    }

    protected String[] getLockIdFromIfHeader(RequestContext requestContext) {
        HttpServletRequest req = requestContext.getHttpServletRequest();
        String[] ids = new String[2];
        String id = req.getHeader("If");
        if (id != null && !id.equals("")) {
            if (id.indexOf(">)") == id.lastIndexOf(">)")) {
                if ((id = id.substring(id.indexOf("(<"), id.indexOf(">)"))).indexOf("locktoken:") != -1) {
                    id = id.substring(id.indexOf(58) + 1);
                }
                ids[0] = id;
            } else {
                String firstId = id.substring(id.indexOf("(<"), id.indexOf(">)"));
                if (firstId.indexOf("locktoken:") != -1) {
                    firstId = firstId.substring(firstId.indexOf(58) + 1);
                }
                ids[0] = firstId;
                String secondId = id.substring(id.lastIndexOf("(<"), id.lastIndexOf(">)"));
                if (secondId.indexOf("locktoken:") != -1) {
                    secondId = secondId.substring(secondId.indexOf(58) + 1);
                }
                ids[1] = secondId;
            }
        } else {
            ids = null;
        }
        return ids;
    }

    protected String getLockIdFromLockTokenHeader(RequestContext requestContext) {
        HttpServletRequest req = requestContext.getHttpServletRequest();
        String id = req.getHeader("Lock-Token");
        if (id != null) {
            id = id.substring(id.indexOf(":") + 1, id.indexOf(">"));
        }
        return id;
    }

    protected boolean checkLocks(RequestContext requestContext, WebDavStore store, String path) throws IOException, LockFailedException {
        List<Lock> losByPath = store.getLocksByPath(requestContext, path);
        for (Lock lo : losByPath) {
            if ("shared".equals(lo.getScope())) continue;
            String[] lockTokens = this.getLockIdFromIfHeader(requestContext);
            String lockToken = null;
            if (lockTokens == null) {
                return false;
            }
            lockToken = lockTokens[0];
            if (lockToken == null || lockToken.equals(lo.getID())) continue;
            return false;
        }
        return true;
    }

    protected void sendReport(RequestContext requestContext, Hashtable<String, Integer> errorList) throws IOException {
        HttpServletResponse resp = requestContext.getHttpServletResponse();
        HttpServletRequest req = requestContext.getHttpServletRequest();
        resp.setStatus(207);
        String absoluteUri = req.getRequestURI();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("DAV:", "D");
        XMLWriter writer = new XMLWriter(resp.getWriter(), namespaces);
        writer.writeXMLHeader();
        writer.writeElement("DAV::multistatus", 0);
        Enumeration<String> pathList = errorList.keys();
        while (pathList.hasMoreElements()) {
            String errorPath = pathList.nextElement();
            int errorCode = errorList.get(errorPath);
            writer.writeElement("DAV::response", 0);
            writer.writeElement("DAV::href", 0);
            String toAppend = null;
            if (absoluteUri.endsWith(errorPath)) {
                toAppend = absoluteUri;
            } else if (absoluteUri.contains(errorPath)) {
                int endIndex = absoluteUri.indexOf(errorPath) + errorPath.length();
                toAppend = absoluteUri.substring(0, endIndex);
            }
            if (!toAppend.startsWith("/") && !toAppend.startsWith("http:")) {
                toAppend = "/" + toAppend;
            }
            writer.writeText(errorPath);
            writer.writeElement("DAV::href", 1);
            writer.writeElement("DAV::status", 0);
            writer.writeText("HTTP/1.1 " + errorCode);
            writer.writeElement("DAV::status", 1);
            writer.writeElement("DAV::response", 1);
        }
        writer.writeElement("DAV::multistatus", 1);
        writer.sendData();
    }

    protected String getNullResourceMethodsAllowed() {
        return NULL_RESOURCE_METHODS_ALLOWED;
    }

    protected String getResourceMethodsAllowed() {
        return RESOURCE_METHODS_ALLOWED;
    }

    public String getFolderMethodsAllowed() {
        return FOLDER_METHODS_ALLOWED;
    }

    public String getDefaultMethodsAllowed() {
        return DEFAULT_METHODS_ALLOWED;
    }

    protected String determineMethodsAllowed(Resource so) {
        try {
            if (so != null) {
                if (so.isCollection()) {
                    return this.getDefaultMethodsAllowed() + ", " + this.getResourceMethodsAllowed() + ", " + this.getFolderMethodsAllowed();
                }
                return this.getDefaultMethodsAllowed() + ", " + this.getResourceMethodsAllowed();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getDefaultMethodsAllowed();
    }
}

