/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.net.sf.webdav.methods;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.Resource;
import org.opencrx.application.uses.net.sf.webdav.WebDavStore;
import org.opencrx.application.uses.net.sf.webdav.exceptions.AccessDeniedException;
import org.opencrx.application.uses.net.sf.webdav.exceptions.LockFailedException;
import org.opencrx.application.uses.net.sf.webdav.exceptions.WebdavException;
import org.opencrx.application.uses.net.sf.webdav.fromcatalina.XMLHelper;
import org.opencrx.application.uses.net.sf.webdav.fromcatalina.XMLWriter;
import org.opencrx.application.uses.net.sf.webdav.methods.WebDavMethod;
import org.openmdx.base.exception.ServiceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class DoProppatch
extends WebDavMethod {
    private static Logger LOG = Logger.getLogger(DoProppatch.class.getPackage().getName());
    private final WebDavStore _store;

    public DoProppatch(WebDavStore store) {
        this._store = store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(RequestContext requestContext) throws IOException, LockFailedException {
        LOG.finest("-- " + this.getClass().getName());
        HttpServletRequest req = requestContext.getHttpServletRequest();
        HttpServletResponse resp = requestContext.getHttpServletResponse();
        String path = this.getRelativePath(requestContext);
        String parentPath = this.getParentPath(this.getCleanPath(path));
        Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
        if (!this.checkLocks(requestContext, this._store, parentPath)) {
            errorList.put(parentPath, 423);
            this.sendReport(requestContext, errorList);
            return;
        }
        if (!this.checkLocks(requestContext, this._store, path)) {
            errorList.put(path, 423);
            this.sendReport(requestContext, errorList);
            return;
        }
        Resource so = null;
        try {
            so = this._store.getResourceByPath(requestContext, path);
            if (so == null) {
                resp.sendError(404);
                return;
            }
            List<String> toset = null;
            List<String> toremove = null;
            Vector<String> tochange = new Vector<String>();
            path = this.getCleanPath(this.getRelativePath(requestContext));
            Node tosetNode = null;
            Node toremoveNode = null;
            if (req.getContentLength() != 0) {
                try {
                    DocumentBuilder documentBuilder = this.getDocumentBuilder();
                    Document document = documentBuilder.parse(new InputSource((InputStream)req.getInputStream()));
                    Element rootElement = document.getDocumentElement();
                    tosetNode = XMLHelper.findSubElement(XMLHelper.findSubElement(rootElement, "set"), "prop");
                    toremoveNode = XMLHelper.findSubElement(XMLHelper.findSubElement(rootElement, "remove"), "prop");
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                    resp.sendError(500);
                    return;
                }
            } else {
                resp.sendError(500);
                return;
            }
            HashMap<String, String> namespaces = new HashMap<String, String>();
            namespaces.put("DAV:", "D");
            if (tosetNode != null) {
                toset = XMLHelper.getPropertiesFromXML(tosetNode);
                tochange.addAll(toset);
            }
            if (toremoveNode != null) {
                toremove = XMLHelper.getPropertiesFromXML(toremoveNode);
                tochange.addAll(toremove);
            }
            resp.setStatus(207);
            resp.setContentType("application/xml");
            resp.setCharacterEncoding("UTF-8");
            XMLWriter writer = new XMLWriter(resp.getWriter(), namespaces);
            writer.writeXMLHeader();
            writer.writeElement("DAV::multistatus", 0);
            writer.writeElement("DAV::response", 0);
            String status = new String("HTTP/1.1 200");
            writer.writeElement("DAV::href", 0);
            writer.writeText(resp.encodeURL(this.getHRef(req, req.getServletPath() + "/" + path, so.isCollection())));
            writer.writeElement("DAV::href", 1);
            for (String property : tochange) {
                writer.writeElement("DAV::propstat", 0);
                writer.writeElement("DAV::prop", 0);
                writer.writeElement(property, 2);
                writer.writeElement("DAV::prop", 1);
                writer.writeElement("DAV::status", 0);
                writer.writeText(status);
                writer.writeElement("DAV::status", 1);
                writer.writeElement("DAV::propstat", 1);
            }
            writer.writeElement("DAV::response", 1);
            writer.writeElement("DAV::multistatus", 1);
            writer.sendData();
        }
        catch (AccessDeniedException e) {
            resp.sendError(403);
        }
        catch (WebdavException e) {
            new ServiceException((Exception)e).log();
            resp.sendError(500);
        }
    }
}

