/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.net.sf.webdav.methods;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.Resource;
import org.opencrx.application.uses.net.sf.webdav.WebDavStore;
import org.opencrx.application.uses.net.sf.webdav.exceptions.AccessDeniedException;
import org.opencrx.application.uses.net.sf.webdav.exceptions.LockFailedException;
import org.opencrx.application.uses.net.sf.webdav.exceptions.ObjectAlreadyExistsException;
import org.opencrx.application.uses.net.sf.webdav.exceptions.WebdavException;
import org.opencrx.application.uses.net.sf.webdav.methods.WebDavMethod;
import org.openmdx.base.exception.ServiceException;

public class DoMove
extends WebDavMethod {
    private static Logger LOG = Logger.getLogger(DoMove.class.getPackage().getName());
    private final WebDavStore _store;

    public DoMove(WebDavStore store) {
        this._store = store;
    }

    public void moveResource(RequestContext requestContext, Resource res, String sourcePath, String destinationPath, Hashtable<String, Integer> errorList) throws IOException, WebdavException {
        HttpServletResponse resp = requestContext.getHttpServletResponse();
        resp.setStatus(204);
        WebDavStore.Status status = this._store.moveResource(requestContext, res, sourcePath, destinationPath);
        resp.setStatus(status == WebDavStore.Status.OK_CREATED ? 201 : (status == WebDavStore.Status.FORBIDDEN ? 403 : 204));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(RequestContext requestContext) throws IOException, LockFailedException {
        HttpServletRequest req = requestContext.getHttpServletRequest();
        HttpServletResponse resp = requestContext.getHttpServletResponse();
        LOG.finest("-- " + this.getClass().getName());
        String sourcePath = this.getRelativePath(requestContext);
        Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
        if (!this.checkLocks(requestContext, this._store, sourcePath)) {
            errorList.put(sourcePath, 423);
            this.sendReport(requestContext, errorList);
            return;
        }
        String destinationPath = req.getHeader("Destination");
        if (destinationPath == null) {
            resp.sendError(400);
            return;
        }
        if (!this.checkLocks(requestContext, this._store, destinationPath = this.getRelativePath(requestContext, URLDecoder.decode(destinationPath, "UTF-8")))) {
            errorList.put(destinationPath, 423);
            this.sendReport(requestContext, errorList);
            return;
        }
        try {
            errorList = new Hashtable();
            Resource sourceSo = this._store.getResourceByPath(requestContext, sourcePath);
            this.moveResource(requestContext, sourceSo, sourcePath, destinationPath, errorList);
            if (!errorList.isEmpty()) {
                this.sendReport(requestContext, errorList);
            }
        }
        catch (AccessDeniedException e) {
            resp.sendError(403);
        }
        catch (ObjectAlreadyExistsException e) {
            resp.sendError(404, req.getRequestURI());
        }
        catch (WebdavException e) {
            new ServiceException((Exception)e).log();
            resp.sendError(500);
        }
    }
}

