/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.net.sf.webdav.methods;

import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.Resource;
import org.opencrx.application.uses.net.sf.webdav.WebDavStore;
import org.opencrx.application.uses.net.sf.webdav.exceptions.AccessDeniedException;
import org.opencrx.application.uses.net.sf.webdav.exceptions.LockFailedException;
import org.opencrx.application.uses.net.sf.webdav.exceptions.WebdavException;
import org.opencrx.application.uses.net.sf.webdav.methods.WebDavMethod;
import org.openmdx.base.exception.ServiceException;

public class DoMkcol
extends WebDavMethod {
    private static Logger LOG = Logger.getLogger(DoMkcol.class.getPackage().getName());
    private final WebDavStore _store;

    public DoMkcol(WebDavStore store) {
        this._store = store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(RequestContext requestContext) throws IOException, LockFailedException {
        block12: {
            HttpServletResponse resp = requestContext.getHttpServletResponse();
            LOG.finest("-- " + this.getClass().getName());
            String path = this.getRelativePath(requestContext);
            String parentPath = this.getParentPath(this.getCleanPath(path));
            if (!this.checkLocks(requestContext, this._store, parentPath)) {
                LOG.finest("MkCol on locked resource (parentPath) not executable!\n Sending SC_FORBIDDEN (403) error response!");
                resp.sendError(403);
                return;
            }
            try {
                Resource parentRes = this._store.getResourceByPath(requestContext, parentPath);
                if (parentRes == null) {
                    resp.sendError(409);
                    return;
                }
                if (parentPath != null) {
                    if (parentRes.isCollection()) {
                        Resource res = this._store.getResourceByPath(requestContext, path);
                        if (res == null) {
                            this._store.createCollection(requestContext, path);
                            resp.setStatus(201);
                        } else {
                            String methodsAllowed = this.determineMethodsAllowed(res);
                            resp.addHeader("Allow", methodsAllowed);
                            resp.setStatus(405);
                        }
                    } else {
                        String methodsAllowed = this.determineMethodsAllowed(parentRes);
                        resp.addHeader("Allow", methodsAllowed);
                        resp.setStatus(405);
                    }
                    break block12;
                }
                resp.sendError(409);
            }
            catch (AccessDeniedException e) {
                resp.sendError(403);
            }
            catch (WebdavException e) {
                new ServiceException((Exception)e).log();
                resp.sendError(500);
            }
        }
    }
}

