/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.net.sf.webdav.methods;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import org.opencrx.application.uses.net.sf.webdav.Lock;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.WebDavStore;
import org.opencrx.application.uses.net.sf.webdav.exceptions.LockFailedException;
import org.opencrx.application.uses.net.sf.webdav.fromcatalina.XMLWriter;
import org.opencrx.application.uses.net.sf.webdav.methods.WebDavMethod;
import org.openmdx.base.exception.ServiceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DoLock
extends WebDavMethod {
    private static Logger LOG = Logger.getLogger(DoLock.class.getPackage().getName());
    private final WebDavStore _store;

    public DoLock(WebDavStore store) {
        this._store = store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(RequestContext requestContext) throws IOException, LockFailedException {
        LOG.finest("-- " + this.getClass().getName());
        HttpServletResponse resp = requestContext.getHttpServletResponse();
        String path = this.getRelativePath(requestContext);
        String parentPath = this.getParentPath(this.getCleanPath(path));
        Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
        if (!this.checkLocks(requestContext, this._store, path)) {
            errorList.put(path, 423);
            this.sendReport(requestContext, errorList);
            return;
        }
        if (!this.checkLocks(requestContext, this._store, parentPath)) {
            errorList.put(parentPath, 423);
            this.sendReport(requestContext, errorList);
            return;
        }
        try {
            this.executeLock(requestContext, path);
        }
        catch (LockFailedException e) {
            resp.sendError(423);
            new ServiceException((Exception)e).log();
        }
        catch (Exception e) {
            resp.sendError(500);
            new ServiceException(e).log();
        }
    }

    private void executeLock(RequestContext requestContext, String path) throws IOException, LockFailedException {
        LockInformation lockInfo = this.getLockInformation(requestContext);
        int depth = this.getDepth(requestContext);
        int lockDuration = this.getTimeout(requestContext);
        Lock lock = this._store.lock(requestContext, path, requestContext.getHttpServletRequest().getHeader("If"), lockInfo == null ? null : lockInfo.owner, lockInfo == null ? null : lockInfo.scope, lockInfo == null ? null : lockInfo.type, depth, lockDuration);
        if (lock == null) {
            this.sendLockFailError(requestContext, path);
            throw new LockFailedException();
        }
        this.generateReport(requestContext, lock);
    }

    private LockInformation getLockInformation(RequestContext requestContext) {
        LockInformation lockInfo;
        block22: {
            HttpServletRequest req = requestContext.getHttpServletRequest();
            HttpServletResponse resp = requestContext.getHttpServletResponse();
            lockInfo = new LockInformation();
            Element lockInfoNode = null;
            DocumentBuilder documentBuilder = null;
            try {
                Element rootElement;
                documentBuilder = this.getDocumentBuilder();
                Document document = req.getContentLength() <= 0 ? null : documentBuilder.parse((InputStream)req.getInputStream());
                lockInfoNode = rootElement = document == null ? null : document.getDocumentElement();
                if (lockInfoNode != null) {
                    int i;
                    NodeList childList = lockInfoNode.getChildNodes();
                    Node lockScopeNode = null;
                    Node lockTypeNode = null;
                    Node lockOwnerNode = null;
                    Node currentNode = null;
                    String nodeName = null;
                    for (int i2 = 0; i2 < childList.getLength(); ++i2) {
                        currentNode = childList.item(i2);
                        if (currentNode.getNodeType() == 1 || currentNode.getNodeType() == 3) {
                            nodeName = currentNode.getNodeName();
                            if (nodeName.endsWith("locktype")) {
                                lockTypeNode = currentNode;
                            }
                            if (nodeName.endsWith("lockscope")) {
                                lockScopeNode = currentNode;
                            }
                            if (!nodeName.endsWith("owner")) continue;
                            lockOwnerNode = currentNode;
                            continue;
                        }
                        return null;
                    }
                    if (lockScopeNode != null) {
                        String scope = null;
                        childList = lockScopeNode.getChildNodes();
                        for (int i3 = 0; i3 < childList.getLength(); ++i3) {
                            currentNode = childList.item(i3);
                            if (currentNode.getNodeType() != 1) continue;
                            scope = currentNode.getNodeName();
                            if (scope.endsWith("exclusive")) {
                                lockInfo.scope = "exclusive";
                                continue;
                            }
                            if (!scope.equals("shared")) continue;
                            lockInfo.scope = "shared";
                        }
                        if (scope == null) {
                            return null;
                        }
                    } else {
                        return null;
                    }
                    if (lockTypeNode != null) {
                        childList = lockTypeNode.getChildNodes();
                        for (i = 0; i < childList.getLength(); ++i) {
                            currentNode = childList.item(i);
                            if (currentNode.getNodeType() != 1) continue;
                            String _type = currentNode.getNodeName();
                            if (_type.endsWith("write")) {
                                lockInfo.type = "write";
                                continue;
                            }
                            if (!_type.equals("read")) continue;
                            lockInfo.type = "read";
                        }
                        if (lockInfo.type == null) {
                            return null;
                        }
                    } else {
                        return null;
                    }
                    if (lockOwnerNode != null) {
                        childList = lockOwnerNode.getChildNodes();
                        for (i = 0; i < childList.getLength(); ++i) {
                            currentNode = childList.item(i);
                            if (currentNode.getNodeType() != 1 && currentNode.getNodeType() != 3) continue;
                            lockInfo.owner = currentNode.getTextContent();
                        }
                    }
                    if (lockInfo.owner == null) {
                        return null;
                    }
                    break block22;
                }
                return null;
            }
            catch (Exception e) {
                try {
                    resp.sendError(500);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                new ServiceException(e).log();
                return null;
            }
        }
        return lockInfo;
    }

    private int getTimeout(RequestContext requestContext) {
        HttpServletRequest req = requestContext.getHttpServletRequest();
        int lockDuration = 3600;
        String lockDurationStr = req.getHeader("Timeout");
        if (lockDurationStr == null) {
            lockDuration = 3600;
        } else {
            int commaPos = lockDurationStr.indexOf(44);
            if (commaPos != -1) {
                lockDurationStr = lockDurationStr.substring(0, commaPos);
            }
            if (lockDurationStr.startsWith("Second-")) {
                lockDuration = new Integer(lockDurationStr.substring(7));
            } else if (lockDurationStr.equalsIgnoreCase("infinity")) {
                lockDuration = 604800;
            } else {
                try {
                    lockDuration = new Integer(lockDurationStr);
                }
                catch (NumberFormatException e) {
                    lockDuration = 604800;
                }
            }
            if (lockDuration <= 0) {
                lockDuration = 3600;
            }
            if (lockDuration > 604800) {
                lockDuration = 604800;
            }
        }
        return lockDuration;
    }

    private void generateReport(RequestContext requestContext, Lock lo) {
        try {
            HttpServletResponse resp = requestContext.getHttpServletResponse();
            HashMap<String, String> namespaces = new HashMap<String, String>();
            namespaces.put("DAV:", "D");
            resp.setStatus(200);
            resp.setContentType("application/xml");
            resp.setCharacterEncoding("UTF-8");
            XMLWriter generatedXML = new XMLWriter(resp.getWriter(), namespaces);
            generatedXML.writeXMLHeader();
            generatedXML.writeElement("DAV::prop", 0);
            generatedXML.writeElement("DAV::lockdiscovery", 0);
            generatedXML.writeElement("DAV::activelock", 0);
            generatedXML.writeElement("DAV::locktype", 0);
            generatedXML.writeProperty("DAV::" + lo.getType());
            generatedXML.writeElement("DAV::locktype", 1);
            generatedXML.writeElement("DAV::lockscope", 0);
            if ("exclusive".equals(lo.getScope())) {
                generatedXML.writeProperty("DAV::exclusive");
            } else {
                generatedXML.writeProperty("DAV::shared");
            }
            generatedXML.writeElement("DAV::lockscope", 1);
            int depth = lo.getLockDepth();
            generatedXML.writeElement("DAV::depth", 0);
            if (depth == 3) {
                generatedXML.writeText("Infinity");
            } else {
                generatedXML.writeText(String.valueOf(depth));
            }
            generatedXML.writeElement("DAV::depth", 1);
            generatedXML.writeElement("DAV::owner", 0);
            generatedXML.writeElement("DAV::href", 0);
            generatedXML.writeText(lo.getOwner());
            generatedXML.writeElement("DAV::href", 1);
            generatedXML.writeElement("DAV::owner", 1);
            long timeout = lo.getExpiresAt() - System.currentTimeMillis();
            generatedXML.writeElement("DAV::timeout", 0);
            generatedXML.writeText("Second-" + timeout / 1000L);
            generatedXML.writeElement("DAV::timeout", 1);
            String lockToken = lo.getID();
            generatedXML.writeElement("DAV::locktoken", 0);
            generatedXML.writeElement("DAV::href", 0);
            generatedXML.writeText("opaquelocktoken:" + lockToken);
            generatedXML.writeElement("DAV::href", 1);
            generatedXML.writeElement("DAV::locktoken", 1);
            generatedXML.writeElement("DAV::activelock", 1);
            generatedXML.writeElement("DAV::lockdiscovery", 1);
            generatedXML.writeElement("DAV::prop", 1);
            resp.addHeader("Lock-Token", "<opaquelocktoken:" + lockToken + ">");
            generatedXML.sendData();
        }
        catch (Exception e) {
            new ServiceException(e).log();
        }
    }

    private void sendLockFailError(RequestContext requestContext, String path) throws IOException {
        Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
        errorList.put(path, 423);
        this.sendReport(requestContext, errorList);
    }

    static class LockInformation {
        public String scope;
        public String type;
        public String owner;

        LockInformation() {
        }
    }
}

