/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.net.sf.webdav.methods;

import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.Resource;
import org.opencrx.application.uses.net.sf.webdav.WebDavStore;
import org.opencrx.application.uses.net.sf.webdav.exceptions.AccessDeniedException;
import org.opencrx.application.uses.net.sf.webdav.exceptions.LockFailedException;
import org.opencrx.application.uses.net.sf.webdav.exceptions.ObjectAlreadyExistsException;
import org.opencrx.application.uses.net.sf.webdav.exceptions.WebdavException;
import org.opencrx.application.uses.net.sf.webdav.methods.WebDavMethod;
import org.openmdx.base.exception.ServiceException;

public class DoHead
extends WebDavMethod {
    protected final WebDavStore _store;
    private static Logger LOG = Logger.getLogger(DoHead.class.getPackage().getName());

    public DoHead(WebDavStore store) {
        this._store = store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(RequestContext requestContext) throws IOException, LockFailedException {
        block15: {
            HttpServletResponse resp = requestContext.getHttpServletResponse();
            HttpServletRequest req = requestContext.getHttpServletRequest();
            String path = this.getRelativePath(requestContext);
            LOG.finest("-- " + this.getClass().getName());
            Resource so = this._store.getResourceByPath(requestContext, path);
            if (so == null) {
                resp.setStatus(404);
            } else {
                try {
                    String eTagMatch = req.getHeader("If-None-Match");
                    if (eTagMatch != null && eTagMatch.equals(this.getETag(so))) {
                        resp.setStatus(304);
                        return;
                    }
                    if (!so.isCollection()) {
                        if (path.endsWith("/") || path.endsWith("\\")) {
                            resp.sendError(404, req.getRequestURI());
                        } else {
                            long lastModified = so.getLastModified().getTime();
                            resp.setDateHeader("last-modified", lastModified);
                            String eTag = this.getETag(so);
                            resp.addHeader("ETag", eTag);
                            String mimeType = this._store.getMimeType(so);
                            if (mimeType != null) {
                                resp.setContentType(mimeType);
                            } else {
                                int lastSlash = path.replace('\\', '/').lastIndexOf(47);
                                int lastDot = path.indexOf(".", lastSlash);
                                if (lastDot == -1) {
                                    resp.setContentType("text/html");
                                }
                            }
                            this.doBody(requestContext, so);
                        }
                        break block15;
                    }
                    this.folderBody(requestContext, so);
                }
                catch (AccessDeniedException e) {
                    resp.sendError(403);
                }
                catch (ObjectAlreadyExistsException e) {
                    resp.sendError(404, req.getRequestURI());
                }
                catch (WebdavException e) {
                    new ServiceException((Exception)e).log();
                    resp.sendError(500);
                }
            }
        }
    }

    protected void folderBody(RequestContext requestContext, Resource so) throws IOException {
    }

    protected void doBody(RequestContext requestContext, Resource so) throws IOException {
    }
}

