/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.net.sf.webdav.methods;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.Resource;
import org.opencrx.application.uses.net.sf.webdav.WebDavStore;
import org.opencrx.application.uses.net.sf.webdav.fromcatalina.HTMLWriter;
import org.opencrx.application.uses.net.sf.webdav.methods.DoHead;
import org.w3c.cci2.BinaryLargeObjects;

public class DoGet
extends DoHead {
    private static Logger LOG = Logger.getLogger(DoGet.class.getPackage().getName());

    public DoGet(WebDavStore store) {
        super(store);
    }

    @Override
    protected void doBody(RequestContext requestContext, Resource res) {
        HttpServletResponse resp = requestContext.getHttpServletResponse();
        try {
            String range;
            ServletOutputStream out = resp.getOutputStream();
            WebDavStore.ResourceContent resourceContent = this._store.getResourceContent(requestContext, res);
            InputStream in = resourceContent.getContent().getContent();
            String mimeType = this._store.getMimeType(res);
            if (mimeType != null) {
                resp.setContentType(mimeType);
                if (mimeType.startsWith("text/")) {
                    resp.setCharacterEncoding("UTF-8");
                }
            }
            if ((range = requestContext.getHttpServletRequest().getHeader("Range")) == null) {
                resp.setStatus(200);
                long contentLength = BinaryLargeObjects.streamCopy((InputStream)in, (long)0L, (OutputStream)out);
                resp.setContentLength((int)contentLength);
            } else if (range.startsWith("bytes=")) {
                range = range.substring(6);
                Long rangeFrom = null;
                Long rangeTo = null;
                String[] rangeParts = range.split("-");
                if (rangeParts.length > 0) {
                    try {
                        rangeFrom = Long.valueOf(rangeParts[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (rangeParts.length > 1) {
                    try {
                        rangeTo = Long.valueOf(rangeParts[1]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (rangeFrom != null) {
                    Long contentLength = resourceContent.getLength();
                    resp.setBufferSize((int)(contentLength - rangeFrom));
                    long skipped = in.skip(rangeFrom);
                    if (skipped == rangeFrom) {
                        int b;
                        long pos = rangeFrom;
                        long rangeLength = 0L;
                        while ((b = in.read()) != -1) {
                            out.write(b);
                            ++rangeLength;
                            if (rangeTo == null || ++pos <= rangeTo) continue;
                        }
                        resp.setStatus(206);
                        resp.setHeader("Content-Range", "bytes " + rangeFrom + "-" + (pos - 1L) + "/" + contentLength);
                        resp.setContentLength((int)rangeLength);
                    } else {
                        resp.setStatus(416);
                    }
                } else {
                    resp.setStatus(416);
                }
            } else {
                resp.setStatus(416);
            }
            out.flush();
        }
        catch (Exception e) {
            LOG.finest(e.toString());
        }
    }

    @Override
    protected void folderBody(RequestContext requestContext, Resource so) throws IOException {
        HttpServletRequest req = requestContext.getHttpServletRequest();
        HttpServletResponse resp = requestContext.getHttpServletResponse();
        if (so == null) {
            resp.sendError(404, req.getRequestURI());
        } else {
            resp.setStatus(200);
            if (so.isCollection()) {
                DateFormat shortDF = this.getDateTimeFormat(req.getLocale());
                resp.setContentType("text/html");
                resp.setCharacterEncoding("UTF-8");
                Collection<Resource> children = this._store.getChildren(requestContext, so, null, null);
                HTMLWriter writer = new HTMLWriter(resp.getWriter());
                writer.writeText("<html><head><title>Content of folder");
                writer.writeText(so.getName());
                writer.writeText("</title><style type=\"text/css\">");
                this.writeCSS(writer);
                writer.writeText("</style></head>");
                writer.writeText("<body>");
                this.writeHeader(writer, requestContext, so.getName());
                writer.writeText("<table>");
                writer.writeText("<tr><th>Name</th><th>Size</th><th>Created</th><th>Modified</th></tr>");
                writer.writeText("<tr>");
                writer.writeText("<td colspan=\"4\"><a href=\"../\">Parent</a></td></tr>");
                boolean isEven = false;
                for (Resource child : children) {
                    isEven = !isEven;
                    writer.writeText("<tr class=\"");
                    writer.writeText(isEven ? "even" : "odd");
                    writer.writeText("\">");
                    writer.writeText("<td>");
                    writer.writeText("<a href=\"");
                    writer.writeText(child.getName());
                    if (child.isCollection()) {
                        writer.writeText("/");
                    }
                    writer.writeText("\">");
                    writer.writeText(child.getName());
                    writer.writeText("</a></td>");
                    if (child.isCollection()) {
                        writer.writeText("<td>Folder</td>");
                    } else {
                        writer.writeText("<td>");
                        WebDavStore.ResourceContent resourceContent = this._store.getResourceContent(requestContext, child);
                        writer.writeText(Long.toString(resourceContent.getLength()));
                        writer.writeText(" Bytes</td>");
                    }
                    if (child.getCreationDate() != null) {
                        writer.writeText("<td>");
                        writer.writeText(shortDF.format(child.getCreationDate()));
                        writer.writeText("</td>");
                    } else {
                        writer.writeText("<td></td>");
                    }
                    if (child.getLastModified() != null) {
                        writer.writeText("<td>");
                        writer.writeText(shortDF.format(child.getLastModified()));
                        writer.writeText("</td>");
                    } else {
                        writer.writeText("<td></td>");
                    }
                    writer.writeText("</tr>");
                }
                writer.writeText("</table>");
                this.writeFooter(writer, requestContext, so.getName());
                writer.writeText("</body></html>");
                writer.sendData();
            }
        }
    }

    protected void writeCSS(HTMLWriter writer) {
        writer.writeText("body {\n\tfont-family: 'Open Sans', 'DejaVu Sans Condensed', 'lucida sans', tahoma, verdana, arial, sans-serif;\n}\nh1 {\n\tfont-size: 1.5em;\n}\nth {\n\tbackground-color: #9DACBF;\n}\ntable {\n\tborder-top-style: solid;\n\tborder-right-style: solid;\n\tborder-bottom-style: solid;\n\tborder-left-style: solid;\n}\ntd {\n\tmargin: 0px;\n\tpadding-top: 2px;\n\tpadding-right: 5px;\n\tpadding-bottom: 2px;\n\tpadding-left: 5px;\n}\ntr.even {\n\tbackground-color: #CCCCCC;\n}\ntr.odd {\n\tbackground-color: #FFFFFF;\n}");
    }

    protected DateFormat getDateTimeFormat(Locale browserLocale) {
        return SimpleDateFormat.getDateTimeInstance(3, 2, browserLocale);
    }

    protected void writeHeader(HTMLWriter writer, RequestContext requestContext, String name) {
        writer.writeText("<h1>Content of folder " + name + "</h1>");
    }

    protected void writeFooter(HTMLWriter writer, RequestContext requestContext, String name) {
        writer.writeText("");
    }
}

