/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.net.sf.webdav.methods;

import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.Resource;
import org.opencrx.application.uses.net.sf.webdav.WebDavStore;
import org.opencrx.application.uses.net.sf.webdav.exceptions.AccessDeniedException;
import org.opencrx.application.uses.net.sf.webdav.exceptions.LockFailedException;
import org.opencrx.application.uses.net.sf.webdav.exceptions.ObjectAlreadyExistsException;
import org.opencrx.application.uses.net.sf.webdav.exceptions.ObjectNotFoundException;
import org.opencrx.application.uses.net.sf.webdav.exceptions.WebdavException;
import org.opencrx.application.uses.net.sf.webdav.fromcatalina.RequestUtil;
import org.opencrx.application.uses.net.sf.webdav.methods.DoDelete;
import org.opencrx.application.uses.net.sf.webdav.methods.WebDavMethod;
import org.openmdx.base.exception.ServiceException;

public class DoCopy
extends WebDavMethod {
    private static Logger LOG = Logger.getLogger(DoCopy.class.getPackage().getName());
    private final WebDavStore _store;
    private final DoDelete _doDelete;

    public DoCopy(WebDavStore store, DoDelete doDelete) {
        this._store = store;
        this._doDelete = doDelete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(RequestContext requestContext) throws IOException, LockFailedException {
        LOG.finest("-- " + this.getClass().getName());
        HttpServletRequest req = requestContext.getHttpServletRequest();
        HttpServletResponse resp = requestContext.getHttpServletResponse();
        try {
            if (!this.copyResource(requestContext)) {
                return;
            }
        }
        catch (AccessDeniedException e) {
            resp.sendError(403);
        }
        catch (ObjectAlreadyExistsException e) {
            resp.sendError(409, req.getRequestURI());
        }
        catch (ObjectNotFoundException e) {
            resp.sendError(404, req.getRequestURI());
        }
        catch (WebdavException e) {
            new ServiceException((Exception)e).log();
            resp.sendError(500);
        }
    }

    public boolean copyResource(RequestContext requestContext) throws WebdavException, IOException, LockFailedException {
        HttpServletResponse resp = requestContext.getHttpServletResponse();
        HttpServletRequest req = requestContext.getHttpServletRequest();
        String destinationPath = this.parseDestinationHeader(requestContext);
        if (destinationPath == null) {
            return false;
        }
        String path = this.getRelativePath(requestContext);
        if (path.equals(destinationPath)) {
            resp.sendError(403);
            return false;
        }
        Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
        String parentDestinationPath = this.getParentPath(this.getCleanPath(destinationPath));
        if (!this.checkLocks(requestContext, this._store, parentDestinationPath)) {
            errorList.put(parentDestinationPath, 423);
            this.sendReport(requestContext, errorList);
            return false;
        }
        if (!this.checkLocks(requestContext, this._store, destinationPath)) {
            errorList.put(destinationPath, 423);
            this.sendReport(requestContext, errorList);
            return false;
        }
        boolean overwrite = true;
        String overwriteHeader = req.getHeader("Overwrite");
        if (overwriteHeader != null) {
            overwrite = overwriteHeader.equalsIgnoreCase("T");
        }
        Resource destinationSo = null;
        Resource copySo = this._store.getResourceByPath(requestContext, path);
        if (copySo == null) {
            resp.sendError(404);
            return false;
        }
        errorList = new Hashtable();
        destinationSo = this._store.getResourceByPath(requestContext, destinationPath);
        if (overwrite) {
            if (destinationSo != null) {
                this._doDelete.deleteResource(requestContext, destinationSo, destinationPath, errorList);
            } else {
                resp.setStatus(201);
            }
        } else {
            if (destinationSo != null) {
                resp.sendError(412);
                return false;
            }
            resp.setStatus(201);
        }
        this.copy(requestContext, path, destinationPath, errorList);
        if (!errorList.isEmpty()) {
            this.sendReport(requestContext, errorList);
        }
        return true;
    }

    private void copy(RequestContext requestContext, String sourcePath, String destinationPath, Hashtable<String, Integer> errorList) throws WebdavException, IOException {
        HttpServletResponse resp = requestContext.getHttpServletResponse();
        Resource sourceSo = this._store.getResourceByPath(requestContext, sourcePath);
        if (sourceSo != null) {
            if (sourceSo.isCollection()) {
                this.copyFolder(requestContext, sourcePath, destinationPath, errorList);
            } else {
                this._store.putResource(requestContext, destinationPath, this._store.getResourceContent(requestContext, sourceSo).getContent().getContent(), this._store.getMimeType(sourceSo));
            }
        } else {
            resp.sendError(404);
        }
    }

    private void copyFolder(RequestContext requestContext, String sourcePath, String destinationPath, Hashtable<String, Integer> errorList) throws WebdavException {
        HttpServletRequest req = requestContext.getHttpServletRequest();
        this._store.createCollection(requestContext, destinationPath);
        boolean infiniteDepth = true;
        String depth = req.getHeader("Depth");
        if (depth != null && depth.equals("0")) {
            infiniteDepth = false;
        }
        if (infiniteDepth) {
            Resource so = this._store.getResourceByPath(requestContext, sourcePath);
            Collection<Resource> children = this._store.getChildren(requestContext, so, null, null);
            for (Resource childSo : children) {
                try {
                    if (childSo.isCollection()) {
                        this.copyFolder(requestContext, sourcePath + "/" + childSo.getName(), destinationPath + childSo.getName(), errorList);
                        continue;
                    }
                    this._store.putResource(requestContext, destinationPath + "/" + childSo.getName(), this._store.getResourceContent(requestContext, childSo).getContent().getContent(), this._store.getMimeType(childSo));
                }
                catch (AccessDeniedException e) {
                    errorList.put(destinationPath + "/" + childSo.getName(), new Integer(403));
                }
                catch (ObjectNotFoundException e) {
                    errorList.put(destinationPath + "/" + childSo.getName(), new Integer(404));
                }
                catch (ObjectAlreadyExistsException e) {
                    errorList.put(destinationPath + "/" + childSo.getName(), new Integer(409));
                }
                catch (Exception e) {
                    errorList.put(destinationPath + "/" + childSo.getName(), new Integer(500));
                }
            }
        }
    }

    private String parseDestinationHeader(RequestContext requestContext) throws IOException {
        String servletPath;
        String pathInfo;
        HttpServletRequest req = requestContext.getHttpServletRequest();
        HttpServletResponse resp = requestContext.getHttpServletResponse();
        String destinationPath = req.getHeader("Destination");
        if (destinationPath == null) {
            resp.sendError(400);
            return null;
        }
        int protocolIndex = (destinationPath = RequestUtil.URLDecode(destinationPath, "UTF8")).indexOf("://");
        if (protocolIndex >= 0) {
            int firstSeparator = destinationPath.indexOf("/", protocolIndex + 4);
            destinationPath = firstSeparator < 0 ? "/" : destinationPath.substring(firstSeparator);
        } else {
            int portIndex;
            String hostName = req.getServerName();
            if (hostName != null && destinationPath.startsWith(hostName)) {
                destinationPath = destinationPath.substring(hostName.length());
            }
            if ((portIndex = destinationPath.indexOf(":")) >= 0) {
                destinationPath = destinationPath.substring(portIndex);
            }
            if (destinationPath.startsWith(":")) {
                int firstSeparator = destinationPath.indexOf("/");
                destinationPath = firstSeparator < 0 ? "/" : destinationPath.substring(firstSeparator);
            }
        }
        destinationPath = this.normalize(destinationPath);
        String contextPath = req.getContextPath();
        if (contextPath != null && destinationPath.startsWith(contextPath)) {
            destinationPath = destinationPath.substring(contextPath.length());
        }
        if ((pathInfo = req.getPathInfo()) != null && (servletPath = req.getServletPath()) != null && destinationPath.startsWith(servletPath)) {
            destinationPath = destinationPath.substring(servletPath.length());
        }
        return destinationPath;
    }

    protected String normalize(String path) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized.equals("/.")) {
            return "/";
        }
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }
}

