/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.util;

import java.util.Collection;
import java.util.Map;

public class StringUtils {
    public static final String NEWLINE = System.getProperty("line.separator");

    public static String ltrim(String string) {
        int i;
        if (string == null) {
            return null;
        }
        for (i = 0; i < string.length() && Character.isWhitespace(string.charAt(i)); ++i) {
        }
        return i == string.length() ? "" : string.substring(i);
    }

    public static String rtrim(String string) {
        int i;
        if (string == null) {
            return null;
        }
        for (i = string.length() - 1; i >= 0 && Character.isWhitespace(string.charAt(i)); --i) {
        }
        return i == 0 ? "" : string.substring(0, i + 1);
    }

    public static <T> String join(Collection<T> collection, String delimiter) {
        StringBuilder sb = new StringBuilder();
        StringUtils.join(collection, delimiter, sb);
        return sb.toString();
    }

    public static <T> void join(Collection<T> collection, String delimiter, StringBuilder sb) {
        StringUtils.join(collection, delimiter, sb, new JoinCallback<T>(){

            @Override
            public void handle(StringBuilder sb, T value) {
                sb.append(value);
            }
        });
    }

    public static <T> String join(Collection<T> collection, String delimiter, JoinCallback<T> join) {
        StringBuilder sb = new StringBuilder();
        StringUtils.join(collection, delimiter, sb, join);
        return sb.toString();
    }

    public static <T> void join(Collection<T> collection, String delimiter, StringBuilder sb, JoinCallback<T> join) {
        boolean first = true;
        for (T element : collection) {
            if (first) {
                first = false;
            } else {
                sb.append(delimiter);
            }
            join.handle(sb, element);
        }
    }

    public static <K, V> String join(Map<K, V> map, String delimiter, final JoinMapCallback<K, V> join) {
        return StringUtils.join(map.entrySet(), delimiter, new JoinCallback<Map.Entry<K, V>>(){

            @Override
            public void handle(StringBuilder sb, Map.Entry<K, V> entry) {
                join.handle(sb, entry.getKey(), entry.getValue());
            }
        });
    }

    private StringUtils() {
    }

    public static interface JoinMapCallback<K, V> {
        public void handle(StringBuilder var1, K var2, V var3);
    }

    public static interface JoinCallback<T> {
        public void handle(StringBuilder var1, T var2);
    }
}

