/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.io.text;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.io.text.FoldedLineWriter;
import org.opencrx.application.uses.ezvcard.parameter.Encoding;
import org.opencrx.application.uses.ezvcard.parameter.VCardParameters;

public class VCardRawWriter
implements Closeable,
Flushable {
    private static final Pattern quoteMeRegex = Pattern.compile(".*?[,:;].*");
    private static final Pattern newlineRegex = Pattern.compile("\\r\\n|\\r|\\n");
    private static final Pattern propertyNameRegex = Pattern.compile("(?i)[-a-z0-9]+");
    private static final Map<VCardVersion, BitSet> invalidParamValueChars;
    private final FoldedLineWriter writer;
    private boolean caretEncodingEnabled = false;
    private ProblemsListener problemsListener;
    private VCardVersion version;

    public VCardRawWriter(Writer writer, VCardVersion version) {
        this.writer = new FoldedLineWriter(writer);
        this.version = version;
    }

    public FoldedLineWriter getFoldedLineWriter() {
        return this.writer;
    }

    public boolean isCaretEncodingEnabled() {
        return this.caretEncodingEnabled;
    }

    public void setCaretEncodingEnabled(boolean enable) {
        this.caretEncodingEnabled = enable;
    }

    public VCardVersion getVersion() {
        return this.version;
    }

    public void setVersion(VCardVersion version) {
        this.version = version;
    }

    public ProblemsListener getProblemsListener() {
        return this.problemsListener;
    }

    public void setProblemsListener(ProblemsListener problemsListener) {
        this.problemsListener = problemsListener;
    }

    public void writeBeginComponent(String componentName) throws IOException {
        this.writeProperty("BEGIN", componentName);
    }

    public void writeEndComponent(String componentName) throws IOException {
        this.writeProperty("END", componentName);
    }

    public void writeVersion() throws IOException {
        this.writeProperty("VERSION", this.version.getVersion());
    }

    public void writeProperty(String propertyName, String value) throws IOException {
        this.writeProperty(null, propertyName, new VCardParameters(), value);
    }

    public void writeProperty(String group, String propertyName, VCardParameters parameters, String value) throws IOException {
        if (group != null && !propertyNameRegex.matcher(group).matches()) {
            throw new IllegalArgumentException("Group contains invalid characters.  Valid characters are letters, numbers, and hyphens: " + group);
        }
        if (!propertyNameRegex.matcher(propertyName).matches()) {
            throw new IllegalArgumentException("Property name contains invalid characters.  Valid characters are letters, numbers, and hyphens: " + propertyName);
        }
        value = this.sanitizeValue(parameters, value);
        boolean quotedPrintable = parameters.getEncoding() == Encoding.QUOTED_PRINTABLE;
        Charset charset = null;
        if (quotedPrintable) {
            String charsetParam = parameters.getCharset();
            if (charsetParam == null) {
                charset = Charset.forName("UTF-8");
            } else {
                try {
                    charset = Charset.forName(charsetParam);
                }
                catch (Throwable t) {
                    charset = Charset.forName("UTF-8");
                }
            }
            parameters.setCharset(charset.name());
        }
        if (group != null) {
            this.writer.append(group);
            this.writer.append('.');
        }
        this.writer.append(propertyName);
        for (Map.Entry parameter : parameters) {
            String parameterName = (String)parameter.getKey();
            List parameterValues = parameter.getValue();
            if (parameterValues.isEmpty()) continue;
            if (this.version == VCardVersion.V2_1) {
                boolean isTypeParameter = "TYPE".equalsIgnoreCase(parameterName);
                for (String parameterValue : parameterValues) {
                    parameterValue = this.sanitizeParameterValue(parameterValue, parameterName, propertyName);
                    if (isTypeParameter) {
                        this.writer.append(';').append(parameterValue.toUpperCase());
                        continue;
                    }
                    this.writer.append(';').append(parameterName).append('=').append(parameterValue);
                }
                continue;
            }
            boolean first = true;
            this.writer.append(';').append(parameterName).append('=');
            for (String parameterValue : parameterValues) {
                if (!first) {
                    this.writer.append(',');
                }
                if (quoteMeRegex.matcher(parameterValue = this.sanitizeParameterValue(parameterValue, parameterName, propertyName)).matches()) {
                    this.writer.append('\"');
                    this.writer.append(parameterValue);
                    this.writer.append('\"');
                } else {
                    this.writer.append(parameterValue);
                }
                first = false;
            }
        }
        this.writer.append(':');
        this.writer.append((CharSequence)value, quotedPrintable, charset);
        this.writer.append(this.writer.getNewline());
    }

    private String sanitizeValue(VCardParameters parameters, String value) {
        if (value == null) {
            return "";
        }
        if (this.version == VCardVersion.V2_1 && this.containsNewlines(value)) {
            parameters.setEncoding(Encoding.QUOTED_PRINTABLE);
            return value;
        }
        return this.escapeNewlines(value);
    }

    private String sanitizeParameterValue(String parameterValue, String parameterName, String propertyName) {
        String modifiedValue = null;
        boolean valueChanged = false;
        switch (this.version) {
            case V2_1: {
                modifiedValue = this.removeInvalidParameterValueChars(parameterValue);
                modifiedValue = newlineRegex.matcher(modifiedValue).replaceAll(" ");
                valueChanged = parameterValue != modifiedValue;
                modifiedValue = modifiedValue.replace("\\", "\\\\");
                modifiedValue = modifiedValue.replace(";", "\\;");
                break;
            }
            case V3_0: {
                modifiedValue = this.removeInvalidParameterValueChars(parameterValue);
                if (this.caretEncodingEnabled) {
                    valueChanged = modifiedValue != parameterValue;
                    modifiedValue = this.applyCaretEncoding(modifiedValue);
                    break;
                }
                modifiedValue = modifiedValue.replace('\"', '\'');
                valueChanged = (modifiedValue = newlineRegex.matcher(modifiedValue).replaceAll(" ")) != parameterValue;
                break;
            }
            case V4_0: {
                modifiedValue = this.removeInvalidParameterValueChars(parameterValue);
                if (this.caretEncodingEnabled) {
                    valueChanged = modifiedValue != parameterValue;
                    modifiedValue = this.applyCaretEncoding(modifiedValue);
                    break;
                }
                valueChanged = (modifiedValue = modifiedValue.replace('\"', '\'')) != parameterValue;
                modifiedValue = newlineRegex.matcher(modifiedValue).replaceAll("\\\\\\n");
            }
        }
        if (valueChanged && this.problemsListener != null) {
            this.problemsListener.onParameterValueChanged(propertyName, parameterName, parameterValue, modifiedValue);
        }
        return modifiedValue;
    }

    private String removeInvalidParameterValueChars(String value) {
        BitSet invalidChars = invalidParamValueChars.get((Object)this.version);
        StringBuilder sb = null;
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (invalidChars.get(ch)) {
                if (sb != null) continue;
                sb = new StringBuilder(value.length());
                sb.append(value.substring(0, i));
                continue;
            }
            if (sb == null) continue;
            sb.append(ch);
        }
        return sb == null ? value : sb.toString();
    }

    private String applyCaretEncoding(String value) {
        value = value.replace("^", "^^");
        value = newlineRegex.matcher(value).replaceAll("^n");
        value = value.replace("\"", "^'");
        return value;
    }

    private String escapeNewlines(String text) {
        return newlineRegex.matcher(text).replaceAll("\\\\n");
    }

    private boolean containsNewlines(String text) {
        return newlineRegex.matcher(text).find();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    static {
        BitSet controlChars = new BitSet(128);
        controlChars.set(0, 31);
        controlChars.set(127);
        controlChars.set(9, false);
        controlChars.set(10, false);
        controlChars.set(13, false);
        HashMap<VCardVersion, BitSet> map = new HashMap<VCardVersion, BitSet>();
        BitSet bitSet = new BitSet(128);
        bitSet.or(controlChars);
        bitSet.set(44);
        bitSet.set(46);
        bitSet.set(58);
        bitSet.set(61);
        bitSet.set(91);
        bitSet.set(93);
        map.put(VCardVersion.V2_1, bitSet);
        bitSet = new BitSet(128);
        bitSet.or(controlChars);
        map.put(VCardVersion.V3_0, bitSet);
        map.put(VCardVersion.V4_0, bitSet);
        invalidParamValueChars = Collections.unmodifiableMap(map);
    }

    public static interface ProblemsListener {
        public void onParameterValueChanged(String var1, String var2, String var3, String var4);
    }
}

