/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.io.scribe;

import java.util.List;
import org.opencrx.application.uses.ezvcard.VCardDataType;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.io.scribe.VCardPropertyScribe;
import org.opencrx.application.uses.ezvcard.io.xml.XCardElement;
import org.opencrx.application.uses.ezvcard.parameter.VCardParameters;
import org.opencrx.application.uses.ezvcard.property.VCardProperty;

public abstract class SimplePropertyScribe<T extends VCardProperty>
extends VCardPropertyScribe<T> {
    protected final VCardDataType dataType;

    public SimplePropertyScribe(Class<T> clazz, String propertyName, VCardDataType dataType) {
        super(clazz, propertyName);
        this.dataType = dataType;
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return this.dataType;
    }

    @Override
    protected String _writeText(T property, VCardVersion version) {
        String value = this._writeValue(property);
        return value == null ? "" : SimplePropertyScribe.escape(value);
    }

    @Override
    protected T _parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters, List<String> warnings) {
        value = SimplePropertyScribe.unescape(value);
        return this._parseValue(value);
    }

    @Override
    protected void _writeXml(T property, XCardElement parent) {
        parent.append(this.dataType, this._writeValue(property));
    }

    @Override
    protected T _parseXml(XCardElement element, VCardParameters parameters, List<String> warnings) {
        String value = element.first(this.dataType);
        if (value != null) {
            return this._parseValue(value);
        }
        throw VCardPropertyScribe.missingXmlElements(this.dataType);
    }

    protected abstract String _writeValue(T var1);

    protected abstract T _parseValue(String var1);
}

