/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.io.scribe;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.io.scribe.AddressScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.AgentScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.AnniversaryScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.BirthdayScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.BirthplaceScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.CalendarRequestUriScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.CalendarUriScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.CategoriesScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.ClassificationScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.ClientPidMapScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.DeathdateScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.DeathplaceScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.EmailScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.ExpertiseScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.FormattedNameScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.FreeBusyUrlScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.GenderScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.GeoScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.HobbyScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.ImppScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.InterestScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.KeyScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.KindScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.LabelScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.LanguageScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.LogoScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.MailerScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.MemberScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.NicknameScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.NoteScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.OrgDirectoryScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.OrganizationScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.PhotoScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.ProductIdScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.ProfileScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.RawPropertyScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.RelatedScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.RevisionScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.RoleScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.SortStringScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.SoundScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.SourceDisplayTextScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.SourceScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.StructuredNameScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.TelephoneScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.TimezoneScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.TitleScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.UidScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.UrlScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.VCardPropertyScribe;
import org.opencrx.application.uses.ezvcard.io.scribe.XmlScribe;
import org.opencrx.application.uses.ezvcard.property.RawProperty;
import org.opencrx.application.uses.ezvcard.property.VCardProperty;
import org.opencrx.application.uses.ezvcard.property.Xml;

public class ScribeIndex {
    private static final Map<String, VCardPropertyScribe<? extends VCardProperty>> standardByName = new HashMap<String, VCardPropertyScribe<? extends VCardProperty>>();
    private static final Map<Class<? extends VCardProperty>, VCardPropertyScribe<? extends VCardProperty>> standardByClass = new HashMap<Class<? extends VCardProperty>, VCardPropertyScribe<? extends VCardProperty>>();
    private static final Map<QName, VCardPropertyScribe<? extends VCardProperty>> standardByQName = new HashMap<QName, VCardPropertyScribe<? extends VCardProperty>>();
    private final Map<String, VCardPropertyScribe<? extends VCardProperty>> extendedByName = new HashMap<String, VCardPropertyScribe<? extends VCardProperty>>(0);
    private final Map<Class<? extends VCardProperty>, VCardPropertyScribe<? extends VCardProperty>> extendedByClass = new HashMap<Class<? extends VCardProperty>, VCardPropertyScribe<? extends VCardProperty>>(0);
    private final Map<QName, VCardPropertyScribe<? extends VCardProperty>> extendedByQName = new HashMap<QName, VCardPropertyScribe<? extends VCardProperty>>(0);

    public VCardPropertyScribe<? extends VCardProperty> getPropertyScribe(String propertyName) {
        VCardPropertyScribe<? extends VCardProperty> marshaller = this.extendedByName.get(propertyName = propertyName.toUpperCase());
        if (marshaller != null) {
            return marshaller;
        }
        return standardByName.get(propertyName);
    }

    public boolean hasPropertyScribe(VCardProperty property) {
        if (property instanceof RawProperty) {
            return true;
        }
        return this.getPropertyScribe(property.getClass()) != null;
    }

    public VCardPropertyScribe<? extends VCardProperty> getPropertyScribe(Class<? extends VCardProperty> clazz) {
        VCardPropertyScribe<? extends VCardProperty> marshaller = this.extendedByClass.get(clazz);
        if (marshaller != null) {
            return marshaller;
        }
        return standardByClass.get(clazz);
    }

    public VCardPropertyScribe<? extends VCardProperty> getPropertyScribe(VCardProperty property) {
        if (property instanceof RawProperty) {
            RawProperty raw = (RawProperty)property;
            return new RawPropertyScribe(raw.getPropertyName());
        }
        return this.getPropertyScribe(property.getClass());
    }

    public VCardPropertyScribe<? extends VCardProperty> getPropertyScribe(QName qname) {
        VCardPropertyScribe<? extends VCardProperty> marshaller = this.extendedByQName.get(qname);
        if (marshaller != null) {
            return marshaller;
        }
        marshaller = standardByQName.get(qname);
        if (marshaller != null) {
            return marshaller;
        }
        if (VCardVersion.V4_0.getXmlNamespace().equals(qname.getNamespaceURI())) {
            return new RawPropertyScribe(qname.getLocalPart().toUpperCase());
        }
        return this.getPropertyScribe(Xml.class);
    }

    public void register(VCardPropertyScribe<? extends VCardProperty> scribe) {
        this.extendedByName.put(scribe.getPropertyName().toUpperCase(), scribe);
        this.extendedByClass.put(scribe.getPropertyClass(), scribe);
        this.extendedByQName.put(scribe.getQName(), scribe);
    }

    public void unregister(VCardPropertyScribe<? extends VCardProperty> scribe) {
        this.extendedByName.remove(scribe.getPropertyName().toUpperCase());
        this.extendedByClass.remove(scribe.getPropertyClass());
        this.extendedByQName.remove(scribe.getQName());
    }

    private static void registerStandard(VCardPropertyScribe<? extends VCardProperty> scribe) {
        standardByName.put(scribe.getPropertyName().toUpperCase(), scribe);
        standardByClass.put(scribe.getPropertyClass(), scribe);
        standardByQName.put(scribe.getQName(), scribe);
    }

    static {
        ScribeIndex.registerStandard(new AddressScribe());
        ScribeIndex.registerStandard(new AgentScribe());
        ScribeIndex.registerStandard(new AnniversaryScribe());
        ScribeIndex.registerStandard(new BirthdayScribe());
        ScribeIndex.registerStandard(new CalendarRequestUriScribe());
        ScribeIndex.registerStandard(new CalendarUriScribe());
        ScribeIndex.registerStandard(new CategoriesScribe());
        ScribeIndex.registerStandard(new ClassificationScribe());
        ScribeIndex.registerStandard(new ClientPidMapScribe());
        ScribeIndex.registerStandard(new EmailScribe());
        ScribeIndex.registerStandard(new FreeBusyUrlScribe());
        ScribeIndex.registerStandard(new FormattedNameScribe());
        ScribeIndex.registerStandard(new GenderScribe());
        ScribeIndex.registerStandard(new GeoScribe());
        ScribeIndex.registerStandard(new ImppScribe());
        ScribeIndex.registerStandard(new KeyScribe());
        ScribeIndex.registerStandard(new KindScribe());
        ScribeIndex.registerStandard(new LabelScribe());
        ScribeIndex.registerStandard(new LanguageScribe());
        ScribeIndex.registerStandard(new LogoScribe());
        ScribeIndex.registerStandard(new MailerScribe());
        ScribeIndex.registerStandard(new MemberScribe());
        ScribeIndex.registerStandard(new NicknameScribe());
        ScribeIndex.registerStandard(new NoteScribe());
        ScribeIndex.registerStandard(new OrganizationScribe());
        ScribeIndex.registerStandard(new PhotoScribe());
        ScribeIndex.registerStandard(new ProductIdScribe());
        ScribeIndex.registerStandard(new ProfileScribe());
        ScribeIndex.registerStandard(new RelatedScribe());
        ScribeIndex.registerStandard(new RevisionScribe());
        ScribeIndex.registerStandard(new RoleScribe());
        ScribeIndex.registerStandard(new SortStringScribe());
        ScribeIndex.registerStandard(new SoundScribe());
        ScribeIndex.registerStandard(new SourceDisplayTextScribe());
        ScribeIndex.registerStandard(new SourceScribe());
        ScribeIndex.registerStandard(new StructuredNameScribe());
        ScribeIndex.registerStandard(new TelephoneScribe());
        ScribeIndex.registerStandard(new TimezoneScribe());
        ScribeIndex.registerStandard(new TitleScribe());
        ScribeIndex.registerStandard(new UidScribe());
        ScribeIndex.registerStandard(new UrlScribe());
        ScribeIndex.registerStandard(new XmlScribe());
        ScribeIndex.registerStandard(new BirthplaceScribe());
        ScribeIndex.registerStandard(new DeathdateScribe());
        ScribeIndex.registerStandard(new DeathplaceScribe());
        ScribeIndex.registerStandard(new ExpertiseScribe());
        ScribeIndex.registerStandard(new OrgDirectoryScribe());
        ScribeIndex.registerStandard(new InterestScribe());
        ScribeIndex.registerStandard(new HobbyScribe());
    }
}

