/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.io.scribe;

import java.util.Date;
import java.util.List;
import org.opencrx.application.uses.ezvcard.VCardDataType;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.io.CannotParseException;
import org.opencrx.application.uses.ezvcard.io.scribe.VCardPropertyScribe;
import org.opencrx.application.uses.ezvcard.io.xml.XCardElement;
import org.opencrx.application.uses.ezvcard.parameter.VCardParameters;
import org.opencrx.application.uses.ezvcard.property.Revision;

public class RevisionScribe
extends VCardPropertyScribe<Revision> {
    public RevisionScribe() {
        super(Revision.class, "REV");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return VCardDataType.TIMESTAMP;
    }

    @Override
    protected String _writeText(Revision property, VCardVersion version) {
        return this.write(property, false);
    }

    @Override
    protected Revision _parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters, List<String> warnings) {
        return this.parse(value);
    }

    @Override
    protected void _writeXml(Revision property, XCardElement parent) {
        parent.append(VCardDataType.TIMESTAMP, this.write(property, false));
    }

    @Override
    protected Revision _parseXml(XCardElement element, VCardParameters parameters, List<String> warnings) {
        String value = element.first(VCardDataType.TIMESTAMP);
        if (value != null) {
            return this.parse(value);
        }
        throw RevisionScribe.missingXmlElements(VCardDataType.TIMESTAMP);
    }

    private String write(Revision property, boolean extended) {
        Date timestamp = (Date)property.getValue();
        if (timestamp == null) {
            return "";
        }
        return RevisionScribe.date(timestamp).time(true).utc(true).extended(extended).write();
    }

    private Revision parse(String value) {
        if (value == null || value.length() == 0) {
            return new Revision(null);
        }
        try {
            return new Revision(RevisionScribe.date(value));
        }
        catch (IllegalArgumentException e) {
            throw new CannotParseException(5, new Object[0]);
        }
    }
}

