/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.io.scribe;

import java.util.List;
import org.opencrx.application.uses.ezvcard.VCardDataType;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.io.scribe.VCardPropertyScribe;
import org.opencrx.application.uses.ezvcard.io.xml.XCardElement;
import org.opencrx.application.uses.ezvcard.parameter.VCardParameters;
import org.opencrx.application.uses.ezvcard.property.PlaceProperty;
import org.opencrx.application.uses.ezvcard.util.GeoUri;

public abstract class PlacePropertyScribe<T extends PlaceProperty>
extends VCardPropertyScribe<T> {
    public PlacePropertyScribe(Class<T> clazz, String propertyName) {
        super(clazz, propertyName);
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return VCardDataType.TEXT;
    }

    @Override
    protected VCardDataType _dataType(T property, VCardVersion version) {
        if (((PlaceProperty)property).getText() != null) {
            return VCardDataType.TEXT;
        }
        if (((PlaceProperty)property).getUri() != null || ((PlaceProperty)property).getGeoUri() != null) {
            return VCardDataType.URI;
        }
        return this._defaultDataType(version);
    }

    @Override
    protected String _writeText(T property, VCardVersion version) {
        String text = ((PlaceProperty)property).getText();
        if (text != null) {
            return PlacePropertyScribe.escape(text);
        }
        String uri = ((PlaceProperty)property).getUri();
        if (uri != null) {
            return uri;
        }
        GeoUri geoUri = ((PlaceProperty)property).getGeoUri();
        if (geoUri != null) {
            return geoUri.toString();
        }
        return "";
    }

    @Override
    protected T _parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters, List<String> warnings) {
        T property = this.newInstance();
        value = PlacePropertyScribe.unescape(value);
        if (dataType == VCardDataType.TEXT) {
            ((PlaceProperty)property).setText(value);
            return property;
        }
        if (dataType == VCardDataType.URI) {
            try {
                ((PlaceProperty)property).setGeoUri(GeoUri.parse(value));
            }
            catch (IllegalArgumentException e) {
                ((PlaceProperty)property).setUri(value);
            }
            return property;
        }
        ((PlaceProperty)property).setText(value);
        return property;
    }

    @Override
    protected void _writeXml(T property, XCardElement parent) {
        String text = ((PlaceProperty)property).getText();
        if (text != null) {
            parent.append(VCardDataType.TEXT, text);
            return;
        }
        String uri = ((PlaceProperty)property).getUri();
        if (uri != null) {
            parent.append(VCardDataType.URI, uri);
            return;
        }
        GeoUri geoUri = ((PlaceProperty)property).getGeoUri();
        if (geoUri != null) {
            parent.append(VCardDataType.URI, geoUri.toString());
            return;
        }
        parent.append(VCardDataType.TEXT, "");
    }

    @Override
    protected T _parseXml(XCardElement element, VCardParameters parameters, List<String> warnings) {
        T property = this.newInstance();
        String text = element.first(VCardDataType.TEXT);
        if (text != null) {
            ((PlaceProperty)property).setText(text);
            return property;
        }
        String uri = element.first(VCardDataType.URI);
        if (uri != null) {
            try {
                ((PlaceProperty)property).setGeoUri(GeoUri.parse(uri));
            }
            catch (IllegalArgumentException e) {
                ((PlaceProperty)property).setUri(uri);
            }
            return property;
        }
        throw PlacePropertyScribe.missingXmlElements(VCardDataType.TEXT, VCardDataType.URI);
    }

    protected abstract T newInstance();
}

