/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.io.scribe;

import java.util.List;
import org.opencrx.application.uses.ezvcard.VCard;
import org.opencrx.application.uses.ezvcard.VCardDataType;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.io.scribe.VCardPropertyScribe;
import org.opencrx.application.uses.ezvcard.io.xml.XCardElement;
import org.opencrx.application.uses.ezvcard.parameter.VCardParameters;
import org.opencrx.application.uses.ezvcard.property.Address;

public class AddressScribe
extends VCardPropertyScribe<Address> {
    public AddressScribe() {
        super(Address.class, "ADR");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return VCardDataType.TEXT;
    }

    @Override
    protected void _prepareParameters(Address property, VCardParameters copy, VCardVersion version, VCard vcard) {
        AddressScribe.handlePrefParam(property, copy, version, vcard);
        if (version == VCardVersion.V2_1 || version == VCardVersion.V3_0) {
            copy.removeAll("LABEL");
        }
    }

    @Override
    protected String _writeText(Address property, VCardVersion version) {
        return AddressScribe.structured(property.getPoBox(), property.getExtendedAddress(), property.getStreetAddress(), property.getLocality(), property.getRegion(), property.getPostalCode(), property.getCountry());
    }

    @Override
    protected Address _parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters, List<String> warnings) {
        Address property = new Address();
        VCardPropertyScribe.StructuredIterator it = AddressScribe.structured(value);
        property.setPoBox(it.nextString());
        property.setExtendedAddress(it.nextString());
        property.setStreetAddress(it.nextString());
        property.setLocality(it.nextString());
        property.setRegion(it.nextString());
        property.setPostalCode(it.nextString());
        property.setCountry(it.nextString());
        return property;
    }

    @Override
    protected void _writeXml(Address property, XCardElement parent) {
        parent.append("pobox", property.getPoBox());
        parent.append("ext", property.getExtendedAddress());
        parent.append("street", property.getStreetAddress());
        parent.append("locality", property.getLocality());
        parent.append("region", property.getRegion());
        parent.append("code", property.getPostalCode());
        parent.append("country", property.getCountry());
    }

    @Override
    protected Address _parseXml(XCardElement element, VCardParameters parameters, List<String> warnings) {
        Address property = new Address();
        property.setPoBox(this.sanitizeXml(element, "pobox"));
        property.setExtendedAddress(this.sanitizeXml(element, "ext"));
        property.setStreetAddress(this.sanitizeXml(element, "street"));
        property.setLocality(this.sanitizeXml(element, "locality"));
        property.setRegion(this.sanitizeXml(element, "region"));
        property.setPostalCode(this.sanitizeXml(element, "code"));
        property.setCountry(this.sanitizeXml(element, "country"));
        return property;
    }

    private String sanitizeXml(XCardElement element, String name) {
        String value = element.first(name);
        return value == null || value.length() == 0 ? null : value;
    }
}

