/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.opencrx.application.uses.ezvcard.VCard;
import org.opencrx.application.uses.ezvcard.io.ParseWarnings;
import org.opencrx.application.uses.ezvcard.io.scribe.ScribeIndex;
import org.opencrx.application.uses.ezvcard.io.scribe.VCardPropertyScribe;
import org.opencrx.application.uses.ezvcard.parameter.AddressType;
import org.opencrx.application.uses.ezvcard.property.Address;
import org.opencrx.application.uses.ezvcard.property.Label;
import org.opencrx.application.uses.ezvcard.property.VCardProperty;

public abstract class StreamReader
implements Closeable {
    protected final ParseWarnings warnings = new ParseWarnings();
    protected ScribeIndex index = new ScribeIndex();

    public List<VCard> readAll() throws IOException {
        ArrayList<VCard> vcards = new ArrayList<VCard>();
        VCard vcard = null;
        while ((vcard = this.readNext()) != null) {
            vcards.add(vcard);
        }
        return vcards;
    }

    public VCard readNext() throws IOException {
        this.warnings.clear();
        return this._readNext();
    }

    protected abstract VCard _readNext() throws IOException;

    protected void assignLabels(VCard vcard, List<Label> labels) {
        List<Address> adrs = vcard.getAddresses();
        for (Label label : labels) {
            boolean orphaned = true;
            Set<AddressType> labelTypes = label.getTypes();
            for (Address adr : adrs) {
                if (adr.getLabel() != null || !adr.getTypes().equals(labelTypes)) continue;
                adr.setLabel((String)label.getValue());
                orphaned = false;
                break;
            }
            if (!orphaned) continue;
            vcard.addOrphanedLabel(label);
        }
    }

    public void registerScribe(VCardPropertyScribe<? extends VCardProperty> scribe) {
        this.index.register(scribe);
    }

    public ScribeIndex getScribeIndex() {
        return this.index;
    }

    public void setScribeIndex(ScribeIndex index) {
        this.index = index;
    }

    public List<String> getWarnings() {
        return this.warnings.copy();
    }
}

