/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.shop1.datatypes;

import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import org.opencrx.application.shop1.cci2.ActivityFollowUpT;
import org.opencrx.application.shop1.cci2.ActivityT;
import org.opencrx.application.shop1.cci2.AmountT;
import org.opencrx.application.shop1.cci2.ContactT;
import org.opencrx.application.shop1.cci2.ContractPositionT;
import org.opencrx.application.shop1.cci2.ContractStatusT;
import org.opencrx.application.shop1.cci2.ContractT;
import org.opencrx.application.shop1.cci2.CredentialsT;
import org.opencrx.application.shop1.cci2.CustomerContractT;
import org.opencrx.application.shop1.cci2.CustomerHobbyAndInterestT;
import org.opencrx.application.shop1.cci2.CustomerStatusT;
import org.opencrx.application.shop1.cci2.CustomerT;
import org.opencrx.application.shop1.cci2.DeliveryInformationT;
import org.opencrx.application.shop1.cci2.DocumentT;
import org.opencrx.application.shop1.cci2.EmailAddressT;
import org.opencrx.application.shop1.cci2.InvoiceT;
import org.opencrx.application.shop1.cci2.LegalEntityT;
import org.opencrx.application.shop1.cci2.MessengerAddressT;
import org.opencrx.application.shop1.cci2.PhoneNumberT;
import org.opencrx.application.shop1.cci2.PostalAddressT;
import org.opencrx.application.shop1.cci2.PriceLevelT;
import org.opencrx.application.shop1.cci2.ProductBundleDataT;
import org.opencrx.application.shop1.cci2.ProductConfigurationT;
import org.opencrx.application.shop1.cci2.ProductConfigurationTypeT;
import org.opencrx.application.shop1.cci2.ProductDescriptionT;
import org.opencrx.application.shop1.cci2.ProductPhaseT;
import org.opencrx.application.shop1.cci2.ProductPriceT;
import org.opencrx.application.shop1.cci2.ProductStatusT;
import org.opencrx.application.shop1.cci2.ProductT;
import org.opencrx.application.shop1.cci2.RelatedProductT;
import org.opencrx.application.shop1.cci2.ReturnStatusT;
import org.opencrx.application.shop1.cci2.SalesOrderT;
import org.opencrx.application.shop1.cci2.StringPropertyT;
import org.opencrx.application.shop1.datatypes.AbstractContractFieldMapper;
import org.opencrx.application.shop1.datatypes.AccountFieldMapper;
import org.opencrx.application.shop1.datatypes.DeliveryInformationFieldMapper;
import org.opencrx.application.shop1.datatypes.EmailAddressFieldMapper;
import org.opencrx.application.shop1.datatypes.InvoiceFieldMapper;
import org.opencrx.application.shop1.datatypes.InvoiceState;
import org.opencrx.application.shop1.datatypes.LeadFieldMapper;
import org.opencrx.application.shop1.datatypes.PhoneNumberFieldMapper;
import org.opencrx.application.shop1.datatypes.PostalAddressFieldMapper;
import org.opencrx.application.shop1.datatypes.ProductFieldMapper;
import org.opencrx.application.shop1.datatypes.ProductFilterFieldMapper;
import org.opencrx.application.shop1.datatypes.ProductFilterType;
import org.opencrx.application.shop1.datatypes.PropertySetName;
import org.opencrx.application.shop1.datatypes.SalesOrderFieldMapper;
import org.opencrx.application.shop1.datatypes.SalesOrderState;
import org.opencrx.kernel.account1.cci2.Account;
import org.opencrx.kernel.account1.cci2.AccountHasAccountAddress;
import org.opencrx.kernel.account1.cci2.MemberQuery;
import org.opencrx.kernel.account1.jmi1.AccountAddress;
import org.opencrx.kernel.account1.jmi1.Contact;
import org.opencrx.kernel.account1.jmi1.EMailAddress;
import org.opencrx.kernel.account1.jmi1.LegalEntity;
import org.opencrx.kernel.account1.jmi1.Member;
import org.opencrx.kernel.account1.jmi1.PhoneNumber;
import org.opencrx.kernel.account1.jmi1.PostalAddress;
import org.opencrx.kernel.account1.jmi1.WebAddress;
import org.opencrx.kernel.activity1.cci2.ActivityFollowUpQuery;
import org.opencrx.kernel.activity1.cci2.ActivityHasTrackerAndGroupAssignment;
import org.opencrx.kernel.activity1.jmi1.Activity;
import org.opencrx.kernel.activity1.jmi1.ActivityFollowUp;
import org.opencrx.kernel.activity1.jmi1.ActivityGroupAssignment;
import org.opencrx.kernel.address1.jmi1.PostalAddressable;
import org.opencrx.kernel.backend.Accounts;
import org.opencrx.kernel.backend.Addresses;
import org.opencrx.kernel.base.cci2.Property;
import org.opencrx.kernel.base.cci2.PropertyQuery;
import org.opencrx.kernel.base.jmi1.BasePackage;
import org.opencrx.kernel.base.jmi1.PropertySet;
import org.opencrx.kernel.base.jmi1.StringProperty;
import org.opencrx.kernel.code1.jmi1.CodeValueContainer;
import org.opencrx.kernel.contract1.cci2.AddressContainerContainsContractAddress;
import org.opencrx.kernel.contract1.cci2.ContractContainsAccountAssignment;
import org.opencrx.kernel.contract1.cci2.ContractPositionContainsDeliveryInformation;
import org.opencrx.kernel.contract1.cci2.InvoiceContainsInvoicePosition;
import org.opencrx.kernel.contract1.cci2.SalesOrderContainsSalesOrderPosition;
import org.opencrx.kernel.contract1.jmi1.AbstractContract;
import org.opencrx.kernel.contract1.jmi1.AbstractInvoicePosition;
import org.opencrx.kernel.contract1.jmi1.AbstractSalesOrderPosition;
import org.opencrx.kernel.contract1.jmi1.AccountAssignmentContract;
import org.opencrx.kernel.contract1.jmi1.ContractAddress;
import org.opencrx.kernel.contract1.jmi1.DeliveryInformation;
import org.opencrx.kernel.contract1.jmi1.Invoice;
import org.opencrx.kernel.contract1.jmi1.InvoicePosition;
import org.opencrx.kernel.contract1.jmi1.Lead;
import org.opencrx.kernel.contract1.jmi1.SalesContract;
import org.opencrx.kernel.contract1.jmi1.SalesContractPosition;
import org.opencrx.kernel.contract1.jmi1.SalesOrder;
import org.opencrx.kernel.contract1.jmi1.SalesOrderPosition;
import org.opencrx.kernel.document1.jmi1.Document;
import org.opencrx.kernel.document1.jmi1.DocumentRevision;
import org.opencrx.kernel.document1.jmi1.MediaContent;
import org.opencrx.kernel.generic.cci2.CrxObjectContainsPropertySet;
import org.opencrx.kernel.generic.cci2.DescriptionContainerContainsDescription;
import org.opencrx.kernel.generic.jmi1.CrxObject;
import org.opencrx.kernel.generic.jmi1.Description;
import org.opencrx.kernel.product1.cci2.FilterIncludesProduct;
import org.opencrx.kernel.product1.cci2.ProductConfigurationSetContainsConfiguration;
import org.opencrx.kernel.product1.cci2.ProductConfigurationTypeSetContainsConfigurationType;
import org.opencrx.kernel.product1.cci2.ProductContainsProductPhase;
import org.opencrx.kernel.product1.cci2.ProductFilterGlobalQuery;
import org.opencrx.kernel.product1.cci2.ProductHasRelatedProduct;
import org.opencrx.kernel.product1.cci2.ProductQuery;
import org.opencrx.kernel.product1.jmi1.AbstractPriceLevel;
import org.opencrx.kernel.product1.jmi1.AbstractProductConfiguration;
import org.opencrx.kernel.product1.jmi1.ConfiguredProduct;
import org.opencrx.kernel.product1.jmi1.PricingRule;
import org.opencrx.kernel.product1.jmi1.Product;
import org.opencrx.kernel.product1.jmi1.ProductBasePrice;
import org.opencrx.kernel.product1.jmi1.ProductClassification;
import org.opencrx.kernel.product1.jmi1.ProductClassificationFilterProperty;
import org.opencrx.kernel.product1.jmi1.ProductConfiguration;
import org.opencrx.kernel.product1.jmi1.ProductConfigurationType;
import org.opencrx.kernel.product1.jmi1.ProductConfigurationTypeSet;
import org.opencrx.kernel.product1.jmi1.ProductFilterGlobal;
import org.opencrx.kernel.product1.jmi1.ProductFilterProperty;
import org.opencrx.kernel.product1.jmi1.ProductPhase;
import org.opencrx.kernel.product1.jmi1.RelatedProduct;
import org.opencrx.kernel.product1.jmi1.Segment;
import org.opencrx.kernel.uom1.jmi1.Uom;
import org.opencrx.kernel.utils.QuotaByteArrayOutputStream;
import org.openmdx.base.accessor.spi.IntegerMarshaller;
import org.openmdx.base.accessor.spi.ShortMarshaller;
import org.openmdx.base.collection.MarshallingList;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.kernel.exception.BasicException;
import org.w3c.cci2.BinaryLargeObjects;
import org.w3c.spi2.Datatypes;
import org.w3c.spi2.Structures;

public class DatatypeMappers {
    private AbstractContractFieldMapper abstractContractFieldMapper = null;
    private AccountFieldMapper accountFieldMapper = null;
    private EmailAddressFieldMapper emailAddressFieldMapper = null;
    private InvoiceFieldMapper invoiceFieldMapper = null;
    private LeadFieldMapper leadFieldMapper = null;
    private PhoneNumberFieldMapper phoneNumberFieldMapper = null;
    private PostalAddressFieldMapper postalAddressFieldMapper = null;
    private ProductFieldMapper productFieldMapper = null;
    private ProductFilterFieldMapper productFilterFieldMapper = null;
    private SalesOrderFieldMapper salesOrderFieldMapper = null;
    private DeliveryInformationFieldMapper deliveryInformationFieldMapper = null;

    public static String bigDecimalToString(BigDecimal value) {
        return value == null ? null : value.toPlainString();
    }

    public static Short toShort(Number number) {
        return number == null ? null : new Short(number.shortValue());
    }

    public static Integer toInteger(Number number) {
        return number == null ? null : new Integer(number.intValue());
    }

    public static List<Short> toShortList(List<?> values) {
        return new MarshallingList(ShortMarshaller.NORMALIZE, values);
    }

    public static List<Integer> toIntegerList(List<?> values) {
        return new MarshallingList(IntegerMarshaller.NORMALIZE, values);
    }

    public AbstractContractFieldMapper newAbstractContractFieldMapper() {
        return new AbstractContractFieldMapper();
    }

    public AbstractContractFieldMapper getAbstractContractFieldMapper() {
        if (this.abstractContractFieldMapper == null) {
            this.abstractContractFieldMapper = this.newAbstractContractFieldMapper();
        }
        return this.abstractContractFieldMapper;
    }

    public AccountFieldMapper newAccountFieldMapper() {
        return new AccountFieldMapper();
    }

    public AccountFieldMapper getAccountFieldMapper() {
        if (this.accountFieldMapper == null) {
            this.accountFieldMapper = this.newAccountFieldMapper();
        }
        return this.accountFieldMapper;
    }

    public EmailAddressFieldMapper newEmailAddressFieldMapper() {
        return new EmailAddressFieldMapper();
    }

    public EmailAddressFieldMapper getEmailAddressFieldMapper() {
        if (this.emailAddressFieldMapper == null) {
            this.emailAddressFieldMapper = this.newEmailAddressFieldMapper();
        }
        return this.emailAddressFieldMapper;
    }

    public InvoiceFieldMapper newInvoiceFieldMapper() {
        return new InvoiceFieldMapper();
    }

    public InvoiceFieldMapper getInvoiceFieldMapper() {
        if (this.invoiceFieldMapper == null) {
            this.invoiceFieldMapper = this.newInvoiceFieldMapper();
        }
        return this.invoiceFieldMapper;
    }

    public LeadFieldMapper newLeadFieldMapper() {
        return new LeadFieldMapper();
    }

    public LeadFieldMapper getLeadFieldMapper() {
        if (this.leadFieldMapper == null) {
            this.leadFieldMapper = this.newLeadFieldMapper();
        }
        return this.leadFieldMapper;
    }

    public PhoneNumberFieldMapper newPhoneNumberFieldMapper() {
        return new PhoneNumberFieldMapper();
    }

    public PhoneNumberFieldMapper getPhoneNumberFieldMapper() {
        if (this.phoneNumberFieldMapper == null) {
            this.phoneNumberFieldMapper = this.newPhoneNumberFieldMapper();
        }
        return this.phoneNumberFieldMapper;
    }

    public PostalAddressFieldMapper newPostalAddressFieldMapper() {
        return new PostalAddressFieldMapper();
    }

    public PostalAddressFieldMapper getPostalAddressFieldMapper() {
        if (this.postalAddressFieldMapper == null) {
            this.postalAddressFieldMapper = this.newPostalAddressFieldMapper();
        }
        return this.postalAddressFieldMapper;
    }

    public ProductFieldMapper newProductFieldMapper() {
        return new ProductFieldMapper();
    }

    public ProductFieldMapper getProductFieldMapper() {
        if (this.productFieldMapper == null) {
            this.productFieldMapper = this.newProductFieldMapper();
        }
        return this.productFieldMapper;
    }

    public ProductFilterFieldMapper newProductFilterFieldMapper() {
        return new ProductFilterFieldMapper();
    }

    public ProductFilterFieldMapper getProductFilterFieldMapper() {
        if (this.productFilterFieldMapper == null) {
            this.productFilterFieldMapper = this.newProductFilterFieldMapper();
        }
        return this.productFilterFieldMapper;
    }

    public SalesOrderFieldMapper newSalesOrderFieldMapper() {
        return new SalesOrderFieldMapper();
    }

    public SalesOrderFieldMapper getSalesOrderFieldMapper() {
        if (this.salesOrderFieldMapper == null) {
            this.salesOrderFieldMapper = this.newSalesOrderFieldMapper();
        }
        return this.salesOrderFieldMapper;
    }

    public DeliveryInformationFieldMapper newDeliveryInformationFieldMapper() {
        return new DeliveryInformationFieldMapper();
    }

    public DeliveryInformationFieldMapper getDeliveryInformationFieldMapper() {
        if (this.deliveryInformationFieldMapper == null) {
            this.deliveryInformationFieldMapper = this.newDeliveryInformationFieldMapper();
        }
        return this.deliveryInformationFieldMapper;
    }

    public void mapStringProperty(String name, CodeValueContainer domain, String value, StringProperty property) {
        property.setName(name);
        property.setDomain(domain);
        property.setStringValue(value);
    }

    public StringPropertyT mapStringProperty(StringProperty p) {
        return (StringPropertyT)Datatypes.create(StringPropertyT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)StringPropertyT.Member.name, (Object)p.getName()), Datatypes.member((Enum)StringPropertyT.Member.stringValue, Arrays.asList(p.getStringValue())), Datatypes.member((Enum)StringPropertyT.Member.domain, p.getDomain() == null ? null : p.getDomain().getName())});
    }

    public List<StringPropertyT> mapPropertySet(PropertySet propertySet) {
        if (propertySet == null) {
            return null;
        }
        ArrayList<StringPropertyT> propertiesT = new ArrayList<StringPropertyT>();
        BasePackage basePackage = (BasePackage)propertySet.refOutermostPackage().refPackage("org:opencrx:kernel:base");
        PropertyQuery query = basePackage.createPropertyQuery();
        query.orderByName().ascending();
        String currentName = null;
        ArrayList<String> currentValues = new ArrayList<String>();
        Property currentProperty = null;
        for (Property p : propertySet.getProperty(query)) {
            String stringValue;
            if (!(p instanceof StringProperty)) continue;
            String propertyName = p.getName();
            if (propertyName.indexOf("[") > 0) {
                propertyName = propertyName.substring(0, propertyName.indexOf("["));
            }
            if (!propertyName.equals(currentName)) {
                if (currentName != null) {
                    propertiesT.add((StringPropertyT)Datatypes.create(StringPropertyT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)StringPropertyT.Member.name, (Object)currentName), Datatypes.member((Enum)StringPropertyT.Member.stringValue, currentValues), Datatypes.member((Enum)StringPropertyT.Member.domain, currentProperty.getDomain() == null || currentProperty.getDomain().getName().isEmpty() ? null : currentProperty.getDomain().getName().iterator().next())}));
                }
                currentName = propertyName;
                currentProperty = p;
                currentValues.clear();
            }
            if ((stringValue = ((StringProperty)p).getStringValue()) == null) continue;
            currentValues.add(stringValue);
        }
        if (currentProperty != null) {
            propertiesT.add((StringPropertyT)Datatypes.create(StringPropertyT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)StringPropertyT.Member.name, currentName), Datatypes.member((Enum)StringPropertyT.Member.stringValue, currentValues), Datatypes.member((Enum)StringPropertyT.Member.domain, currentProperty.getDomain() == null || currentProperty.getDomain().getName().isEmpty() ? null : currentProperty.getDomain().getName().iterator().next())}));
        }
        return propertiesT;
    }

    public CustomerT mapCustomer(org.opencrx.kernel.account1.jmi1.Account customer, List<Lead> customerContracts, String shopCategory) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)customer);
        if (customer instanceof LegalEntity) {
            String customerNumber = this.getAccountFieldMapper().getAccountNumber(customer);
            org.opencrx.kernel.generic.jmi1.PropertySet genericData = null;
            CrxObjectContainsPropertySet.PropertySet propertySets = customer.getPropertySet();
            Iterator iterator = propertySets.iterator();
            while (iterator.hasNext()) {
                org.opencrx.kernel.generic.jmi1.PropertySet propertySet = (org.opencrx.kernel.generic.jmi1.PropertySet)iterator.next();
                if (!propertySet.getName().equals(PropertySetName.GenericData.toString())) continue;
                genericData = propertySet;
            }
            Account primaryContact = null;
            MemberQuery memberQuery = (MemberQuery)pm.newQuery(Member.class);
            if (shopCategory != null) {
                memberQuery.thereExistsCategory().equalTo((Object)shopCategory);
            }
            memberQuery.thereExistsMemberRole().equalTo((Object)11);
            List members = customer.getMember(memberQuery);
            if (!members.isEmpty()) {
                primaryContact = ((Member)members.iterator().next()).getAccount();
            }
            AccountAddress[] addresses = Accounts.getInstance().getMainAddresses(customer);
            LegalEntity legalEntity = (LegalEntity)customer;
            ArrayList<CustomerContractT> customerContractsT = new ArrayList<CustomerContractT>();
            if (customerContracts != null) {
                for (Lead customerContract : customerContracts) {
                    customerContractsT.add(this.mapCustomerContract(customerContract));
                }
            }
            return (CustomerT)Datatypes.create(CustomerT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)CustomerT.Member.customerNumber, (Object)customerNumber), Datatypes.member((Enum)CustomerT.Member.externalId, customer.getExternalLink()), Datatypes.member((Enum)CustomerT.Member.accountRating, (Object)DatatypeMappers.toInteger(legalEntity.getAccountRating())), Datatypes.member((Enum)CustomerT.Member.accountCategory, DatatypeMappers.toIntegerList(legalEntity.getAccountCategory())), Datatypes.member((Enum)CustomerT.Member.legalEntity, (Object)Datatypes.create(LegalEntityT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)LegalEntityT.Member.legalName, (Object)legalEntity.getName()), Datatypes.member((Enum)LegalEntityT.Member.postalAddressBusiness, (Object)this.mapPostalAddress((PostalAddress)addresses[6])), Datatypes.member((Enum)LegalEntityT.Member.emailAddressBusiness, (Object)this.mapEmailAddress((EMailAddress)addresses[0])), Datatypes.member((Enum)LegalEntityT.Member.phoneNumberBusiness, (Object)this.mapPhoneNumber((PhoneNumber)addresses[2])), Datatypes.member((Enum)LegalEntityT.Member.faxNumberBusiness, (Object)this.mapPhoneNumber((PhoneNumber)addresses[4])), Datatypes.member((Enum)LegalEntityT.Member.webAddressBusiness, addresses[7] == null ? null : ((WebAddress)addresses[7]).getWebUrl()), Datatypes.member((Enum)LegalEntityT.Member.primaryContactNumber, primaryContact == null ? null : this.getAccountFieldMapper().getAccountNumber((org.opencrx.kernel.account1.jmi1.Account)primaryContact))})), Datatypes.member((Enum)CustomerT.Member.customerStatus, (Object)this.mapCustomerStatus(customer)), Datatypes.member((Enum)CustomerT.Member.customerContract, customerContractsT), Datatypes.member((Enum)CustomerT.Member.genericData, this.mapPropertySet(genericData))});
        }
        Contact contact = (Contact)customer;
        AccountAddress[] addresses = Accounts.getInstance().getMainAddresses(customer);
        ArrayList<MessengerAddressT> messengerAddresses = new ArrayList<MessengerAddressT>();
        AccountHasAccountAddress.Address accountAddresses = customer.getAddress();
        Iterator memberQuery = accountAddresses.iterator();
        while (memberQuery.hasNext()) {
            AccountAddress address = (AccountAddress)memberQuery.next();
            if (!(address instanceof PhoneNumber) || !address.getUsage().contains(Addresses.USAGE_OTHER)) continue;
            messengerAddresses.add(this.mapMessengerAddress((PhoneNumber)address));
        }
        String customerNumber = this.getAccountFieldMapper().getAccountNumber(customer);
        org.opencrx.kernel.generic.jmi1.PropertySet genericData = null;
        org.opencrx.kernel.generic.jmi1.PropertySet bookmarks = null;
        CrxObjectContainsPropertySet.PropertySet propertySets = customer.getPropertySet();
        Object customerContractsT = propertySets.iterator();
        while (customerContractsT.hasNext()) {
            org.opencrx.kernel.generic.jmi1.PropertySet propertySet = (org.opencrx.kernel.generic.jmi1.PropertySet)customerContractsT.next();
            if (propertySet.getName().equals(PropertySetName.GenericData.toString())) {
                genericData = propertySet;
                continue;
            }
            if (!propertySet.getName().equals(PropertySetName.Bookmarks.toString())) continue;
            bookmarks = propertySet;
        }
        customerContractsT = new ArrayList();
        if (customerContracts != null) {
            for (Lead customerContract : customerContracts) {
                customerContractsT.add(this.mapCustomerContract(customerContract));
            }
        }
        return (CustomerT)Datatypes.create(CustomerT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)CustomerT.Member.customerNumber, (Object)customerNumber), Datatypes.member((Enum)CustomerT.Member.externalId, customer.getExternalLink()), Datatypes.member((Enum)CustomerT.Member.accountRating, (Object)DatatypeMappers.toInteger(contact.getAccountRating())), Datatypes.member((Enum)CustomerT.Member.accountCategory, DatatypeMappers.toIntegerList(contact.getAccountCategory())), Datatypes.member((Enum)CustomerT.Member.contact, (Object)Datatypes.create(ContactT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ContactT.Member.organization, (Object)contact.getOrganization()), Datatypes.member((Enum)ContactT.Member.salutationCode, (Object)DatatypeMappers.toInteger(contact.getSalutationCode())), Datatypes.member((Enum)ContactT.Member.salutation, (Object)contact.getSalutation()), Datatypes.member((Enum)ContactT.Member.title, (Object)this.getAccountFieldMapper().getTitle(customer)), Datatypes.member((Enum)ContactT.Member.firstName, (Object)contact.getFirstName()), Datatypes.member((Enum)ContactT.Member.lastName, (Object)contact.getLastName()), Datatypes.member((Enum)ContactT.Member.middleName, (Object)contact.getMiddleName()), Datatypes.member((Enum)ContactT.Member.nickName, (Object)contact.getNickName()), Datatypes.member((Enum)ContactT.Member.birthDate, (Object)contact.getBirthdate()), Datatypes.member((Enum)ContactT.Member.placeOfBirth, (Object)this.getAccountFieldMapper().getPlaceOfBirth(customer)), Datatypes.member((Enum)ContactT.Member.birthDateIsValidated, (Object)this.getAccountFieldMapper().getBirthDateIsValidated(customer)), Datatypes.member((Enum)ContactT.Member.doNotPostalMail, (Object)contact.isDoNotPostalMail()), Datatypes.member((Enum)ContactT.Member.doNotEmail, (Object)contact.isDoNotEMail()), Datatypes.member((Enum)ContactT.Member.doNotPhone, (Object)contact.isDoNotPhone()), Datatypes.member((Enum)ContactT.Member.doNotFax, (Object)contact.isDoNotFax()), Datatypes.member((Enum)ContactT.Member.nativeLanguage, (Object)this.getAccountFieldMapper().getNativeLanguage(customer)), Datatypes.member((Enum)ContactT.Member.preferredSpokenLanguage, (Object)DatatypeMappers.toInteger(contact.getPreferredSpokenLanguage())), Datatypes.member((Enum)ContactT.Member.preferredWrittenLanguage, (Object)DatatypeMappers.toInteger(contact.getPreferredWrittenLanguage())), Datatypes.member((Enum)ContactT.Member.gender, (Object)DatatypeMappers.toInteger(contact.getGender())), Datatypes.member((Enum)ContactT.Member.jobRole, (Object)this.getAccountFieldMapper().getJobRole(customer)), Datatypes.member((Enum)ContactT.Member.jobTitle, (Object)contact.getJobTitle()), Datatypes.member((Enum)ContactT.Member.citizenship, DatatypeMappers.toIntegerList(contact.getCitizenship())), Datatypes.member((Enum)ContactT.Member.education, (Object)DatatypeMappers.toInteger(contact.getEducation())), Datatypes.member((Enum)ContactT.Member.annualIncomeAmount, (Object)this.getAccountFieldMapper().getAnnualIncomeAmount(customer)), Datatypes.member((Enum)ContactT.Member.annualIncomeCurrency, (Object)this.getAccountFieldMapper().getAnnualIncomeCurrency(customer)), Datatypes.member((Enum)ContactT.Member.monthlyIncomeAmount, (Object)this.getAccountFieldMapper().getMonthlyIncomeAmount(customer)), Datatypes.member((Enum)ContactT.Member.monthlyIncomeCurrency, (Object)this.getAccountFieldMapper().getMonthlyIncomeCurrency(customer)), Datatypes.member((Enum)ContactT.Member.numberOfChildren, (Object)DatatypeMappers.toInteger(contact.getNumberOfChildren())), Datatypes.member((Enum)ContactT.Member.childrenNames, contact.getChildrenNames()), Datatypes.member((Enum)ContactT.Member.familyStatus, (Object)DatatypeMappers.toInteger(contact.getFamilyStatus())), Datatypes.member((Enum)ContactT.Member.preferredContactMethod, (Object)DatatypeMappers.toInteger(contact.getPreferredContactMethod())), Datatypes.member((Enum)ContactT.Member.religion, DatatypeMappers.toIntegerList(contact.getReligion())), Datatypes.member((Enum)ContactT.Member.postalAddressHome, (Object)this.mapPostalAddress((PostalAddress)addresses[8])), Datatypes.member((Enum)ContactT.Member.emailAddressHome, (Object)this.mapEmailAddress((EMailAddress)addresses[1])), Datatypes.member((Enum)ContactT.Member.faxNumberHome, (Object)this.mapPhoneNumber((PhoneNumber)addresses[5])), Datatypes.member((Enum)ContactT.Member.phoneNumberHome, (Object)this.mapPhoneNumber((PhoneNumber)addresses[3])), Datatypes.member((Enum)ContactT.Member.webAddressHome, addresses[9] == null ? null : ((WebAddress)addresses[9]).getWebUrl()), Datatypes.member((Enum)ContactT.Member.postalAddressBusiness, (Object)this.mapPostalAddress((PostalAddress)addresses[6])), Datatypes.member((Enum)ContactT.Member.emailAddressBusiness, (Object)this.mapEmailAddress((EMailAddress)addresses[0])), Datatypes.member((Enum)ContactT.Member.phoneNumberBusiness, (Object)this.mapPhoneNumber((PhoneNumber)addresses[2])), Datatypes.member((Enum)ContactT.Member.faxNumberBusiness, (Object)this.mapPhoneNumber((PhoneNumber)addresses[4])), Datatypes.member((Enum)ContactT.Member.phoneNumberMobile, (Object)this.mapPhoneNumber((PhoneNumber)addresses[10])), Datatypes.member((Enum)ContactT.Member.messengerAddress, messengerAddresses), Datatypes.member((Enum)ContactT.Member.webAddressBusiness, addresses[7] == null ? null : ((WebAddress)addresses[7]).getWebUrl()), Datatypes.member((Enum)ContactT.Member.blogAddress, (Object)this.getAccountFieldMapper().getBlogAddress(customer)), Datatypes.member((Enum)ContactT.Member.communityStatus, (Object)this.getAccountFieldMapper().getCommunityStatus(customer)), Datatypes.member((Enum)ContactT.Member.commerceStatus, (Object)this.getAccountFieldMapper().getCommerceStatus(customer)), Datatypes.member((Enum)ContactT.Member.personsInHousehold, (Object)this.getAccountFieldMapper().getPersonsInHousehold(customer)), Datatypes.member((Enum)ContactT.Member.professionalSkills, (Object)this.getAccountFieldMapper().getProfessionalSkills(customer)), Datatypes.member((Enum)ContactT.Member.internetUsage, (Object)this.getAccountFieldMapper().getInternetUsage(customer)), Datatypes.member((Enum)ContactT.Member.internetProvider, (Object)this.getAccountFieldMapper().getInternetProvider(customer)), Datatypes.member((Enum)ContactT.Member.pcUsage, this.getAccountFieldMapper().getPcUsage(customer)), Datatypes.member((Enum)ContactT.Member.portalRating, (Object)this.getAccountFieldMapper().getPortalRating(customer)), Datatypes.member((Enum)ContactT.Member.hobbyAndInterest, (Object)this.mapCustomerHobbyAndInterst(contact)), Datatypes.member((Enum)ContactT.Member.bookmarks, this.mapPropertySet(bookmarks))})), Datatypes.member((Enum)CustomerT.Member.customerStatus, (Object)this.mapCustomerStatus(customer)), Datatypes.member((Enum)CustomerT.Member.customerContract, (Object)customerContractsT), Datatypes.member((Enum)CustomerT.Member.genericData, this.mapPropertySet(genericData))});
    }

    public CustomerHobbyAndInterestT mapCustomerHobbyAndInterst(Contact contact) {
        return (CustomerHobbyAndInterestT)Datatypes.create(CustomerHobbyAndInterestT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)CustomerHobbyAndInterestT.Member.sports, this.getAccountFieldMapper().getSports(contact)), Datatypes.member((Enum)CustomerHobbyAndInterestT.Member.travel, this.getAccountFieldMapper().getTravel(contact)), Datatypes.member((Enum)CustomerHobbyAndInterestT.Member.finance, this.getAccountFieldMapper().getFinance(contact)), Datatypes.member((Enum)CustomerHobbyAndInterestT.Member.computerInternet, this.getAccountFieldMapper().getComputerInternet(contact)), Datatypes.member((Enum)CustomerHobbyAndInterestT.Member.telecommunication, this.getAccountFieldMapper().getTelecommunication(contact)), Datatypes.member((Enum)CustomerHobbyAndInterestT.Member.entertainment, this.getAccountFieldMapper().getEntertainment(contact)), Datatypes.member((Enum)CustomerHobbyAndInterestT.Member.music, this.getAccountFieldMapper().getMusic(contact)), Datatypes.member((Enum)CustomerHobbyAndInterestT.Member.lifestyle, this.getAccountFieldMapper().getLifestyle(contact)), Datatypes.member((Enum)CustomerHobbyAndInterestT.Member.other, this.getAccountFieldMapper().getOther(contact))});
    }

    public ReturnStatusT mapOperationStatus(Exception e) {
        return (ReturnStatusT)Datatypes.create(ReturnStatusT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ReturnStatusT.Member.returnCode, (Object)-23), Datatypes.member((Enum)ReturnStatusT.Member.returnParams, (Object)new String[]{e.getClass().getName(), e.getMessage() == null ? "" : e.getMessage()})});
    }

    public ReturnStatusT mapOperationStatus(int exceptionCode, String[] parameters) {
        ArrayList returnParams = new ArrayList();
        if (parameters != null) {
            for (Object param : returnParams) {
                if (param == null) continue;
                returnParams.add(param);
            }
        }
        return (ReturnStatusT)Datatypes.create(ReturnStatusT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ReturnStatusT.Member.returnCode, (Object)exceptionCode), Datatypes.member((Enum)ReturnStatusT.Member.returnParams, returnParams)});
    }

    public List<String> mapProductClassifications(List<ProductClassification> classifications) {
        ArrayList<String> classificationIds = new ArrayList<String>();
        for (ProductClassification classification : classifications) {
            classificationIds.add(classification.getName());
        }
        return classificationIds;
    }

    public ProductConfigurationT mapProductConfiguration(AbstractProductConfiguration configuration) {
        return (ProductConfigurationT)Datatypes.create(ProductConfigurationT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ProductConfigurationT.Member.propertySetName, (Object)configuration.getName()), Datatypes.member((Enum)ProductConfigurationT.Member.property, this.mapPropertySet(configuration))});
    }

    public ProductConfigurationTypeT mapProductConfigurationTypeSet(ProductConfigurationTypeSet configurationTypeSet) {
        ArrayList<ProductConfigurationT> configurationsT = new ArrayList<ProductConfigurationT>();
        ProductConfigurationTypeSetContainsConfigurationType.ConfigurationType configurationTypes = configurationTypeSet.getConfigurationType();
        Iterator iterator = configurationTypes.iterator();
        while (iterator.hasNext()) {
            ProductConfigurationType configurationType = (ProductConfigurationType)iterator.next();
            configurationsT.add(this.mapProductConfiguration(configurationType));
        }
        return (ProductConfigurationTypeT)Datatypes.create(ProductConfigurationTypeT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ProductConfigurationTypeT.Member.name, (Object)configurationTypeSet.getName()), Datatypes.member((Enum)ProductConfigurationTypeT.Member.configuration, configurationsT)});
    }

    public List<String> mapUoms(List<Uom> uoms) {
        ArrayList<String> uomNames = new ArrayList<String>();
        for (Uom uom : uoms) {
            uomNames.add(uom.getName());
        }
        return uomNames;
    }

    public List<ProductDescriptionT> mapProductDescriptions(Collection<Description> descriptions) {
        ArrayList<ProductDescriptionT> descriptionsT = new ArrayList<ProductDescriptionT>();
        for (Description description : descriptions) {
            descriptionsT.add((ProductDescriptionT)Datatypes.create(ProductDescriptionT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ProductDescriptionT.Member.language, (Object)DatatypeMappers.toInteger(description.getLanguage())), Datatypes.member((Enum)ProductDescriptionT.Member.description, (Object)description.getDescription()), Datatypes.member((Enum)ProductDescriptionT.Member.detailedDescription, (Object)description.getDetailedDescription())}));
        }
        return descriptionsT;
    }

    public PostalAddressT mapPostalAddress(PostalAddressable address) {
        if (address == null) {
            return null;
        }
        return (PostalAddressT)Datatypes.create(PostalAddressT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)PostalAddressT.Member.postalAddressLine0, address.getPostalAddressLine().size() >= 1 ? address.getPostalAddressLine().get(0) : null), Datatypes.member((Enum)PostalAddressT.Member.postalAddressLine1, address.getPostalAddressLine().size() >= 2 ? address.getPostalAddressLine().get(1) : null), Datatypes.member((Enum)PostalAddressT.Member.postalAddressLine2, address.getPostalAddressLine().size() >= 3 ? address.getPostalAddressLine().get(2) : null), Datatypes.member((Enum)PostalAddressT.Member.postalStreet0, address.getPostalStreet().size() >= 1 ? address.getPostalStreet().get(0) : null), Datatypes.member((Enum)PostalAddressT.Member.postalStreet1, address.getPostalStreet().size() >= 2 ? address.getPostalStreet().get(1) : null), Datatypes.member((Enum)PostalAddressT.Member.postalStreetNumber, (Object)this.getPostalAddressFieldMapper().getPostalStreetNumber(address)), Datatypes.member((Enum)PostalAddressT.Member.postalCity, (Object)address.getPostalCity()), Datatypes.member((Enum)PostalAddressT.Member.postalCountry, (Object)DatatypeMappers.toInteger(address.getPostalCountry())), Datatypes.member((Enum)PostalAddressT.Member.postalCode, (Object)address.getPostalCode())});
    }

    public ContractPositionT mapContractPosition(SalesContractPosition position, String contractNumber, Date paymentDate, Product product) {
        ArrayList<DeliveryInformationT> deliveryInformationsT = new ArrayList<DeliveryInformationT>();
        ContractPositionContainsDeliveryInformation.DeliveryInformation deliveryInformations = position.getDeliveryInformation();
        Iterator iterator = deliveryInformations.iterator();
        while (iterator.hasNext()) {
            DeliveryInformation deliveryInformation = (DeliveryInformation)iterator.next();
            deliveryInformationsT.add(this.mapDeliveryInformation(deliveryInformation));
        }
        ProductConfiguration actualProductConfiguration = null;
        if (position instanceof ConfiguredProduct) {
            ConfiguredProduct configuredProduct = (ConfiguredProduct)((Object)position);
            actualProductConfiguration = configuredProduct.getCurrentConfig();
        }
        return (ContractPositionT)Datatypes.create(ContractPositionT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ContractPositionT.Member.contractNumber, (Object)contractNumber), Datatypes.member((Enum)ContractPositionT.Member.externalLink, position instanceof CrxObject ? ((CrxObject)((Object)position)).getExternalLink() : Collections.emptyList()), Datatypes.member((Enum)ContractPositionT.Member.paymentDate, (Object)paymentDate), Datatypes.member((Enum)ContractPositionT.Member.positionNumber, (Object)position.getPositionNumber()), Datatypes.member((Enum)ContractPositionT.Member.productNumber, (Object)product.getProductNumber()), Datatypes.member((Enum)ContractPositionT.Member.salesTaxType, position.getSalesTaxType() == null ? null : position.getSalesTaxType().getName()), Datatypes.member((Enum)ContractPositionT.Member.quantity, (Object)DatatypeMappers.bigDecimalToString(position.getQuantity())), Datatypes.member((Enum)ContractPositionT.Member.pricePerUnit, (Object)DatatypeMappers.bigDecimalToString(position.getPricePerUnit())), Datatypes.member((Enum)ContractPositionT.Member.baseAmount, (Object)DatatypeMappers.bigDecimalToString(position.getBaseAmount())), Datatypes.member((Enum)ContractPositionT.Member.taxAmount, (Object)DatatypeMappers.bigDecimalToString(position.getTaxAmount())), Datatypes.member((Enum)ContractPositionT.Member.amount, (Object)DatatypeMappers.bigDecimalToString(position.getAmount())), Datatypes.member((Enum)ContractPositionT.Member.pricingDate, (Object)position.getPricingDate()), Datatypes.member((Enum)ContractPositionT.Member.priceUom, (Object)position.getPriceUom().getName()), Datatypes.member((Enum)ContractPositionT.Member.positionName, (Object)position.getName()), Datatypes.member((Enum)ContractPositionT.Member.discount, (Object)DatatypeMappers.bigDecimalToString(position.getDiscount())), Datatypes.member((Enum)ContractPositionT.Member.discountIsPercentage, (Object)position.isDiscountIsPercentage()), Datatypes.member((Enum)ContractPositionT.Member.discountAmount, (Object)DatatypeMappers.bigDecimalToString(position.getDiscountAmount())), Datatypes.member((Enum)ContractPositionT.Member.actualProductConfiguration, actualProductConfiguration == null ? null : this.mapProductConfiguration(actualProductConfiguration)), Datatypes.member((Enum)ContractPositionT.Member.deliveryInformation, deliveryInformationsT)});
    }

    public ContractT mapContract(SalesContract contract, List<String> externalLink, List<ContractPositionT> positions) {
        PostalAddressT postalAddressDeliveryT = null;
        PostalAddressT postalAddressInvoiceT = null;
        AddressContainerContainsContractAddress.Address addresses = contract.getAddress();
        Iterator iterator = addresses.iterator();
        while (iterator.hasNext()) {
            ContractAddress address = (ContractAddress)iterator.next();
            if (address instanceof PostalAddressable && !address.getUsage().isEmpty() && address.getUsage().get(0).compareTo(Addresses.USAGE_CONTRACT_DELIVERY) == 0) {
                postalAddressDeliveryT = this.mapPostalAddress((PostalAddressable)((Object)address));
                continue;
            }
            if (!(address instanceof PostalAddressable) || address.getUsage().isEmpty() || address.getUsage().get(0).compareTo(Addresses.USAGE_CONTRACT_INVOICE) != 0) continue;
            postalAddressInvoiceT = this.mapPostalAddress((PostalAddressable)((Object)address));
        }
        return (ContractT)Datatypes.create(ContractT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ContractT.Member.contractNumber, (Object)contract.getContractNumber()), Datatypes.member((Enum)ContractT.Member.externalId, externalLink), Datatypes.member((Enum)ContractT.Member.customerNumber, (Object)this.getAccountFieldMapper().getAccountNumber(contract.getCustomer())), Datatypes.member((Enum)ContractT.Member.activeOn, (Object)contract.getActiveOn()), Datatypes.member((Enum)ContractT.Member.expiresOn, (Object)contract.getExpiresOn()), Datatypes.member((Enum)ContractT.Member.cancelOn, (Object)contract.getCancelOn()), Datatypes.member((Enum)ContractT.Member.closedOn, (Object)contract.getClosedOn()), Datatypes.member((Enum)ContractT.Member.isGift, (Object)contract.isGift()), Datatypes.member((Enum)ContractT.Member.giftMessage, (Object)contract.getGiftMessage()), Datatypes.member((Enum)ContractT.Member.contractCurrency, (Object)DatatypeMappers.toInteger(contract.getContractCurrency())), Datatypes.member((Enum)ContractT.Member.totalBaseAmount, (Object)DatatypeMappers.bigDecimalToString(contract.getTotalBaseAmount())), Datatypes.member((Enum)ContractT.Member.totalDiscountAmount, (Object)DatatypeMappers.bigDecimalToString(contract.getTotalDiscountAmount())), Datatypes.member((Enum)ContractT.Member.totalAmount, (Object)DatatypeMappers.bigDecimalToString(contract.getTotalAmount())), Datatypes.member((Enum)ContractT.Member.totalTaxAmount, (Object)DatatypeMappers.bigDecimalToString(contract.getTotalTaxAmount())), Datatypes.member((Enum)ContractT.Member.totalAmountIncludingTax, (Object)DatatypeMappers.bigDecimalToString(contract.getTotalAmountIncludingTax())), Datatypes.member((Enum)ContractT.Member.position, positions), Datatypes.member((Enum)ContractT.Member.contractStatus, (Object)this.mapContractStatus(contract)), Datatypes.member((Enum)ContractT.Member.postalAddressDelivery, (Object)postalAddressDeliveryT), Datatypes.member((Enum)ContractT.Member.postalAddressInvoice, (Object)postalAddressInvoiceT), Datatypes.member((Enum)ContractT.Member.billingPartner, (Object)this.getAbstractContractFieldMapper().getBillingPartner(contract)), Datatypes.member((Enum)ContractT.Member.billingPartnerRegistrationId, this.getAbstractContractFieldMapper().getBillingPartnerRegistrationId(contract))});
    }

    public InvoiceT mapInvoice(Invoice invoice) {
        InvoiceContainsInvoicePosition.Position positions = invoice.getPosition();
        return (InvoiceT)Datatypes.create(InvoiceT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)InvoiceT.Member.contract, (Object)this.mapContract(invoice, invoice.getExternalLink(), this.mapInvoicePositions(invoice.getContractNumber(), this.getInvoiceFieldMapper().getPaymentDate(invoice), (Collection<AbstractInvoicePosition>)((Object)positions)))), Datatypes.member((Enum)InvoiceT.Member.isVoucher, (Object)this.getInvoiceFieldMapper().isVoucher(invoice)), Datatypes.member((Enum)InvoiceT.Member.paymentDate, (Object)this.getInvoiceFieldMapper().getPaymentDate(invoice))});
    }

    public void mapSalesOrder(SalesOrder salesOrder, SalesContract origin, org.opencrx.kernel.account1.jmi1.Account customer, String invoiceNumber, SalesOrderState salesOrderState, Integer contractCurrency, Date activeOn, Date expiresOn, Date cancelOn, Date closedOn, Boolean isGift, String giftMessage, PricingRule defaultPricingRule) {
        salesOrder.setName(invoiceNumber + " / " + this.getAccountFieldMapper().getAccountNumber(customer));
        salesOrder.setOrigin(origin);
        salesOrder.setCustomer(customer);
        salesOrder.setContractState(DatatypeMappers.toShort(salesOrderState.getValue()));
        salesOrder.setContractCurrency(contractCurrency == null ? origin.getContractCurrency() : contractCurrency.shortValue());
        salesOrder.setActiveOn(activeOn);
        salesOrder.setExpiresOn(expiresOn);
        salesOrder.setCancelOn(cancelOn);
        salesOrder.setClosedOn(closedOn);
        salesOrder.setGift(Boolean.TRUE.equals(isGift));
        salesOrder.setGiftMessage(giftMessage);
        this.getAbstractContractFieldMapper().setBillingPartner(salesOrder, this.getAbstractContractFieldMapper().getBillingPartner(origin));
        this.getAbstractContractFieldMapper().setBillingPartnerRegistrationId(salesOrder, this.getAbstractContractFieldMapper().getBillingPartnerRegistrationId(origin));
        salesOrder.setPricingRule(origin.getPricingRule() == null ? defaultPricingRule : origin.getPricingRule());
        salesOrder.setCalcRule(origin.getCalcRule());
        salesOrder.setContractLanguage(origin.getContractLanguage());
        salesOrder.setContractNumber(invoiceNumber);
    }

    public void mapInvoice(Invoice invoice, SalesContract origin, org.opencrx.kernel.account1.jmi1.Account customer, String invoiceNumber, Boolean isVoucher, InvoiceState invoiceState, PricingRule defaultPricingRule) {
        invoice.setName(invoiceNumber + " / " + this.getAccountFieldMapper().getAccountNumber(customer));
        invoice.setOrigin(origin);
        invoice.setCustomer(customer);
        invoice.setContractState(DatatypeMappers.toShort(invoiceState.getValue()));
        invoice.setContractCurrency(origin.getContractCurrency());
        invoice.setActiveOn(origin.getActiveOn());
        invoice.setExpiresOn(origin.getExpiresOn());
        invoice.setCancelOn(origin.getCancelOn());
        invoice.setClosedOn(origin.getClosedOn());
        this.getAbstractContractFieldMapper().setBillingPartner(invoice, this.getAbstractContractFieldMapper().getBillingPartner(origin));
        this.getAbstractContractFieldMapper().setBillingPartnerRegistrationId(invoice, this.getAbstractContractFieldMapper().getBillingPartnerRegistrationId(origin));
        invoice.setPricingRule(origin.getPricingRule() == null ? defaultPricingRule : origin.getPricingRule());
        invoice.setContractNumber(invoiceNumber);
        invoice.setCalcRule(origin.getCalcRule());
        invoice.setContractLanguage(origin.getContractLanguage());
        this.getInvoiceFieldMapper().setIsVoucher(invoice, isVoucher);
    }

    public SalesOrderT mapSalesOrder(SalesOrder salesOrder) {
        SalesOrderContainsSalesOrderPosition.Position positions = salesOrder.getPosition();
        return (SalesOrderT)Datatypes.create(SalesOrderT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)SalesOrderT.Member.contract, (Object)this.mapContract(salesOrder, salesOrder.getExternalLink(), this.mapSalesOrderPositions(salesOrder.getContractNumber(), (Collection<AbstractSalesOrderPosition>)((Object)positions))))});
    }

    public List<ContractPositionT> mapInvoicePositions(String contractNumber, Date paymentDate, Collection<AbstractInvoicePosition> positions) {
        ArrayList<ContractPositionT> positionsT = new ArrayList<ContractPositionT>();
        for (AbstractInvoicePosition position : positions) {
            if (!(position instanceof InvoicePosition)) continue;
            InvoicePosition invoicePosition = (InvoicePosition)position;
            positionsT.add(this.mapContractPosition(invoicePosition, contractNumber, paymentDate, invoicePosition.getProduct()));
        }
        return positionsT;
    }

    public List<ContractPositionT> mapSalesOrderPositions(String contractNumber, Collection<AbstractSalesOrderPosition> positions) {
        ArrayList<ContractPositionT> positionsT = new ArrayList<ContractPositionT>();
        for (AbstractSalesOrderPosition position : positions) {
            if (!(position instanceof SalesOrderPosition)) continue;
            SalesOrderPosition salesOrderPosition = (SalesOrderPosition)position;
            positionsT.add(this.mapContractPosition(salesOrderPosition, contractNumber, null, salesOrderPosition.getProduct()));
        }
        return positionsT;
    }

    public ContractStatusT mapContractStatus(AbstractContract contract) {
        CrxObjectContainsPropertySet.PropertySet propertySets = contract.getPropertySet();
        List<Object> tags = new ArrayList();
        Iterator iterator = propertySets.iterator();
        while (iterator.hasNext()) {
            org.opencrx.kernel.generic.jmi1.PropertySet propertySet = (org.opencrx.kernel.generic.jmi1.PropertySet)iterator.next();
            if (!propertySet.getName().equals((Object)((Object)PropertySetName.ContractStatus) + "." + contract.getContractState())) continue;
            tags = this.mapPropertySet(propertySet);
            break;
        }
        return (ContractStatusT)Datatypes.create(ContractStatusT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ContractStatusT.Member.status, (Object)DatatypeMappers.toInteger(contract.getContractState())), Datatypes.member((Enum)ContractStatusT.Member.description, (Object)contract.getDescription()), Datatypes.member((Enum)ContractStatusT.Member.tag, tags)});
    }

    public MessengerAddressT mapMessengerAddress(PhoneNumber messengerAddress) {
        if (messengerAddress == null) {
            return null;
        }
        return (MessengerAddressT)Datatypes.create(MessengerAddressT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)MessengerAddressT.Member.messengerId, (Object)messengerAddress.getPhoneNumberFull()), Datatypes.member((Enum)MessengerAddressT.Member.providerName, (Object)this.getPhoneNumberFieldMapper().getProviderName(messengerAddress)), Datatypes.member((Enum)MessengerAddressT.Member.providerVerified, (Object)this.getPhoneNumberFieldMapper().isProviderVerified(messengerAddress))});
    }

    public CustomerContractT mapCustomerContract(Lead customerContract) {
        if (customerContract == null) {
            return null;
        }
        ArrayList<String> assignedCustomers = new ArrayList<String>();
        ContractContainsAccountAssignment.AssignedAccount accountAssignments = customerContract.getAssignedAccount();
        Iterator iterator = accountAssignments.iterator();
        while (iterator.hasNext()) {
            AccountAssignmentContract accountAssignment = (AccountAssignmentContract)iterator.next();
            try {
                assignedCustomers.add(this.getAccountFieldMapper().getAccountNumber((org.opencrx.kernel.account1.jmi1.Account)accountAssignment.getAccount()));
            }
            catch (Exception e) {
                ServiceException e0 = new ServiceException(e, "DefaultDomain", -23, "Unable to map assigned account", new BasicException.Parameter[0]);
                e0.log();
            }
        }
        return (CustomerContractT)Datatypes.create(CustomerContractT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)CustomerContractT.Member.contractNumber, (Object)this.getLeadFieldMapper().getContractNumber(customerContract)), Datatypes.member((Enum)CustomerContractT.Member.customerNumber, (Object)this.getAccountFieldMapper().getAccountNumber((org.opencrx.kernel.account1.jmi1.Account)customerContract.getCustomer())), Datatypes.member((Enum)CustomerContractT.Member.contractStatus, (Object)this.mapContractStatus(customerContract)), Datatypes.member((Enum)CustomerContractT.Member.acceptedLegal, (Object)this.getLeadFieldMapper().acceptedLegal(customerContract)), Datatypes.member((Enum)CustomerContractT.Member.acceptedMarketing, (Object)this.getLeadFieldMapper().acceptedMarketing(customerContract)), Datatypes.member((Enum)CustomerContractT.Member.acceptedPrivateDataForwarding, (Object)this.getLeadFieldMapper().acceptedPrivateDataForwarding(customerContract)), Datatypes.member((Enum)CustomerContractT.Member.referrer, (Object)this.getLeadFieldMapper().getReferrer(customerContract)), Datatypes.member((Enum)CustomerContractT.Member.contactSource, (Object)this.getLeadFieldMapper().getContactSource(customerContract)), Datatypes.member((Enum)CustomerContractT.Member.salesTaxType, (Object)this.getLeadFieldMapper().getSalesTaxType(customerContract)), Datatypes.member((Enum)CustomerContractT.Member.contractCurrency, (Object)this.getLeadFieldMapper().getContractCurrency(customerContract)), Datatypes.member((Enum)CustomerContractT.Member.noBilling, (Object)this.getLeadFieldMapper().noBilling(customerContract)), Datatypes.member((Enum)CustomerContractT.Member.billingPartner, (Object)this.getAbstractContractFieldMapper().getBillingPartner(customerContract)), Datatypes.member((Enum)CustomerContractT.Member.billingPartnerRegistrationId, this.getAbstractContractFieldMapper().getBillingPartnerRegistrationId(customerContract)), Datatypes.member((Enum)CustomerContractT.Member.assignedCustomer, assignedCustomers)});
    }

    public void mapCustomerContract(CustomerContractT customerContractT, Lead customerContract) {
        LeadFieldMapper leadFieldMapper = this.getLeadFieldMapper();
        leadFieldMapper.setAcceptedLegal(customerContract, customerContractT.isAcceptedLegal());
        leadFieldMapper.setAcceptedMarketing(customerContract, customerContractT.isAcceptedMarketing());
        leadFieldMapper.setAcceptedPrivateDataForwarding(customerContract, customerContractT.isAcceptedPrivateDataForwarding());
        leadFieldMapper.setReferrer(customerContract, customerContractT.getReferrer());
        leadFieldMapper.setContactSource(customerContract, customerContractT.getContactSource());
        leadFieldMapper.setSalesTaxType(customerContract, customerContractT.getSalesTaxType());
        leadFieldMapper.setContractCurrency(customerContract, customerContractT.getContractCurrency());
        leadFieldMapper.setNoBilling(customerContract, customerContractT.isNoBilling());
        this.getAbstractContractFieldMapper().setBillingPartner(customerContract, customerContractT.getBillingPartner());
        this.getAbstractContractFieldMapper().setBillingPartnerRegistrationId(customerContract, customerContractT.getBillingPartnerRegistrationId());
    }

    public CustomerStatusT mapCustomerStatus(org.opencrx.kernel.account1.jmi1.Account account) {
        return (CustomerStatusT)Datatypes.create(CustomerStatusT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)CustomerStatusT.Member.status, (Object)DatatypeMappers.toInteger(account.getAccountState())), Datatypes.member((Enum)CustomerStatusT.Member.description, (Object)account.getDescription())});
    }

    public ProductPriceT mapProductPrice(ProductBasePrice price, Date pricingDate, BigDecimal salesTaxRate) {
        return (ProductPriceT)Datatypes.create(ProductPriceT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ProductPriceT.Member.price, (Object)DatatypeMappers.bigDecimalToString(price.getPrice())), Datatypes.member((Enum)ProductPriceT.Member.priceIncludingTax, (Object)DatatypeMappers.bigDecimalToString(price.getPrice().multiply(salesTaxRate.divide(new BigDecimal(100)).add(BigDecimal.ONE)))), Datatypes.member((Enum)ProductPriceT.Member.priceCurrency, (Object)DatatypeMappers.toInteger(price.getPriceCurrency())), Datatypes.member((Enum)ProductPriceT.Member.priceUom, (Object)price.getUom().getName()), Datatypes.member((Enum)ProductPriceT.Member.pricingDate, (Object)pricingDate), Datatypes.member((Enum)ProductPriceT.Member.priceLevel, price.getPriceLevel().isEmpty() ? null : ((org.opencrx.kernel.product1.cci2.AbstractPriceLevel)price.getPriceLevel().iterator().next()).getName())});
    }

    public ProductStatusT mapProductStatus(Product product) {
        return (ProductStatusT)Datatypes.create(ProductStatusT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ProductStatusT.Member.status, (Object)DatatypeMappers.toInteger(product.getProductState())), Datatypes.member((Enum)ProductStatusT.Member.description, (Object)product.getDescription())});
    }

    public EmailAddressT mapEmailAddress(EMailAddress emailAddress) {
        if (emailAddress == null) {
            return null;
        }
        return (EmailAddressT)Datatypes.create(EmailAddressT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)EmailAddressT.Member.emailAddress, (Object)emailAddress.getEmailAddress()), Datatypes.member((Enum)EmailAddressT.Member.emailValid, (Object)this.getEmailAddressFieldMapper().emailValid(emailAddress))});
    }

    public PhoneNumberT mapPhoneNumber(PhoneNumber phoneNumber) {
        if (phoneNumber == null) {
            return null;
        }
        return (PhoneNumberT)Datatypes.create(PhoneNumberT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)PhoneNumberT.Member.phoneNumber, (Object)phoneNumber.getPhoneNumberFull()), Datatypes.member((Enum)PhoneNumberT.Member.phoneNumberVerified, (Object)this.getPhoneNumberFieldMapper().isNumberVerified(phoneNumber)), Datatypes.member((Enum)PhoneNumberT.Member.providerName, (Object)this.getPhoneNumberFieldMapper().getProviderName(phoneNumber)), Datatypes.member((Enum)PhoneNumberT.Member.providerVerified, (Object)this.getPhoneNumberFieldMapper().isProviderVerified(phoneNumber))});
    }

    public ProductT mapProduct(Product product, Boolean mapPictureContent, Segment productSegment) {
        Object p;
        Object filterProperties;
        Object bundleFilter;
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)product);
        List<ProductClassification> classifications = product.getClassification();
        DescriptionContainerContainsDescription.AdditionalDescription descriptions = product.getAdditionalDescription();
        List<Uom> priceUoms = product.getPriceUom();
        ArrayList<String> productBundles = new ArrayList<String>();
        ProductFilterGlobalQuery productFilterQuery = (ProductFilterGlobalQuery)pm.newQuery(ProductFilterGlobal.class);
        productFilterQuery.thereExistsUserCode0().equalTo((Object)new Short((short)ProductFilterType.PRODUCT_BUNDLE.getValue()));
        List bundleFilters = productSegment.getProductFilter(productFilterQuery);
        for (ProductFilterGlobal bundleFilter2 : bundleFilters) {
            ProductQuery productQuery = (ProductQuery)pm.newQuery(Product.class);
            productQuery.identity().equalTo((Object)product.refMofId());
            if (bundleFilter2.getFilteredProduct(productQuery).isEmpty()) continue;
            productBundles.add(bundleFilter2.getName());
        }
        ArrayList<String> contentPartners = new ArrayList<String>();
        productFilterQuery = (ProductFilterGlobalQuery)pm.newQuery(ProductFilterGlobal.class);
        productFilterQuery.thereExistsUserCode0().equalTo((Object)new Short((short)ProductFilterType.CONTENT_PARTNER.getValue()));
        List contentPartnerFilters = productSegment.getProductFilter(productFilterQuery);
        for (ProductFilterGlobal contentPartnerFilter : contentPartnerFilters) {
            ProductQuery productQuery = (ProductQuery)pm.newQuery(Product.class);
            productQuery.identity().equalTo((Object)product.refMofId());
            if (contentPartnerFilter.getFilteredProduct(productQuery).isEmpty()) continue;
            contentPartners.add(contentPartnerFilter.getName());
        }
        Boolean isBundle = this.getProductFieldMapper().isBundle(product);
        ProductBundleDataT bundleData = null;
        if (isBundle != null && isBundle.booleanValue()) {
            productFilterQuery = (ProductFilterGlobalQuery)pm.newQuery(ProductFilterGlobal.class);
            productFilterQuery.name().equalTo((Object)product.getProductNumber());
            bundleFilters = productSegment.getProductFilter(productFilterQuery);
            List<String> classificationIdFilter = null;
            ArrayList<String> members = new ArrayList<String>();
            if (!bundleFilters.isEmpty()) {
                Object p2;
                bundleFilter = (ProductFilterGlobal)bundleFilters.iterator().next();
                FilterIncludesProduct.FilteredProduct filteredProducts = bundleFilter.getFilteredProduct();
                Iterator iterator = filteredProducts.iterator();
                while (iterator.hasNext()) {
                    p2 = (Product)iterator.next();
                    if (p2.getProductNumber() == null) continue;
                    members.add(p2.getProductNumber());
                }
                filterProperties = bundleFilter.getProductFilterProperty();
                p2 = filterProperties.iterator();
                while (p2.hasNext()) {
                    p = (ProductFilterProperty)p2.next();
                    if (!(p instanceof ProductClassificationFilterProperty)) continue;
                    List<ProductClassification> classificationFilter = ((ProductClassificationFilterProperty)p).getClassification();
                    classificationIdFilter = this.mapProductClassifications(classificationFilter);
                }
                bundleData = (ProductBundleDataT)Datatypes.create(ProductBundleDataT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ProductBundleDataT.Member.classificationIdFilter, classificationIdFilter), Datatypes.member((Enum)ProductBundleDataT.Member.member, members)});
            }
        }
        ArrayList<Object> relatedProductsT = new ArrayList<Object>();
        ProductHasRelatedProduct.RelatedProduct relatedProducts = product.getRelatedProduct();
        bundleFilter = relatedProducts.iterator();
        while (bundleFilter.hasNext()) {
            RelatedProduct relatedProduct = (RelatedProduct)bundleFilter.next();
            relatedProductsT.add(Datatypes.create(RelatedProductT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)RelatedProductT.Member.relationshipType, (Object)((Number)relatedProduct.getRelationshipType()).intValue()), Datatypes.member((Enum)RelatedProductT.Member.productNumber, (Object)relatedProduct.getProduct().getProductNumber())}));
        }
        ArrayList<ProductConfigurationT> configurationsT = new ArrayList<ProductConfigurationT>();
        ProductConfigurationSetContainsConfiguration.Configuration configurations = product.getConfiguration();
        filterProperties = configurations.iterator();
        while (filterProperties.hasNext()) {
            ProductConfiguration configuration = (ProductConfiguration)filterProperties.next();
            configurationsT.add(this.mapProductConfiguration(configuration));
        }
        ProductContainsProductPhase.ProductPhase productPhases = product.getProductPhase();
        ArrayList<ProductPhaseT> productPhasesT = new ArrayList<ProductPhaseT>();
        p = productPhases.iterator();
        while (p.hasNext()) {
            ProductPhase productPhase = (ProductPhase)p.next();
            productPhasesT.add(this.mapProductPhase(productPhase));
        }
        boolean mapPicture = mapPictureContent != null && mapPictureContent != false;
        Structures.Member[] memberArray = new Structures.Member[19];
        memberArray[0] = Datatypes.member((Enum)ProductT.Member.productNumber, (Object)product.getProductNumber());
        memberArray[1] = Datatypes.member((Enum)ProductT.Member.productName, (Object)product.getName());
        memberArray[2] = Datatypes.member((Enum)ProductT.Member.activeOn, (Object)product.getActiveOn());
        memberArray[3] = Datatypes.member((Enum)ProductT.Member.expiresOn, (Object)product.getExpiresOn());
        memberArray[4] = Datatypes.member((Enum)ProductT.Member.description, this.mapProductDescriptions((Collection<Description>)((Object)descriptions)));
        memberArray[5] = Datatypes.member((Enum)ProductT.Member.classificationId, this.mapProductClassifications(classifications));
        memberArray[6] = Datatypes.member((Enum)ProductT.Member.isMemberOfBundle, productBundles);
        memberArray[7] = Datatypes.member((Enum)ProductT.Member.contentPartner, contentPartners);
        memberArray[8] = Datatypes.member((Enum)ProductT.Member.priceUom, this.mapUoms(priceUoms));
        memberArray[9] = Datatypes.member((Enum)ProductT.Member.configurationType, product.getConfigType() == null ? null : product.getConfigType().getName());
        memberArray[10] = Datatypes.member((Enum)ProductT.Member.configuration, configurationsT);
        memberArray[11] = Datatypes.member((Enum)ProductT.Member.productStatus, (Object)this.mapProductStatus(product));
        memberArray[12] = Datatypes.member((Enum)ProductT.Member.pictureContent, (Object)(mapPicture ? product.getPictureContent() : null));
        memberArray[13] = Datatypes.member((Enum)ProductT.Member.pictureMimeType, (Object)(mapPicture ? product.getPictureContentMimeType() : null));
        memberArray[14] = Datatypes.member((Enum)ProductT.Member.pictureTitle, mapPicture ? (product.getPicture() == null ? null : product.getPicture().getDescription()) : null);
        memberArray[15] = Datatypes.member((Enum)ProductT.Member.productPhase, productPhasesT);
        memberArray[16] = Datatypes.member((Enum)ProductT.Member.isBundle, (Object)isBundle);
        memberArray[17] = Datatypes.member((Enum)ProductT.Member.bundleData, (Object)bundleData);
        memberArray[18] = Datatypes.member((Enum)ProductT.Member.relatedProduct, relatedProductsT);
        return (ProductT)Datatypes.create(ProductT.class, (Structures.Member[])memberArray);
    }

    public ActivityFollowUpT mapActivityFollowUp(ActivityFollowUp followUp) {
        return (ActivityFollowUpT)Datatypes.create(ActivityFollowUpT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ActivityFollowUpT.Member.name, (Object)followUp.getTitle()), Datatypes.member((Enum)ActivityFollowUpT.Member.description, (Object)followUp.getText()), Datatypes.member((Enum)ActivityFollowUpT.Member.createdAt, (Object)followUp.getCreatedAt()), Datatypes.member((Enum)ActivityFollowUpT.Member.modifiedAt, (Object)followUp.getModifiedAt()), Datatypes.member((Enum)ActivityFollowUpT.Member.transitionName, (Object)followUp.getTransition().getName()), Datatypes.member((Enum)ActivityFollowUpT.Member.reportingCustomerNumber, followUp.getAssignedTo() == null ? null : this.getAccountFieldMapper().getAccountNumber(followUp.getAssignedTo())), Datatypes.member((Enum)ActivityFollowUpT.Member.category, followUp.getCategory())});
    }

    public ActivityT mapActivity(Activity activity) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)activity);
        ActivityFollowUpQuery followUpQuery = (ActivityFollowUpQuery)pm.newQuery(ActivityFollowUp.class);
        followUpQuery.orderByCreatedAt().ascending();
        List followUps = activity.getFollowUp(followUpQuery);
        ArrayList<ActivityFollowUpT> followUpsT = new ArrayList<ActivityFollowUpT>();
        for (ActivityFollowUp followUp : followUps) {
            followUpsT.add(this.mapActivityFollowUp(followUp));
        }
        ArrayList<String> activityGroups = new ArrayList<String>();
        ActivityHasTrackerAndGroupAssignment.AssignedGroup groupAssignments = activity.getAssignedGroup();
        Iterator iterator = groupAssignments.iterator();
        while (iterator.hasNext()) {
            ActivityGroupAssignment assignment = (ActivityGroupAssignment)iterator.next();
            activityGroups.add(assignment.getActivityGroup().getName());
        }
        return (ActivityT)Datatypes.create(ActivityT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ActivityT.Member.activityNumber, (Object)activity.getActivityNumber()), Datatypes.member((Enum)ActivityT.Member.activityState, (Object)activity.getProcessState().getName()), Datatypes.member((Enum)ActivityT.Member.name, (Object)activity.getName()), Datatypes.member((Enum)ActivityT.Member.description, (Object)activity.getDescription()), Datatypes.member((Enum)ActivityT.Member.detailedDescription, (Object)activity.getDetailedDescription()), Datatypes.member((Enum)ActivityT.Member.reportingCustomerNumber, (Object)this.getAccountFieldMapper().getAccountNumber(activity.getReportingContact())), Datatypes.member((Enum)ActivityT.Member.scheduledStart, (Object)activity.getScheduledStart()), Datatypes.member((Enum)ActivityT.Member.scheduledEnd, (Object)activity.getScheduledEnd()), Datatypes.member((Enum)ActivityT.Member.dueBy, (Object)activity.getDueBy()), Datatypes.member((Enum)ActivityT.Member.followUp, followUpsT), Datatypes.member((Enum)ActivityT.Member.activityGroup, activityGroups)});
    }

    public void mapProduct(ProductT productT, Product product) {
        product.setProductNumber(productT.getProductNumber());
        product.setName(productT.getProductName());
        product.setActiveOn(productT.getActiveOn());
        product.setExpiresOn(productT.getExpiresOn());
        if (productT.getProductStatus() == null) {
            product.setProductState((short)0);
            product.setDescription("New");
        } else {
            product.setProductState((short)productT.getProductStatus().getStatus());
            product.setDescription(productT.getProductStatus().getDescription());
        }
    }

    public AmountT mapAmount(BigDecimal quantity, Uom uom) {
        return (AmountT)Datatypes.create(AmountT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)AmountT.Member.count, (Object)DatatypeMappers.bigDecimalToString(quantity)), Datatypes.member((Enum)AmountT.Member.uom, (Object)uom.getName())});
    }

    public CredentialsT mapCredentials(org.opencrx.kernel.account1.jmi1.Account account) {
        return (CredentialsT)Datatypes.create(CredentialsT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)CredentialsT.Member.userName, (Object)this.getAccountFieldMapper().getUserName(account)), Datatypes.member((Enum)CredentialsT.Member.passwordMd5, (Object)this.getAccountFieldMapper().getPasswordMd5(account)), Datatypes.member((Enum)CredentialsT.Member.resetPasswordChallenge, (Object)this.getAccountFieldMapper().getResetPasswordChallenge(account)), Datatypes.member((Enum)CredentialsT.Member.resetPasswordResponse, (Object)this.getAccountFieldMapper().getResetPasswordResponse(account))});
    }

    public void mapPostalAddress(PostalAddressT addressT, PostalAddressable address) {
        address.getPostalAddressLine().clear();
        if (addressT.getPostalAddressLine0() != null && addressT.getPostalAddressLine0().length() > 0) {
            address.getPostalAddressLine().add(addressT.getPostalAddressLine0());
            if (addressT.getPostalAddressLine1() != null && addressT.getPostalAddressLine1().length() > 0) {
                address.getPostalAddressLine().add(addressT.getPostalAddressLine1());
                if (addressT.getPostalAddressLine2() != null && addressT.getPostalAddressLine2().length() > 0) {
                    address.getPostalAddressLine().add(addressT.getPostalAddressLine2());
                }
            }
        }
        address.getPostalStreet().clear();
        if (addressT.getPostalStreet0() != null && addressT.getPostalStreet0().length() > 0) {
            address.getPostalStreet().add(addressT.getPostalStreet0());
            if (addressT.getPostalStreet1() != null && addressT.getPostalStreet1().length() > 0) {
                address.getPostalStreet().add(addressT.getPostalStreet1());
            }
        }
        this.getPostalAddressFieldMapper().setPostalStreetNumber(address, addressT.getPostalStreetNumber());
        address.setPostalCity(addressT.getPostalCity());
        address.setPostalCountry(addressT.getPostalCountry() == null ? null : Short.valueOf(addressT.getPostalCountry().shortValue()));
        address.setPostalCode(addressT.getPostalCode());
    }

    public void mapEmailAddress(EmailAddressT addressT, EMailAddress address) {
        address.setEmailAddress(addressT.getEmailAddress());
        this.getEmailAddressFieldMapper().setEmailValid(address, addressT.isEmailValid());
    }

    public void mapPhoneNumber(PhoneNumberT addressT, PhoneNumber address) {
        address.setPhoneNumberFull(addressT.getPhoneNumber());
        this.getPhoneNumberFieldMapper().setProviderName(address, addressT.getProviderName());
        this.getPhoneNumberFieldMapper().setProviderVerified(address, addressT.isProviderVerified());
        this.getPhoneNumberFieldMapper().setNumberVerified(address, addressT.isPhoneNumberVerified());
    }

    public void mapMessengerAddress(MessengerAddressT addressT, PhoneNumber address) {
        address.setPhoneNumberFull(addressT.getMessengerId());
        this.getPhoneNumberFieldMapper().setProviderName(address, addressT.getProviderName());
        this.getPhoneNumberFieldMapper().setProviderVerified(address, addressT.isProviderVerified());
    }

    public void mapWebAddress(String addressT, WebAddress address) {
        address.setWebUrl(addressT);
    }

    public PriceLevelT mapPriceLevel(AbstractPriceLevel priceLevel) {
        org.opencrx.kernel.generic.jmi1.PropertySet genericData = null;
        CrxObjectContainsPropertySet.PropertySet propertySets = priceLevel.getPropertySet();
        Iterator iterator = propertySets.iterator();
        while (iterator.hasNext()) {
            org.opencrx.kernel.generic.jmi1.PropertySet propertySet = (org.opencrx.kernel.generic.jmi1.PropertySet)iterator.next();
            if (!propertySet.getName().equals(PropertySetName.GenericData.toString())) continue;
            genericData = propertySet;
            break;
        }
        return (PriceLevelT)Datatypes.create(PriceLevelT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)PriceLevelT.Member.name, (Object)priceLevel.getName()), Datatypes.member((Enum)PriceLevelT.Member.description, (Object)priceLevel.getDescription()), Datatypes.member((Enum)PriceLevelT.Member.priceCurrency, (Object)DatatypeMappers.toInteger(priceLevel.getPriceCurrency())), Datatypes.member((Enum)PriceLevelT.Member.validFrom, (Object)priceLevel.getValidFrom()), Datatypes.member((Enum)PriceLevelT.Member.validTo, (Object)priceLevel.getValidTo()), Datatypes.member((Enum)PriceLevelT.Member.genericData, this.mapPropertySet(genericData))});
    }

    public ProductPhaseT mapProductPhase(ProductPhase productPhase) {
        return (ProductPhaseT)Datatypes.create(ProductPhaseT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ProductPhaseT.Member.name, (Object)productPhase.getName()), Datatypes.member((Enum)ProductPhaseT.Member.productPhaseKey, (Object)productPhase.getProductPhaseKey()), Datatypes.member((Enum)ProductPhaseT.Member.validFrom, (Object)productPhase.getValidFrom()), Datatypes.member((Enum)ProductPhaseT.Member.validTo, (Object)productPhase.getValidTo())});
    }

    public DeliveryInformationT mapDeliveryInformation(DeliveryInformation deliveryInformation) {
        return (DeliveryInformationT)Datatypes.create(DeliveryInformationT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)DeliveryInformationT.Member.deliveryStatus, (Object)this.getDeliveryInformationFieldMapper().getDeliveryStatus(deliveryInformation)), Datatypes.member((Enum)DeliveryInformationT.Member.deliveryStatusDescription, (Object)this.getDeliveryInformationFieldMapper().getDeliveryStatusDescription(deliveryInformation)), Datatypes.member((Enum)DeliveryInformationT.Member.actualDeliveryOn, (Object)deliveryInformation.getActualDeliveryOn()), Datatypes.member((Enum)DeliveryInformationT.Member.quantityShipped, (Object)DatatypeMappers.bigDecimalToString(deliveryInformation.getQuantityShipped())), Datatypes.member((Enum)DeliveryInformationT.Member.productAssembledAt, (Object)this.getDeliveryInformationFieldMapper().getProductAssembledAt(deliveryInformation))});
    }

    public DocumentT mapDocument(Document document) {
        if (document.getHeadRevision() == null) {
            return null;
        }
        DocumentRevision headRevision = document.getHeadRevision();
        if (!(headRevision instanceof MediaContent)) {
            return null;
        }
        MediaContent media = (MediaContent)headRevision;
        QuotaByteArrayOutputStream content = new QuotaByteArrayOutputStream(DatatypeMappers.class.getName());
        try {
            BinaryLargeObjects.streamCopy((InputStream)media.getContent().getContent(), (long)0L, (OutputStream)content);
            content.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (DocumentT)Datatypes.create(DocumentT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)DocumentT.Member.name, (Object)document.getName()), Datatypes.member((Enum)DocumentT.Member.title, (Object)document.getTitle()), Datatypes.member((Enum)DocumentT.Member.contentName, (Object)media.getContentName()), Datatypes.member((Enum)DocumentT.Member.contentLanguage, (Object)(document.getContentLanguage().isEmpty() ? 0 : new Integer(document.getContentLanguage().get(0).shortValue()))), Datatypes.member((Enum)DocumentT.Member.contentMimeType, (Object)media.getContentMimeType()), Datatypes.member((Enum)DocumentT.Member.content, (Object)content.toByteArray())});
    }
}

