/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.mail.exporter;

import java.util.Date;
import java.util.Map;
import javax.jdo.PersistenceManager;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.opencrx.application.mail.exporter.MailWorkflow;
import org.opencrx.kernel.activity1.jmi1.EMail;
import org.opencrx.kernel.backend.Activities;
import org.opencrx.kernel.backend.Notifications;
import org.opencrx.kernel.home1.jmi1.UserHome;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.ContextCapable;
import org.openmdx.base.naming.Path;

public class ExportMailWorkflow
extends MailWorkflow {
    @Override
    protected String setContent(Message message, Session session, PersistenceManager pm, Path targetIdentity, Path wfProcessInstanceIdentity, UserHome userHome, Map<String, Object> params) throws ServiceException {
        String text = null;
        try {
            ContextCapable target = null;
            try {
                target = (ContextCapable)pm.getObjectById((Object)targetIdentity);
            }
            catch (Exception exception) {
                // empty catch block
            }
            text = Notifications.getInstance().getNotificationText(pm, target, wfProcessInstanceIdentity, userHome, params);
            String providerName = wfProcessInstanceIdentity.get(2);
            String segmentName = wfProcessInstanceIdentity.get(4);
            message.setText(text);
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart bodyPart = new MimeBodyPart();
            bodyPart.setText(text);
            multipart.addBodyPart((BodyPart)bodyPart);
            if (target instanceof EMail) {
                EMail emailActivity = (EMail)target;
                bodyPart = new MimeBodyPart();
                bodyPart.setFileName(emailActivity.getMessageSubject() + ".msg");
                MimeMessage nestedMessage = new MimeMessage(session);
                nestedMessage.setHeader("X-Mailer", "//OPENCRX//V4//" + providerName + "/" + segmentName);
                nestedMessage.setSubject(emailActivity.getMessageSubject(), "UTF-8");
                Activities.getInstance().mapMessageContent(emailActivity, (Message)nestedMessage);
                nestedMessage.setSentDate(new Date());
                Activities.getInstance().mapMessageRecipients(emailActivity, (Message)nestedMessage);
                bodyPart.setDisposition("attachment");
                bodyPart.setContent((Object)nestedMessage, "message/rfc822");
                multipart.addBodyPart((BodyPart)bodyPart);
            }
            message.setContent((Multipart)multipart);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
        return text;
    }

    @Override
    boolean useSendMailSubjectPrefix() {
        return false;
    }
}

