/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.ical;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.kernel.activity1.cci2.ActivityQuery;
import org.opencrx.kernel.activity1.jmi1.Absence;
import org.opencrx.kernel.activity1.jmi1.Activity;
import org.opencrx.kernel.activity1.jmi1.ExternalActivity;
import org.opencrx.kernel.activity1.jmi1.Meeting;
import org.opencrx.kernel.activity1.jmi1.PhoneCall;
import org.opencrx.kernel.admin1.jmi1.ComponentConfiguration;
import org.opencrx.kernel.backend.UserHomes;
import org.opencrx.kernel.generic.SecurityKeys;
import org.opencrx.kernel.home1.cci2.EMailAccountQuery;
import org.opencrx.kernel.home1.cci2.UserHomeQuery;
import org.opencrx.kernel.home1.jmi1.EMailAccount;
import org.opencrx.kernel.home1.jmi1.Segment;
import org.opencrx.kernel.home1.jmi1.UserHome;
import org.opencrx.kernel.utils.ActivityQueryHelper;
import org.opencrx.kernel.utils.ComponentConfigHelper;
import org.opencrx.kernel.utils.Utils;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.persistence.cci.PersistenceHelper;
import org.openmdx.kernel.log.SysLog;
import org.w3c.cci2.AnyTypePredicate;
import org.w3c.format.DateTimeFormat;

public class FreeBusyServlet
extends HttpServlet {
    private static final long serialVersionUID = 4746783518992145105L;
    protected static final String CONFIGURATION_ID = "ICalServlet";
    protected static final String PARAMETER_NAME_ID = "id";
    protected static final String PARAMETER_NAME_DISABLED = "disabled";
    protected static final String PARAMETER_NAME_USER = "user";
    protected static final String PARAMETER_NAME_TYPE = "type";
    protected static final String PARAMETER_NAME_RESOURCE = "resource";
    protected static final String RESOURCE_FORMAT_ICS = "ics";
    protected static final String PROPERTY_MAX_ACTIVITIES = "maxActivities";
    protected static final int DEFAULT_MAX_ACTIVITIES = 500;
    protected PersistenceManagerFactory pmf = null;

    public void init(ServletConfig config) throws ServletException {
        super.init();
        if (this.pmf == null) {
            try {
                Utils.getModel();
                this.pmf = Utils.getPersistenceManagerFactory();
            }
            catch (ServiceException e) {
                throw new ServletException("Can not get persistence manager", (Throwable)e);
            }
        }
    }

    protected PersistenceManager getRootPersistenceManager() {
        return this.pmf.getPersistenceManager("admin-Root", null);
    }

    protected ComponentConfiguration getComponentConfiguration(String providerName, PersistenceManager rootPm) {
        return ComponentConfigHelper.getComponentConfiguration(CONFIGURATION_ID, providerName, rootPm, false, null);
    }

    protected ActivityQueryHelper getActivitiesQueryHelper(PersistenceManager pm, String filterId, String isDisabledFilter) {
        ActivityQueryHelper activitiesHelper = new ActivityQueryHelper(pm);
        if (filterId != null) {
            try {
                activitiesHelper.parseQueryId((filterId.startsWith("/") ? "" : "/") + filterId);
                activitiesHelper.parseDisabledFilter(isDisabledFilter);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return activitiesHelper;
    }

    protected boolean matches(String token, List<String> strings) {
        for (String str : strings) {
            if (token.indexOf(str) < 0) continue;
            return true;
        }
        return false;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String id = req.getParameter(PARAMETER_NAME_ID);
        if (id == null) {
            resp.setStatus(400);
            return;
        }
        String[] ids = id.split("/");
        if (ids.length < 2) {
            resp.setStatus(400);
            return;
        }
        String providerName = ids[0];
        String segmentName = ids[1];
        String user = null;
        for (int i = 0; i < ids.length; ++i) {
            if (!"home".equals(ids[i]) && !"userhome".equals(ids[i])) continue;
            user = ids[i + 1];
            break;
        }
        if (user == null && (user = req.getParameter(PARAMETER_NAME_USER)) == null) {
            resp.setStatus(400);
            return;
        }
        PersistenceManager pm = this.pmf.getPersistenceManager("admin" + SecurityKeys.ID_SEPARATOR + segmentName, null);
        Segment userHomeSegment = null;
        try {
            userHomeSegment = UserHomes.getInstance().getUserHomeSegment(pm, providerName, segmentName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        UserHome userHome = null;
        if (user.indexOf("@") > 0) {
            UserHomeQuery query = (UserHomeQuery)pm.newQuery(UserHome.class);
            query.thereExistsEMailAccount().name().equalTo((Object)user);
            List userHomes = userHomeSegment.getUserHome(query);
            if (!userHomes.isEmpty()) {
                userHome = (UserHome)userHomes.iterator().next();
            }
        } else {
            userHome = userHomeSegment.getUserHome(user);
        }
        String userId = null;
        ArrayList<String> userEMails = new ArrayList<String>();
        if (userHome != null) {
            userId = userHome.refGetPath().getLastSegment().toString();
            EMailAccountQuery query = (EMailAccountQuery)pm.newQuery(EMailAccount.class);
            query.thereExistsIsActive().isTrue();
            query.thereExistsIsDefault().isTrue();
            List emailAccounts = userHome.getEMailAccount(query);
            for (EMailAccount emailAccount : emailAccounts) {
                userEMails.add(emailAccount.getName());
            }
        }
        if (userId == null || userEMails.isEmpty()) {
            SysLog.warning((String)"Invalid user", Arrays.asList(id, user));
        }
        pm.close();
        pm = this.pmf.getPersistenceManager(userId, null);
        String isDisabledFilter = req.getParameter(PARAMETER_NAME_DISABLED);
        ActivityQueryHelper activitiesHelper = this.getActivitiesQueryHelper(pm, id, isDisabledFilter);
        if (req.getRequestURI().endsWith("/freebusy")) {
            resp.setStatus(200);
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("text/plain");
            PrintWriter p = resp.getWriter();
            boolean isTypeICS = RESOURCE_FORMAT_ICS.equals(req.getParameter(PARAMETER_NAME_TYPE));
            Date dtStart = new Date(System.currentTimeMillis() - 604800000L);
            Date dtEnd = new Date(System.currentTimeMillis() + 5184000000L);
            p.write("BEGIN:VCALENDAR\n");
            p.write("PRODID:-//OPENCRX//V2//EN\n");
            p.write("VERSION:2.0\n");
            p.write("METHOD:PUBLISH\n");
            if (!isTypeICS) {
                p.write("BEGIN:VFREEBUSY\n");
                p.write("ORGANIZER:" + (userEMails.isEmpty() ? activitiesHelper.getCalendarName() : (String)userEMails.get(0)) + "\n");
                p.write("DTSTAMP:" + ActivityQueryHelper.formatDateTime(ActivityQueryHelper.getActivityGroupModifiedAt(activitiesHelper.getActivityGroup())) + "\n");
                p.write("DTSTART:" + ActivityQueryHelper.formatDateTime(dtStart) + "\n");
                p.write("DTEND:" + ActivityQueryHelper.formatDateTime(dtEnd) + "\n");
            }
            ActivityQuery activityQuery = (ActivityQuery)pm.newQuery(Activity.class);
            PersistenceHelper.setClasses((AnyTypePredicate)activityQuery, (Class[])new Class[]{Meeting.class, PhoneCall.class, Absence.class, ExternalActivity.class});
            if (activitiesHelper.isDisabledFilter()) {
                activityQuery.thereExistsDisabled().isTrue();
            } else {
                activityQuery.forAllDisabled().isFalse();
            }
            activityQuery.ical().isNonNull();
            activityQuery.thereExistsScheduledStart().lessThanOrEqualTo((Comparable)dtEnd);
            activityQuery.thereExistsScheduledEnd().greaterThanOrEqualTo((Comparable)dtStart);
            activityQuery.orderByScheduledStart().ascending();
            for (Activity activity : activitiesHelper.getFilteredActivities(activityQuery)) {
                String[] tokens;
                String ical = activity.getIcal();
                if (ical.indexOf("TRANSP:TRANSPARENT") >= 0) continue;
                boolean isBusy = false;
                for (String token : tokens = ical.split("\n")) {
                    if (token.indexOf("ORGANIZER") >= 0 && this.matches(token, userEMails)) {
                        isBusy = true;
                        break;
                    }
                    if (token.indexOf("ATTENDEE") < 0 || !this.matches(token, userEMails) || token.indexOf("PARTSTAT=DECLINED") >= 0) continue;
                    isBusy = true;
                    break;
                }
                if (!isBusy) continue;
                RRule rrule = new RRule();
                if (ical != null && ical.indexOf("RRULE:") > 0) {
                    rrule.parse(ical.substring(ical.indexOf("RRULE:")));
                }
                GregorianCalendar scheduledStart = new GregorianCalendar();
                scheduledStart.setTime(activity.getScheduledStart());
                GregorianCalendar scheduledEnd = new GregorianCalendar();
                scheduledEnd.setTime(activity.getScheduledEnd());
                for (int i = 0; rrule.getUntil() != null && scheduledStart.getTime().compareTo(rrule.getUntil()) <= 0 || i < rrule.getCount(); ++i) {
                    if (isTypeICS) {
                        p.write("BEGIN:VEVENT\n");
                        p.write("UID:" + activity.refGetPath().getLastSegment().toString() + "-" + i + "\n");
                        p.write("CLASS:PUBLIC\n");
                        p.write("DTSTAMP:" + ActivityQueryHelper.formatDateTime(ActivityQueryHelper.getActivityGroupModifiedAt(activitiesHelper.getActivityGroup())) + "\n");
                        p.write("ORGANIZER:" + (userEMails.isEmpty() ? activitiesHelper.getCalendarName() : (String)userEMails.get(0)) + "\n");
                        p.write("SUMMARY:***\n");
                        if (activity.isAllDayEvent().booleanValue()) {
                            p.write("DTSTART;VALUE=DATE:" + ActivityQueryHelper.formatDate(scheduledStart.getTime()) + "\n");
                            p.write("DTEND;VALUE=DATE:" + ActivityQueryHelper.formatDate(scheduledEnd.getTime()) + "\n");
                        } else {
                            p.write("DTSTART:" + ActivityQueryHelper.formatDateTime(scheduledStart.getTime()) + "\n");
                            p.write("DTEND:" + ActivityQueryHelper.formatDateTime(scheduledEnd.getTime()) + "\n");
                        }
                        p.write("END:VEVENT\n");
                    } else {
                        p.write("FREEBUSY:" + ActivityQueryHelper.formatDateTime(scheduledStart.getTime()) + "/" + ActivityQueryHelper.formatDateTime(scheduledEnd.getTime()) + "\n");
                    }
                    if ("DAILY".equals(rrule.getFreq())) {
                        scheduledStart.add(5, rrule.getInterval());
                        scheduledEnd.add(5, rrule.getInterval());
                        continue;
                    }
                    if ("WEEKLY".equals(rrule.getFreq())) {
                        scheduledStart.add(3, rrule.getInterval());
                        scheduledEnd.add(3, rrule.getInterval());
                        continue;
                    }
                    if ("MONTHLY".equals(rrule.getFreq())) {
                        scheduledStart.add(2, rrule.getInterval());
                        scheduledEnd.add(2, rrule.getInterval());
                        continue;
                    }
                    if (!"YEARLY".equals(rrule.getFreq())) continue;
                    scheduledStart.add(1, rrule.getInterval());
                    scheduledEnd.add(1, rrule.getInterval());
                }
            }
            if (!isTypeICS) {
                p.write("END:VFREEBUSY\n");
            }
            p.write("END:VCALENDAR\n");
            p.flush();
        } else {
            super.doGet(req, resp);
        }
        try {
            pm.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static class RRule {
        private String freq = "DAILY";
        private int count = 1;
        private int interval = 1;
        private Date until = null;

        protected RRule() {
        }

        protected Date getUtcDate(String dateTime) throws ParseException {
            Date date = null;
            if (dateTime.endsWith("Z")) {
                date = dateTime.length() == 16 ? DateTimeFormat.BASIC_UTC_FORMAT.parse(dateTime.substring(0, 15) + ".000Z") : DateTimeFormat.BASIC_UTC_FORMAT.parse(dateTime);
            } else if (dateTime.length() == 8) {
                date = DateTimeFormat.BASIC_UTC_FORMAT.parse(dateTime + "T000000.000Z");
            }
            return date;
        }

        public void parse(String rrule) {
            if (rrule.startsWith("RRULE:")) {
                int end;
                for (end = 6; end < rrule.length() && !Character.isWhitespace(rrule.charAt(end)); ++end) {
                }
                String[] attrs = rrule.substring(6, end).split(";");
                for (int i = 0; i < attrs.length; ++i) {
                    if (attrs[i].startsWith("FREQ=")) {
                        this.freq = attrs[i].substring(5);
                        continue;
                    }
                    if (attrs[i].startsWith("COUNT=")) {
                        this.count = Integer.valueOf(attrs[i].substring(6));
                        continue;
                    }
                    if (attrs[i].startsWith("INTERVAL=")) {
                        this.interval = Integer.valueOf(attrs[i].substring(9));
                        continue;
                    }
                    if (!attrs[i].startsWith("UNTIL=")) continue;
                    try {
                        this.until = this.getUtcDate(attrs[i].substring(6));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public String getFreq() {
            return this.freq;
        }

        public int getCount() {
            return this.count;
        }

        public int getInterval() {
            return this.interval;
        }

        public Date getUntil() {
            return this.until;
        }
    }
}

