/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.carddav;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import org.opencrx.application.carddav.AccountCollectionResource;
import org.opencrx.application.carddav.AccountResource;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.Resource;
import org.opencrx.application.uses.net.sf.webdav.WebDavStore;
import org.opencrx.application.uses.net.sf.webdav.exceptions.LockFailedException;
import org.opencrx.application.uses.net.sf.webdav.fromcatalina.XMLHelper;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.kernel.log.SysLog;
import org.w3c.cci2.BinaryLargeObject;
import org.w3c.cci2.BinaryLargeObjects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class DoReport
extends org.opencrx.application.uses.net.sf.webdav.methods.DoReport {
    protected static final int SC_MULTI_STATUS = 207;

    public DoReport(WebDavStore store) {
        super(store);
    }

    @Override
    public void folderBody(RequestContext requestContext, Resource so) throws IOException, LockFailedException {
        HttpServletRequest req = requestContext.getHttpServletRequest();
        HttpServletResponse resp = requestContext.getHttpServletResponse();
        Document document = null;
        try {
            DocumentBuilder documentBuilder = this.getDocumentBuilder();
            document = documentBuilder.parse(new InputSource((InputStream)req.getInputStream()));
        }
        catch (Exception e) {
            new ServiceException(e).log();
            resp.sendError(500);
            return;
        }
        Element rootElement = document.getDocumentElement();
        Date timeRangeStart = null;
        Date timeRangeEnd = null;
        Collection<Object> resources = Collections.emptyList();
        List<Node> hrefNodes = XMLHelper.findSubElements(rootElement, "href");
        if (hrefNodes != null) {
            resources = new ArrayList();
            for (Node hrefNode : hrefNodes) {
                Resource res;
                String href = hrefNode.getTextContent();
                if (href == null) continue;
                if (href.startsWith(req.getContextPath())) {
                    href = href.substring(req.getContextPath().length());
                }
                if ((res = this._store.getResourceByPath(requestContext, href)) == null) {
                    res = this._store.getResourceByPath(requestContext, URLDecoder.decode(href, "UTF-8"));
                }
                if (res == null) continue;
                resources.add(res);
            }
        } else if (so instanceof AccountCollectionResource) {
            resources = this._store.getChildren(requestContext, so, timeRangeStart, timeRangeEnd);
        }
        Node propNode = XMLHelper.findSubElement(rootElement, "prop");
        List<String> properties = XMLHelper.getPropertiesFromXML(propNode);
        resp.setStatus(207);
        resp.setCharacterEncoding("UTF-8");
        resp.setContentType("application/xml");
        resp.setHeader("DAV", "1, 2, addressbook");
        PrintWriter p = resp.getWriter();
        p.println("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
        SysLog.detail((String)"<D:multistatus>");
        p.println("<D:multistatus xmlns:D=\"DAV:\" xmlns:C=\"urn:ietf:params:xml:ns:carddav\">");
        for (Resource resource : resources) {
            AccountResource res = (AccountResource)resource;
            String name = resource.getName();
            p.println("  <D:response>");
            String servletPath = req.getServletPath();
            p.println("    <D:href>" + this.encodeURL(resp, this.getHRef(req, servletPath.endsWith("/") ? servletPath + name : servletPath + "/" + name, false)) + "</D:href>");
            p.println("    <D:propstat>");
            p.println("      <D:prop>");
            for (String property : properties) {
                if (property.indexOf("getetag") > 0) {
                    p.println("        <D:getetag>" + this.getETag(res) + "</D:getetag>");
                    continue;
                }
                if (property.indexOf("address-data") > 0) {
                    p.print("        <C:address-data xmlns:C=\"urn:ietf:params:xml:ns:carddav\">");
                    p.print("<![CDATA[");
                    BinaryLargeObject content = this._store.getResourceContent(requestContext, resource).getContent();
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    BinaryLargeObjects.streamCopy((InputStream)content.getContent(), (long)0L, (OutputStream)bos);
                    bos.close();
                    p.print(bos.toString("UTF-8"));
                    p.print("]]>");
                    p.println("</C:address-data>");
                    continue;
                }
                if (property.indexOf("getcontenttype") <= 0) continue;
                p.println("        <D:getcontenttype>" + this._store.getMimeType(res) + "</D:getcontenttype>");
            }
            p.println("      </D:prop>");
            p.println("      <D:status>HTTP/1.1 200 OK</D:status>");
            p.println("    </D:propstat>");
            p.println("  </D:response>");
        }
        p.println("</D:multistatus>");
        SysLog.detail((String)"</D:multistatus>");
        p.flush();
    }
}

