/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.caldav;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import org.opencrx.application.caldav.ActivityCollectionResource;
import org.opencrx.application.caldav.ActivityResource;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.Resource;
import org.opencrx.application.uses.net.sf.webdav.WebDavStore;
import org.opencrx.application.uses.net.sf.webdav.exceptions.LockFailedException;
import org.opencrx.application.uses.net.sf.webdav.fromcatalina.XMLHelper;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.kernel.log.SysLog;
import org.w3c.cci2.BinaryLargeObject;
import org.w3c.cci2.BinaryLargeObjects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.format.DateTimeFormat;
import org.xml.sax.InputSource;

public class DoReport
extends org.opencrx.application.uses.net.sf.webdav.methods.DoReport {
    protected static final int SC_MULTI_STATUS = 207;

    public DoReport(WebDavStore store) {
        super(store);
    }

    @Override
    public void folderBody(RequestContext requestContext, Resource so) throws IOException, LockFailedException {
        HttpServletRequest req = requestContext.getHttpServletRequest();
        HttpServletResponse resp = requestContext.getHttpServletResponse();
        Document document = null;
        try {
            DocumentBuilder documentBuilder = this.getDocumentBuilder();
            document = documentBuilder.parse(new InputSource((InputStream)req.getInputStream()));
        }
        catch (Exception e) {
            new ServiceException(e).log();
            resp.sendError(500);
            return;
        }
        Element rootElement = document.getDocumentElement();
        Date timeRangeStart = null;
        Date timeRangeEnd = null;
        NodeList timeRangeNodes = rootElement.getElementsByTagNameNS("urn:ietf:params:xml:ns:caldav", "time-range");
        if (timeRangeNodes != null) {
            for (int i = 0; i < timeRangeNodes.getLength(); ++i) {
                Node end;
                Node timeRangeNode = timeRangeNodes.item(i);
                Node start = timeRangeNodes.item(i).getAttributes().getNamedItem("start");
                if (start != null) {
                    try {
                        timeRangeStart = DateTimeFormat.BASIC_UTC_FORMAT.parse(start.getNodeValue());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((end = timeRangeNode.getAttributes().getNamedItem("end")) == null) continue;
                try {
                    timeRangeEnd = DateTimeFormat.BASIC_UTC_FORMAT.parse(end.getNodeValue());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Collection<Object> resources = Collections.emptyList();
        List<Node> hrefNodes = XMLHelper.findSubElements(rootElement, "href");
        if (hrefNodes != null) {
            resources = new ArrayList();
            for (Node hrefNode : hrefNodes) {
                Resource res;
                String href = hrefNode.getTextContent();
                if (href == null) continue;
                if (href.startsWith(req.getContextPath())) {
                    href = href.substring(req.getContextPath().length());
                }
                if ((res = this._store.getResourceByPath(requestContext, href)) == null) {
                    res = this._store.getResourceByPath(requestContext, URLDecoder.decode(href, "UTF-8"));
                }
                if (res == null) continue;
                resources.add(res);
            }
        } else if (so instanceof ActivityCollectionResource) {
            resources = this._store.getChildren(requestContext, so, timeRangeStart, timeRangeEnd);
        }
        Node propNode = XMLHelper.findSubElement(rootElement, "prop");
        List<String> properties = XMLHelper.getPropertiesFromXML(propNode);
        Node syncTokenNode = XMLHelper.findSubElement(rootElement, "sync-token");
        if (syncTokenNode != null) {
            resp.setStatus(501);
        } else {
            resp.setStatus(207);
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("application/xml");
            resp.setHeader("DAV", "1, 2, calendar-access");
            PrintWriter p = resp.getWriter();
            p.println("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
            SysLog.detail((String)"<D:multistatus>");
            p.println("<D:multistatus xmlns:D=\"DAV:\" xmlns:C=\"urn:ietf:params:xml:ns:caldav\">");
            for (Resource resource : resources) {
                ActivityResource res = (ActivityResource)resource;
                if (res.getSyncFeedResource().getRunAs() != null && res.getObject().getIcal().indexOf("CLASS:PRIVATE") >= 0) continue;
                String name = resource.getName();
                p.println("  <D:response>");
                p.println("    <D:href>" + this.encodeURL(resp, this.getHRef(req, req.getServletPath() + name, false)) + "</D:href>");
                p.println("    <D:propstat>");
                p.println("      <D:prop>");
                for (String property : properties) {
                    if (property.indexOf("getetag") > 0) {
                        p.println("        <D:getetag>" + this.getETag(res) + "</D:getetag>");
                        continue;
                    }
                    if (property.indexOf("calendar-data") > 0) {
                        p.print("        <C:calendar-data xmlns:C=\"urn:ietf:params:xml:ns:caldav\">");
                        p.print("<![CDATA[");
                        BinaryLargeObject content = this._store.getResourceContent(requestContext, resource).getContent();
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        BinaryLargeObjects.streamCopy((InputStream)content.getContent(), (long)0L, (OutputStream)bos);
                        bos.close();
                        p.print(bos.toString("UTF-8"));
                        p.print("]]>");
                        p.println("</C:calendar-data>");
                        continue;
                    }
                    if (property.indexOf("getcontenttype") <= 0) continue;
                    p.println("        <D:getcontenttype>" + this._store.getMimeType(res) + "</D:getcontenttype>");
                }
                p.println("      </D:prop>");
                p.println("      <D:status>HTTP/1.1 200 OK</D:status>");
                p.println("    </D:propstat>");
                p.println("  </D:response>");
            }
            p.println("</D:multistatus>");
            SysLog.detail((String)"</D:multistatus>");
            p.flush();
        }
    }
}

