/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.caldav;

import java.util.List;
import java.util.Map;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.caldav.ActivityCollectionResource;
import org.opencrx.application.caldav.ActivityResource;
import org.opencrx.application.caldav.CalendarProfileResource;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.Resource;
import org.opencrx.application.uses.net.sf.webdav.WebDavStore;
import org.opencrx.application.uses.net.sf.webdav.fromcatalina.XMLWriter;
import org.opencrx.kernel.home1.cci2.EMailAccountQuery;
import org.opencrx.kernel.home1.jmi1.EMailAccount;
import org.opencrx.kernel.home1.jmi1.SyncProfile;
import org.opencrx.kernel.home1.jmi1.UserHome;

public class DoPropfind
extends org.opencrx.application.uses.net.sf.webdav.methods.DoPropfind {
    public DoPropfind(WebDavStore store) {
        super(store);
    }

    @Override
    protected Map<String, String> getNamespaces() {
        Map<String, String> namespaces = super.getNamespaces();
        namespaces.put("urn:ietf:params:xml:ns:caldav", "C");
        namespaces.put("http://calendarserver.org/ns/", "CS");
        namespaces.put("http://apple.com/ns/ical/", "A");
        return namespaces;
    }

    @Override
    protected void writeCollectionType(RequestContext requestContext, XMLWriter writer, Resource res) {
        if (res instanceof ActivityCollectionResource) {
            writer.writeElement("urn:ietf:params:xml:ns:caldav:calendar", 2);
        }
    }

    @Override
    protected String getVersion() {
        return "1, 2, calendar-access";
    }

    @Override
    protected boolean handleExtension(RequestContext requestContext, XMLWriter writer, String contextPath, Resource res, String property) {
        HttpServletRequest req = requestContext.getHttpServletRequest();
        HttpServletResponse resp = requestContext.getHttpServletResponse();
        if (res instanceof CalendarProfileResource) {
            SyncProfile syncProfile = ((CalendarProfileResource)res).getObject();
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)syncProfile);
            UserHome userHome = (UserHome)pm.getObjectById((Object)syncProfile.refGetPath().getParent().getParent());
            String providerName = userHome.refGetPath().getSegment(2).toString();
            String segmentName = userHome.refGetPath().getSegment(4).toString();
            if (property.indexOf("current-user-principal") > 0) {
                String principalUrl = this.encodeURL(resp, this.getHRef(req, "/" + providerName + "/" + segmentName + "/user/" + userHome.refGetPath().getLastSegment() + "/profile/" + syncProfile.getName(), true));
                writer.writeElement("DAV::principal-URL", 0);
                writer.writeElement("DAV::href", 0);
                writer.writeText(principalUrl);
                writer.writeElement("DAV::href", 1);
                writer.writeElement("DAV::principal-URL", 1);
                writer.writeElement("DAV::current-user-principal", 0);
                writer.writeElement("DAV::href", 0);
                writer.writeText(principalUrl);
                writer.writeElement("DAV::href", 1);
                writer.writeElement("DAV::current-user-principal", 1);
                return true;
            }
            if (property.indexOf("calendar-user-address-set") > 0) {
                EMailAccountQuery emailAccountQuery = (EMailAccountQuery)pm.newQuery(EMailAccount.class);
                emailAccountQuery.thereExistsIsDefault().isTrue();
                emailAccountQuery.thereExistsIsActive().isTrue();
                List emailAccounts = userHome.getEMailAccount(emailAccountQuery);
                EMailAccount defaultEMailAccount = emailAccounts.isEmpty() ? null : (EMailAccount)emailAccounts.iterator().next();
                writer.writeElement("urn:ietf:params:xml:ns:caldav:calendar-user-address-set", 0);
                writer.writeElement("DAV::href", 0);
                writer.writeData("mailto:" + (defaultEMailAccount == null ? userHome.refGetPath().getLastSegment() + "@" + req.getServerName() : defaultEMailAccount.getName()));
                writer.writeElement("DAV::href", 1);
                writer.writeElement("DAV::href", 0);
                writer.writeText(this.encodeURL(resp, this.getHRef(req, req.getServletPath(), true)));
                writer.writeElement("DAV::href", 1);
                writer.writeElement("urn:ietf:params:xml:ns:caldav:calendar-user-address-set", 1);
                return true;
            }
            if (property.indexOf("calendar-home-set") > 0) {
                writer.writeElement("urn:ietf:params:xml:ns:caldav:calendar-home-set", 0);
                writer.writeElement("DAV::href", 0);
                writer.writeText(this.encodeURL(resp, this.getHRef(req, "/" + providerName + "/" + segmentName + "/" + userHome.refGetPath().getLastSegment() + "/" + res.getName(), true)));
                writer.writeElement("DAV::href", 1);
                writer.writeElement("urn:ietf:params:xml:ns:caldav:calendar-home-set", 1);
                return true;
            }
            if (property.indexOf("principal-URL") > 0) {
                writer.writeElement("DAV::principal-URL", 0);
                writer.writeElement("DAV::href", 0);
                writer.writeText(this.encodeURL(resp, this.getHRef(req, "/" + providerName + "/" + segmentName + "/user/" + userHome.refGetPath().getLastSegment() + "/profile/" + syncProfile.getName(), true)));
                writer.writeElement("DAV::href", 1);
                writer.writeElement("DAV::principal-URL", 1);
                return true;
            }
            return false;
        }
        if (res instanceof ActivityCollectionResource) {
            ActivityCollectionResource activityCollectionResource = (ActivityCollectionResource)res;
            if (property.indexOf("calendar-description") > 0) {
                writer.writeElement("urn:ietf:params:xml:ns:caldav:calendar-description", 0);
                writer.writeData(res.getDisplayName());
                writer.writeElement("urn:ietf:params:xml:ns:caldav:calendar-description", 1);
                return true;
            }
            if (property.indexOf("calendar-color") > 0) {
                if (activityCollectionResource.getBackColor() != null) {
                    String[] backColors = activityCollectionResource.getBackColor().split(",");
                    String backColor = backColors[0];
                    if (activityCollectionResource.getType() == ActivityCollectionResource.Type.VTODO) {
                        backColor = backColors.length > 1 ? backColors[1] : backColors[0];
                    }
                    writer.writeElement("http://apple.com/ns/ical/:calendar-color", 0);
                    writer.writeData(backColor);
                    writer.writeElement("http://apple.com/ns/ical/:calendar-color", 1);
                    return true;
                }
            } else {
                if (property.indexOf("current-user-privilege-set") > 0) {
                    writer.writeElement("DAV::current-user-privilege-set", 0);
                    writer.writeElement("DAV::privilege", 0);
                    if (Boolean.TRUE.equals(activityCollectionResource.allowAddDelete()) && Boolean.TRUE.equals(activityCollectionResource.allowChange())) {
                        writer.writeElement("DAV::all", 2);
                    } else {
                        writer.writeElement("DAV::read", 2);
                    }
                    writer.writeElement("DAV::privilege", 1);
                    writer.writeElement("DAV::current-user-privilege-set", 1);
                    return true;
                }
                if (property.indexOf("supported-calendar-component-set") > 0) {
                    writer.writeElement("urn:ietf:params:xml:ns:caldav:supported-calendar-component-set", 0);
                    if (activityCollectionResource.getType() == ActivityCollectionResource.Type.VEVENT) {
                        writer.writeText("<C:comp name=\"VEVENT\"/>");
                    } else {
                        writer.writeText("<C:comp name=\"VTODO\"/>");
                    }
                    writer.writeElement("urn:ietf:params:xml:ns:caldav:supported-calendar-component-set", 1);
                    return true;
                }
                if (property.indexOf("getctag") > 0) {
                    writer.writeElement("CS::getctag", 0);
                    writer.writeText(Long.toString(System.currentTimeMillis()));
                    writer.writeElement("CS::getctag", 1);
                    return true;
                }
            }
        } else if (res instanceof ActivityResource) {
            if (property.indexOf("getctag") > 0) {
                writer.writeElement("http://calendarserver.org/ns/:getctag", 0);
                writer.writeText(this.getETag(res));
                writer.writeElement("http://calendarserver.org/ns/:getctag", 1);
                return true;
            }
            if (property.indexOf("owner") > 0) {
                return true;
            }
            if (property.indexOf("supported-report-set") > 0) {
                return true;
            }
            if (property.indexOf("supported-calendar-component-set") > 0) {
                return true;
            }
        }
        return false;
    }
}

