/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.bpi.datatype;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.List;
import org.opencrx.application.bpi.datatype.BpiEMailAddress;
import org.opencrx.application.bpi.datatype.BpiObject;
import org.opencrx.application.bpi.datatype.BpiPhoneNumber;
import org.opencrx.application.bpi.datatype.BpiPostalAddress;

public class BpiAddress
extends BpiObject {
    private List<Short> usage;
    private boolean isMain;

    public List<Short> getUsage() {
        return this.usage;
    }

    public void setUsage(List<Short> usage) {
        this.usage = usage;
    }

    public boolean isMain() {
        return this.isMain;
    }

    public void setMain(boolean isMain) {
        this.isMain = isMain;
    }

    public static class BpiAddressDeserializer
    implements JsonDeserializer<BpiAddress> {
        private final GsonBuilder gsonBuilder;

        public BpiAddressDeserializer(GsonBuilder gsonBuilder) {
            this.gsonBuilder = gsonBuilder;
        }

        public BpiAddress deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Gson gson = this.gsonBuilder.create();
            if (json instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)json;
                if (jsonObject.has("emailAddress")) {
                    return (BpiAddress)gson.fromJson(json, BpiEMailAddress.class);
                }
                if (jsonObject.has("phoneNumberFull")) {
                    return (BpiAddress)gson.fromJson(json, BpiPhoneNumber.class);
                }
                return (BpiAddress)gson.fromJson(json, BpiPostalAddress.class);
            }
            return null;
        }
    }
}

