/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.bpi.adapter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.jdo.PersistenceManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.bpi.adapter.BpiAction;
import org.opencrx.application.bpi.adapter.BpiPlugIn;
import org.opencrx.application.bpi.datatype.BpiAccountMember;
import org.opencrx.kernel.account1.cci2.AccountMembershipQuery;
import org.opencrx.kernel.account1.jmi1.AccountMembership;
import org.opencrx.kernel.account1.jmi1.Contact;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;

public class GetContactMembershipsAction
extends BpiAction {
    @Override
    public void perform(Path path, PersistenceManager pm, BpiPlugIn plugIn, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServiceException {
        List<Contact> contacts = plugIn.findContacts(path.getPrefix(7), pm);
        if (contacts == null || contacts.isEmpty()) {
            resp.setStatus(404);
        } else {
            try {
                Contact contact = contacts.iterator().next();
                resp.setCharacterEncoding("UTF-8");
                resp.setContentType("application/json");
                PrintWriter pw = resp.getWriter();
                ArrayList<BpiAccountMember> bpiAccountMembers = new ArrayList<BpiAccountMember>();
                AccountMembershipQuery membershipQuery = (AccountMembershipQuery)pm.newQuery(AccountMembership.class);
                membershipQuery.forAllDisabled().isFalse();
                membershipQuery.thereExistsAccountFrom().forAllDisabled().isFalse();
                membershipQuery.distance().equalTo((Object)-1);
                for (AccountMembership membership : contact.getAccountMembership(membershipQuery)) {
                    try {
                        if (membership.getAccountFrom() == null) continue;
                        bpiAccountMembers.add(plugIn.toBpiAccountMember(membership, plugIn.newBpiAccountMember(), this.getFetchGroup(req)));
                    }
                    catch (Exception exception) {}
                }
                plugIn.printObject(pw, bpiAccountMembers);
                resp.setStatus(200);
            }
            catch (Exception e) {
                resp.setStatus(500);
                new ServiceException(e).log();
                try {
                    pm.currentTransaction().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

