/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.bpi.adapter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.jdo.PersistenceManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.bpi.adapter.BpiAction;
import org.opencrx.application.bpi.adapter.BpiPlugIn;
import org.opencrx.application.bpi.datatype.BpiDoFollowUpParams;
import org.opencrx.kernel.account1.jmi1.Contact;
import org.opencrx.kernel.activity1.cci2.ActivityDoFollowUpParams;
import org.opencrx.kernel.activity1.cci2.ActivityProcessTransitionQuery;
import org.opencrx.kernel.activity1.jmi1.Activity;
import org.opencrx.kernel.activity1.jmi1.ActivityDoFollowUpParams;
import org.opencrx.kernel.activity1.jmi1.ActivityDoFollowUpResult;
import org.opencrx.kernel.activity1.jmi1.ActivityProcess;
import org.opencrx.kernel.activity1.jmi1.ActivityProcessTransition;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;
import org.w3c.spi2.Datatypes;
import org.w3c.spi2.Structures;

public class DoFollowUpAction
extends BpiAction {
    @Override
    public void perform(Path path, PersistenceManager pm, BpiPlugIn plugIn, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServiceException {
        List<Activity> activities = plugIn.findActivities(path.getPrefix(7), pm);
        if (activities == null || activities.isEmpty()) {
            resp.setStatus(404);
        } else {
            List processTransitions;
            ActivityProcessTransitionQuery processTransitionQuery;
            ActivityProcess activityProcess;
            Activity activity = activities.iterator().next();
            BpiDoFollowUpParams bpiDoFollowUpParams = plugIn.parseObject(req.getReader(), BpiDoFollowUpParams.class);
            ActivityProcessTransition processTransition = null;
            if (bpiDoFollowUpParams.getTransition() == null) {
                if (activity.getProcessState() != null && activity.getActivityType() != null) {
                    activityProcess = activity.getActivityType().getControlledBy();
                    processTransitionQuery = (ActivityProcessTransitionQuery)pm.newQuery(ActivityProcessTransition.class);
                    processTransitionQuery.thereExistsPrevState().equalTo(activity.getProcessState());
                    if (activity.getPercentComplete() != null) {
                        processTransitionQuery.thereExistsNewPercentComplete().greaterThan((Comparable)activity.getPercentComplete());
                    }
                    processTransitionQuery.orderByNewPercentComplete().ascending();
                    processTransitionQuery.orderByNewActivityState().ascending();
                    processTransitions = activityProcess.getTransition(processTransitionQuery);
                    processTransition = processTransitions.isEmpty() ? null : (ActivityProcessTransition)processTransitions.iterator().next();
                }
            } else if (activity.getActivityType() != null) {
                activityProcess = activity.getActivityType().getControlledBy();
                processTransitionQuery = (ActivityProcessTransitionQuery)pm.newQuery(ActivityProcessTransition.class);
                processTransitionQuery.name().equalTo((Object)bpiDoFollowUpParams.getTransition());
                processTransitions = activityProcess.getTransition(processTransitionQuery);
                ActivityProcessTransition activityProcessTransition = processTransition = processTransitions.isEmpty() ? null : (ActivityProcessTransition)processTransitions.iterator().next();
            }
            if (processTransition == null) {
                resp.setStatus(404);
            } else {
                Contact assignTo = null;
                try {
                    String contactId = bpiDoFollowUpParams.getAssignTo();
                    if (contactId != null) {
                        List<Contact> contacts = plugIn.findContacts(path.getPrefix(5).getDescendant(new String[]{"contact", contactId}), pm);
                        assignTo = contacts.isEmpty() ? null : contacts.iterator().next();
                    }
                }
                catch (Exception contactId) {
                    // empty catch block
                }
                try {
                    String followUpText = bpiDoFollowUpParams.getText();
                    if (Boolean.TRUE.equals(bpiDoFollowUpParams.getUpdateActivity())) {
                        pm.currentTransaction().begin();
                        activity.setDetailedDescription(plugIn.mergeActivityDetailedDescription(activity.getDetailedDescription(), bpiDoFollowUpParams.getText()));
                        activity.setAssignedTo(assignTo);
                        pm.currentTransaction().commit();
                    }
                    pm.currentTransaction().begin();
                    ActivityDoFollowUpParams doFollowUpParams = (ActivityDoFollowUpParams)Structures.create(ActivityDoFollowUpParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ActivityDoFollowUpParams.Member.assignTo, assignTo), Datatypes.member((Enum)ActivityDoFollowUpParams.Member.followUpText, (Object)followUpText), Datatypes.member((Enum)ActivityDoFollowUpParams.Member.followUpTitle, (Object)bpiDoFollowUpParams.getTitle()), Datatypes.member((Enum)ActivityDoFollowUpParams.Member.transition, (Object)processTransition)});
                    ActivityDoFollowUpResult result = activity.doFollowUp(doFollowUpParams);
                    pm.currentTransaction().commit();
                    if (result.getFollowUp() != null) {
                        resp.setCharacterEncoding("UTF-8");
                        resp.setContentType("application/json");
                        PrintWriter pw = resp.getWriter();
                        plugIn.printObject(pw, plugIn.toBpiActivityFollowUp(result.getFollowUp(), plugIn.newBpiActivityFollowUp(), this.getFetchGroup(req)));
                        resp.setStatus(200);
                    }
                }
                catch (Exception e) {
                    resp.setStatus(500);
                    new ServiceException(e).log();
                    try {
                        pm.currentTransaction().rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

