/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.airsync.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.opencrx.application.airsync.backend.cci.SyncBackend;
import org.opencrx.application.airsync.datatypes.AttachmentDataT;
import org.opencrx.application.airsync.server.ServerHandler;
import org.opencrx.application.airsync.server.SyncRequest;
import org.opencrx.application.airsync.server.SyncResponse;
import org.openmdx.base.exception.ServiceException;

public class GetAttachmentHandler
implements ServerHandler {
    protected SyncBackend backend;
    protected Logger logger = Logger.getLogger(GetAttachmentHandler.class.getPackage().getName());

    public GetAttachmentHandler(SyncBackend backend, String profilePrefix) {
        this.backend = backend;
    }

    @Override
    public void handle(SyncRequest request, SyncResponse response) throws IOException {
        SyncBackend.RequestContext requestContext = this.backend.newRequestContext(request.getUserId(), request.getContext());
        String attachmentName = request.getAttachmentName();
        AttachmentDataT attachment = null;
        try {
            attachment = this.backend.getAttachementData(requestContext, attachmentName);
        }
        catch (Exception e) {
            new ServiceException(e).log();
        }
        if (attachment != null) {
            int b;
            OutputStream out = response.getOutputStream();
            InputStream content = attachment.getContent();
            int len = 0;
            while ((b = content.read()) >= 0) {
                out.write(b);
                ++len;
            }
            response.setContentType(attachment.getContentType());
            response.setContentLength(len);
            response.setStatus(200);
            out.flush();
        } else {
            response.sendError(500);
        }
    }
}

