/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.airsync.datatypes;

import java.io.Serializable;
import org.opencrx.application.airsync.datatypes.BodyPreference;
import org.opencrx.application.airsync.datatypes.DataType;
import org.opencrx.application.airsync.datatypes.FilterType;
import org.opencrx.application.airsync.datatypes.MimeType;
import org.opencrx.application.airsync.utils.DOMUtils;
import org.w3c.dom.Element;

public class SyncCollection
implements Serializable {
    private static final long serialVersionUID = -502421818332948856L;
    public static final Integer SYNC_TRUNCATION_ALL = 9;
    private DataType dataType;
    private Integer conflict = 1;
    private String collectionId = null;
    private String syncKey;
    private Integer truncation = SYNC_TRUNCATION_ALL;
    private boolean deletesAsMoves;
    private boolean getChanges;
    private boolean importedChanges;
    private FilterType filterType;
    private Integer windowSize = 100;
    private boolean moreAvailable = false;
    private Integer mimeSupport;
    private Integer mimeTruncation;
    private BodyPreference bodyPreference;
    private Integer maxItems;

    public boolean isImportedChanges() {
        return this.importedChanges;
    }

    public void setImportedChanges(boolean importedChanges) {
        this.importedChanges = importedChanges;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
    }

    public boolean isGetChanges() {
        return this.getChanges;
    }

    public void setGetChanges(boolean getChanges) {
        this.getChanges = getChanges;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public Integer getConflict() {
        return this.conflict;
    }

    public void setConflict(Integer conflict) {
        this.conflict = conflict;
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    public void setCollectionId(String collectionId) {
        this.collectionId = collectionId;
    }

    public String getSyncKey() {
        return this.syncKey;
    }

    public void setSyncKey(String syncKey) {
        this.syncKey = syncKey;
    }

    public Integer getTruncation() {
        return this.truncation;
    }

    public void setTruncation(Integer truncation) {
        this.truncation = truncation;
    }

    public boolean isDeletesAsMoves() {
        return this.deletesAsMoves;
    }

    public void setDeletesAsMoves(boolean deletesAsMoves) {
        this.deletesAsMoves = deletesAsMoves;
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public void setFilterType(FilterType filterType) {
        this.filterType = filterType;
    }

    public Integer getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(Integer windowSize) {
        this.windowSize = windowSize;
    }

    public boolean isMoreAvailable() {
        return this.moreAvailable;
    }

    public void setMoreAvailable(boolean moreAvailable) {
        this.moreAvailable = moreAvailable;
    }

    public boolean equals(Object obj) {
        return this.collectionId.equals(((SyncCollection)obj).collectionId);
    }

    public int hashCode() {
        return this.collectionId.hashCode();
    }

    public Integer getMimeSupport() {
        return this.mimeSupport;
    }

    public void setMimeSupport(Integer mimeSupport) {
        this.mimeSupport = mimeSupport;
    }

    public Integer getMimeTruncation() {
        return this.mimeTruncation;
    }

    public void setMimeTruncation(Integer mimeTruncation) {
        this.mimeTruncation = mimeTruncation;
    }

    public BodyPreference getBodyPreference() {
        return this.bodyPreference;
    }

    public void setBodyPreference(BodyPreference bodyPreference) {
        this.bodyPreference = bodyPreference;
    }

    public static SyncCollection decode(String namespace, Element e) {
        Element option;
        Element wse;
        Element eFilterType;
        SyncCollection collection = new SyncCollection();
        String collectionClass = DOMUtils.getElementText(e, "AirSync:", "Class");
        if (collectionClass == null) {
            collectionClass = DOMUtils.getElementText(e, namespace, "Class");
        }
        if (collectionClass != null) {
            collection.setDataType(DataType.valueOf(collectionClass));
        }
        collection.setSyncKey(DOMUtils.getElementText(e, "AirSync:", "SyncKey"));
        Element eCollectionId = DOMUtils.getUniqueElement(e, namespace == null ? "AirSync:" : namespace, "CollectionId");
        if (eCollectionId != null) {
            collection.setCollectionId(eCollectionId.getTextContent());
        }
        if ((eFilterType = DOMUtils.getUniqueElement(e, "AirSync:", "FilterType")) != null) {
            collection.setFilterType(FilterType.toFilterType(Integer.parseInt(eFilterType.getTextContent())));
        }
        if ((wse = DOMUtils.getUniqueElement(e, "AirSync:", "WindowSize")) != null) {
            collection.setWindowSize(Integer.parseInt(wse.getTextContent()));
        }
        collection.setDeletesAsMoves(DOMUtils.getUniqueElement(e, "AirSync:", "DeletesAsMoves") != null);
        collection.setGetChanges(DOMUtils.getUniqueElement(e, "AirSync:", "GetChanges") != null);
        Element maxItems = DOMUtils.getUniqueElement(e, "AirSync:", "MaxItems");
        if (maxItems != null) {
            collection.setMaxItems(Integer.parseInt(maxItems.getTextContent()));
        }
        if ((option = DOMUtils.getUniqueElement(e, "AirSync:", "Options")) != null) {
            String filterType = DOMUtils.getElementText(option, "AirSync:", "FilterType");
            String truncation = DOMUtils.getElementText(option, "AirSync:", "Truncation");
            String mimeSupport = DOMUtils.getElementText(option, "AirSync:", "MIMESupport");
            String mimeTruncation = DOMUtils.getElementText(option, "AirSync:", "MIMETruncation");
            String conflict = DOMUtils.getElementText(option, "AirSync:", "Conflict");
            Element bodyPreference = DOMUtils.getUniqueElement(e, "AirSync:", "BodyPreference");
            if (conflict != null) {
                collection.setConflict(Integer.parseInt(conflict));
            }
            if (filterType != null) {
                collection.setFilterType(FilterType.toFilterType(Integer.parseInt(filterType)));
            }
            if (mimeSupport != null) {
                collection.setMimeSupport(Integer.parseInt(mimeSupport));
            }
            if (mimeTruncation != null) {
                collection.setMimeTruncation(Integer.parseInt(mimeTruncation));
            }
            if (truncation != null) {
                collection.setTruncation(Integer.parseInt(truncation));
            }
            if (bodyPreference != null) {
                String truncationSize = DOMUtils.getElementText(bodyPreference, "AirSync:", "TruncationSize");
                String type = DOMUtils.getElementText(bodyPreference, "AirSync:", "Type");
                BodyPreference bp = new BodyPreference();
                if (truncationSize != null) {
                    bp.setTruncationSize(Integer.parseInt(truncationSize));
                }
                bp.setType(MimeType.toEmailBodyType(Integer.parseInt(type)));
                collection.setBodyPreference(bp);
            }
        }
        return collection;
    }
}

