/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.airsync.datatypes;

public enum MimeType {
    PlainText(1),
    HTML(2),
    RTF(3),
    MIME(4);

    private final int value;

    private MimeType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static MimeType toEmailBodyType(int value) {
        switch (value) {
            case 1: {
                return PlainText;
            }
            case 2: {
                return HTML;
            }
            case 3: {
                return RTF;
            }
            case 4: {
                return MIME;
            }
        }
        return PlainText;
    }

    public static MimeType getValueOf(String mimeType) {
        if ("text/rtf".equals(mimeType)) {
            return RTF;
        }
        if ("text/html".equals(mimeType)) {
            return HTML;
        }
        return PlainText;
    }
}

