/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.airsync.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.logging.Level;
import javax.xml.transform.stream.StreamResult;
import org.opencrx.application.airsync.backend.cci.ClientProfile;
import org.opencrx.application.airsync.backend.cci.SyncBackend;
import org.opencrx.application.airsync.client.AbstractClientHandler;
import org.opencrx.application.airsync.client.ClientHandler;
import org.opencrx.application.airsync.datatypes.SyncFolder;
import org.opencrx.application.airsync.utils.DOMUtils;
import org.opencrx.application.airsync.utils.WbXMLTransformer;
import org.openmdx.base.exception.ServiceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FolderSyncHandler
extends AbstractClientHandler {
    public FolderSyncHandler(SyncBackend backend) {
        super(backend);
    }

    @Override
    public void handle(ClientHandler.SyncTarget target, String userId, String profileName, Object context) throws ServiceException {
        try {
            SyncBackend backend = this.getBackend();
            SyncBackend.RequestContext requestContext = backend.newRequestContext(userId, context);
            ClientProfile clientProfile = backend.getClientProfile(requestContext, profileName);
            String requestXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><FolderSync xmlns=\"FolderHierarchy:\"><SyncKey>0</SyncKey></FolderSync>";
            Document requestDoc = DOMUtils.parse(new ByteArrayInputStream(requestXml.getBytes("UTF-8")));
            Document docResponse = (Document)target.perform("FolderSync", clientProfile.getPolicyKey() == null ? "0" : clientProfile.getPolicyKey(), clientProfile.getUserAgent(), requestDoc);
            Element eChanges = DOMUtils.getUniqueElement(docResponse.getDocumentElement(), null, "FolderHierarchy:Changes");
            if (eChanges != null) {
                NodeList nlChanges = eChanges.getChildNodes();
                for (int i = 0; i < nlChanges.getLength(); ++i) {
                    Element eChange = (Element)nlChanges.item(i);
                    String command = eChange.getNodeName();
                    SyncFolder syncFolder = SyncFolder.decode(eChange, "FolderHierarchy");
                    if (!command.equals("FolderHierarchy:Add")) continue;
                    ClientProfile.Folder folder = new ClientProfile.Folder();
                    folder = new ClientProfile.Folder();
                    folder.setName(syncFolder.getDisplayName());
                    folder.setType(syncFolder.getFolderType());
                    folder.setServerId(syncFolder.getServerId());
                    folder.setParentId(syncFolder.getParentId());
                    folder.setClientId(syncFolder.getClientId());
                    clientProfile.getFolders().add(folder);
                }
                backend.updateClientProfile(requestContext, clientProfile, null, true, true);
            }
            if (logger.isLoggable(Level.FINE)) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                WbXMLTransformer.transform(docResponse, new StreamResult(out), true);
                out.close();
                logger.log(Level.FINE, "+-+-+-+-+- Response +-+-+-+-+-");
                logger.log(Level.FINE, out.toString());
            }
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }
}

