/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.airsync.backend.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import javax.naming.InitialContext;
import org.opencrx.application.airsync.backend.cci.ClientProfile;
import org.opencrx.application.airsync.backend.cci.GetChangedDataItemsResult;
import org.opencrx.application.airsync.backend.cci.SyncBackend;
import org.opencrx.application.airsync.backend.impl.DatatypeMapper;
import org.opencrx.application.airsync.datatypes.AttachmentDataT;
import org.opencrx.application.airsync.datatypes.ContactT;
import org.opencrx.application.airsync.datatypes.DataType;
import org.opencrx.application.airsync.datatypes.EmailT;
import org.opencrx.application.airsync.datatypes.EventT;
import org.opencrx.application.airsync.datatypes.FolderType;
import org.opencrx.application.airsync.datatypes.IData;
import org.opencrx.application.airsync.datatypes.NoteT;
import org.opencrx.application.airsync.datatypes.SyncCollection;
import org.opencrx.application.airsync.datatypes.SyncDataItem;
import org.opencrx.application.airsync.datatypes.SyncFolder;
import org.opencrx.application.airsync.datatypes.TaskT;
import org.opencrx.kernel.account1.cci2.AccountMembershipQuery;
import org.opencrx.kernel.account1.cci2.MemberQuery;
import org.opencrx.kernel.account1.jmi1.AbstractGroup;
import org.opencrx.kernel.account1.jmi1.Account;
import org.opencrx.kernel.account1.jmi1.AccountMembership;
import org.opencrx.kernel.account1.jmi1.Contact;
import org.opencrx.kernel.account1.jmi1.Member;
import org.opencrx.kernel.activity1.cci2.ActivityGroupIsCreatedBy;
import org.opencrx.kernel.activity1.cci2.ActivityHasTrackerAndGroupAssignment;
import org.opencrx.kernel.activity1.cci2.ActivityQuery;
import org.opencrx.kernel.activity1.cci2.NewActivityParams;
import org.opencrx.kernel.activity1.jmi1.Absence;
import org.opencrx.kernel.activity1.jmi1.AbstractFilterActivity;
import org.opencrx.kernel.activity1.jmi1.Activity;
import org.opencrx.kernel.activity1.jmi1.ActivityCreator;
import org.opencrx.kernel.activity1.jmi1.ActivityGroup;
import org.opencrx.kernel.activity1.jmi1.ActivityGroupAssignment;
import org.opencrx.kernel.activity1.jmi1.EMail;
import org.opencrx.kernel.activity1.jmi1.ExternalActivity;
import org.opencrx.kernel.activity1.jmi1.Incident;
import org.opencrx.kernel.activity1.jmi1.Mailing;
import org.opencrx.kernel.activity1.jmi1.Meeting;
import org.opencrx.kernel.activity1.jmi1.NewActivityParams;
import org.opencrx.kernel.activity1.jmi1.NewActivityResult;
import org.opencrx.kernel.activity1.jmi1.PhoneCall;
import org.opencrx.kernel.activity1.jmi1.Task;
import org.opencrx.kernel.backend.Accounts;
import org.opencrx.kernel.backend.Activities;
import org.opencrx.kernel.backend.Base;
import org.opencrx.kernel.backend.Documents;
import org.opencrx.kernel.backend.UserHomes;
import org.opencrx.kernel.document1.cci2.DocumentQuery;
import org.opencrx.kernel.document1.cci2.FolderAssignmentQuery;
import org.opencrx.kernel.document1.jmi1.Document;
import org.opencrx.kernel.document1.jmi1.DocumentFolder;
import org.opencrx.kernel.document1.jmi1.FolderAssignment;
import org.opencrx.kernel.document1.jmi1.Segment;
import org.opencrx.kernel.generic.jmi1.CrxObject;
import org.opencrx.kernel.generic.jmi1.GenericAccount;
import org.opencrx.kernel.home1.cci2.AirSyncClientProfileQuery;
import org.opencrx.kernel.home1.cci2.AirSyncProfileQuery;
import org.opencrx.kernel.home1.cci2.AlertQuery;
import org.opencrx.kernel.home1.cci2.SyncFeedHasData;
import org.opencrx.kernel.home1.cci2.SyncFeedQuery;
import org.opencrx.kernel.home1.cci2.SyncProfileContainsSyncFeed;
import org.opencrx.kernel.home1.jmi1.ActivityFilterCalendarFeed;
import org.opencrx.kernel.home1.jmi1.ActivityGroupCalendarFeed;
import org.opencrx.kernel.home1.jmi1.AirSyncClientProfile;
import org.opencrx.kernel.home1.jmi1.AirSyncProfile;
import org.opencrx.kernel.home1.jmi1.Alert;
import org.opencrx.kernel.home1.jmi1.ContactsFeed;
import org.opencrx.kernel.home1.jmi1.DocumentFeed;
import org.opencrx.kernel.home1.jmi1.SyncData;
import org.opencrx.kernel.home1.jmi1.SyncFeed;
import org.opencrx.kernel.home1.jmi1.UserHome;
import org.openmdx.base.accessor.jmi.cci.RefObject_1_0;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;
import org.openmdx.base.persistence.cci.PersistenceHelper;
import org.openmdx.base.persistence.cci.UserObjects;
import org.openmdx.base.rest.cci.QueryExtensionRecord;
import org.openmdx.kernel.exception.BasicException;
import org.openmdx.kernel.loading.Factory;
import org.openmdx.kernel.log.SysLog;
import org.w3c.cci2.AnyTypePredicate;
import org.w3c.spi2.Datatypes;
import org.w3c.spi2.Structures;

public class OpenCrxSyncBackend
implements SyncBackend {
    private static final String INITIAL_SYNC_KEY = "0";
    private static final String FIRST_SYNC_KEY = "1";
    private static final String NOTE_MIME_TYPE = "text/plain";
    private static final Map<String, SyncFolder> DEFAULT_FOLDERS = new HashMap<String, SyncFolder>();
    private final PersistenceManagerFactory pmf;
    private final String providerName;
    private final DatatypeMapper datatypeMapper;

    public OpenCrxSyncBackend(PersistenceManagerFactory pmf, String providerName) {
        this(pmf, providerName, new DatatypeMapper());
    }

    public OpenCrxSyncBackend(PersistenceManagerFactory pmf, String providerName, DatatypeMapper datatypeMapper) {
        this.pmf = pmf;
        this.providerName = providerName;
        this.datatypeMapper = datatypeMapper;
    }

    protected PersistenceManager newPersistenceManager(final SyncBackend.RequestContext requestContext) throws ServiceException {
        try {
            String userId = requestContext.getUserId();
            if (userId == null || this.pmf == null) {
                throw new ServiceException("DefaultDomain", -2, "Unable to aquire persistence manager", new BasicException.Parameter[0]);
            }
            int pos = userId.indexOf("\\");
            PersistenceManager pm = this.pmf.getPersistenceManager(pos > 0 ? userId.substring(pos + 1) : userId, null);
            UserObjects.setTransactionTime((PersistenceManager)pm, (Factory)new Factory<Date>(){

                public Class<? extends Date> getInstanceClass() {
                    return Date.class;
                }

                public Date instantiate() {
                    long syncKeyMillis = Long.valueOf(requestContext.getSyncKey());
                    return new Date(syncKeyMillis / 10L * 10L);
                }
            });
            return pm;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    protected UserHome getUserHome(PersistenceManager pm, String userId) {
        int pos = userId.indexOf("\\");
        String segmentName = userId.substring(0, pos);
        String userName = userId.substring(pos + 1);
        return (UserHome)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.home1/provider/" + this.providerName + "/segment/" + segmentName + "/userHome/" + userName));
    }

    protected AirSyncProfile getSyncProfile(UserHome user, String profileName) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)user);
        List profiles = Collections.emptyList();
        AirSyncProfileQuery profileQuery = (AirSyncProfileQuery)pm.newQuery(AirSyncProfile.class);
        profileQuery.name().equalTo((Object)profileName);
        profiles = user.getSyncProfile(profileQuery);
        if (profiles.isEmpty() && profileName.indexOf("~") > 0) {
            profileQuery = (AirSyncProfileQuery)pm.newQuery(AirSyncProfile.class);
            profileQuery.name().equalTo((Object)profileName.substring(0, profileName.indexOf("~")));
            profiles = user.getSyncProfile(profileQuery);
        }
        if (!profiles.isEmpty()) {
            return (AirSyncProfile)profiles.iterator().next();
        }
        return null;
    }

    @Override
    public SyncBackend.RequestContext newRequestContext(final String userId, final Object context) {
        final String syncKey = Long.toString(System.currentTimeMillis());
        return new SyncBackend.RequestContext(){

            @Override
            public String getUserId() {
                return userId;
            }

            @Override
            public Object getContext() {
                return context;
            }

            @Override
            public String getSyncKey() {
                return syncKey;
            }
        };
    }

    public RefObject_1_0 findFolder(UserHome user, String profileName, SyncCollection collection, boolean forAddDelete, boolean forChange) {
        AirSyncProfile syncProfile;
        String collectionId = collection.getCollectionId();
        DataType collectionType = collection.getDataType();
        if (collectionId != null && DEFAULT_FOLDERS.keySet().contains(collectionId)) {
            return null;
        }
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)user);
        Path feedIdentity = this.datatypeMapper.toObjectIdentity(collectionId);
        if (feedIdentity == null && collectionType != null && (syncProfile = this.getSyncProfile(user, profileName)) != null) {
            SyncFeedQuery query = (SyncFeedQuery)pm.newQuery(SyncFeed.class);
            query.thereExistsIsActive().isTrue();
            query.orderByName().ascending();
            List feeds = syncProfile.getFeed(query);
            for (SyncFeed feed : feeds) {
                if (feed instanceof ContactsFeed && collectionType == DataType.Contacts) {
                    feedIdentity = feed.refGetPath();
                    break;
                }
                if (!(feed instanceof ActivityGroupCalendarFeed) && !(feed instanceof ActivityFilterCalendarFeed) || collectionType != DataType.Calendar && collectionType != DataType.Email && collectionType != DataType.Tasks) continue;
                feedIdentity = feed.refGetPath();
                break;
            }
        }
        if (feedIdentity != null) {
            RefObject_1_0 feed = null;
            try {
                feed = (RefObject_1_0)pm.getObjectById((Object)feedIdentity);
            }
            catch (Exception query) {
                // empty catch block
            }
            if (feed instanceof SyncFeed) {
                if (collection.getCollectionId() == null || collection.getCollectionId().length() == 0) {
                    collection.setCollectionId(this.datatypeMapper.toObjectId(feed));
                }
                SyncFeed syncFeed = (SyncFeed)feed;
                if (!(forAddDelete && !Boolean.TRUE.equals(syncFeed.isAllowAddDelete()) || forChange && !Boolean.TRUE.equals(syncFeed.isAllowChange()))) {
                    return syncFeed instanceof ContactsFeed ? ((ContactsFeed)syncFeed).getAccountGroup() : (syncFeed instanceof ActivityGroupCalendarFeed ? ((ActivityGroupCalendarFeed)syncFeed).getActivityGroup() : (syncFeed instanceof ActivityFilterCalendarFeed ? ((ActivityFilterCalendarFeed)syncFeed).getActivityFilter() : null));
                }
                return null;
            }
            return feed;
        }
        return null;
    }

    public boolean isInitialSync(SyncBackend.RequestContext requestContext, String syncKey) throws ServiceException {
        return INITIAL_SYNC_KEY.equals(syncKey) || FIRST_SYNC_KEY.equals(syncKey);
    }

    @Override
    public String getNextSyncKey(SyncBackend.RequestContext requestContext, String syncKey) {
        return INITIAL_SYNC_KEY.equals(syncKey) ? FIRST_SYNC_KEY : Long.toString(System.currentTimeMillis());
    }

    @Override
    public void deleteDataItem(SyncBackend.RequestContext requestContext, String profileName, SyncCollection collection, String itemId) throws ServiceException {
        Path objectIdentity;
        UserHome user;
        RefObject_1_0 folder;
        PersistenceManager pm = this.newPersistenceManager(requestContext);
        if (pm != null && (folder = this.findFolder(user = this.getUserHome(pm, requestContext.getUserId()), profileName, collection, true, false)) != null && (objectIdentity = this.datatypeMapper.toObjectIdentity(itemId)) != null) {
            RefObject_1_0 refObj = (RefObject_1_0)pm.getObjectById((Object)objectIdentity);
            try {
                if (folder instanceof AbstractGroup && refObj instanceof GenericAccount) {
                    MemberQuery memberQuery = (MemberQuery)pm.newQuery(Member.class);
                    memberQuery.thereExistsAccount().equalTo(refObj);
                    List members = ((AbstractGroup)folder).getMember(memberQuery);
                    pm.currentTransaction().begin();
                    for (Member member : members) {
                        member.setDisabled(true);
                    }
                    pm.currentTransaction().commit();
                } else if (refObj instanceof Alert) {
                    pm.currentTransaction().begin();
                    ((Alert)refObj).setAlertState(UserHomes.AlertState.ACCEPTED.getValue());
                    pm.currentTransaction().commit();
                } else if (folder instanceof DocumentFolder && refObj instanceof Document) {
                    FolderAssignmentQuery folderAssignmentQuery = (FolderAssignmentQuery)pm.newQuery(FolderAssignment.class);
                    folderAssignmentQuery.thereExistsDocumentFolder().equalTo(folder);
                    List folderAssignments = ((Document)refObj).getDocumentFolderAssignment(folderAssignmentQuery);
                    pm.currentTransaction().begin();
                    for (FolderAssignment folderAssignment : folderAssignments) {
                        folderAssignment.setDisabled(true);
                    }
                    pm.currentTransaction().commit();
                } else if (refObj instanceof CrxObject) {
                    pm.currentTransaction().begin();
                    ((CrxObject)refObj).setDisabled(true);
                    pm.currentTransaction().commit();
                }
            }
            catch (Exception e) {
                new ServiceException(e).log();
                try {
                    pm.currentTransaction().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public SyncDataItem fetchDataItem(SyncBackend.RequestContext requestContext, String profileName, SyncCollection collection, String itemId) throws ServiceException {
        PersistenceManager pm = this.newPersistenceManager(requestContext);
        if (pm != null) {
            UserHome user = this.getUserHome(pm, requestContext.getUserId());
            Path objectIdentity = this.datatypeMapper.toObjectIdentity(itemId);
            if (objectIdentity != null) {
                RefObject_1_0 object = (RefObject_1_0)pm.getObjectById((Object)objectIdentity);
                return this.datatypeMapper.toDataItem(object, false, user, requestContext);
            }
        }
        return null;
    }

    @Override
    public AttachmentDataT getAttachementData(SyncBackend.RequestContext requestContext, String attachmentId) throws ServiceException {
        Path objectIdentity;
        PersistenceManager pm = this.newPersistenceManager(requestContext);
        if (pm != null && (objectIdentity = this.datatypeMapper.toObjectIdentity(attachmentId)) != null) {
            RefObject_1_0 object = (RefObject_1_0)pm.getObjectById((Object)objectIdentity);
            return this.datatypeMapper.toAttachmentData(object);
        }
        return null;
    }

    protected Activity createActivity(ActivityGroup group, short activityClass, String name, String detailedDescription, Date scheduledStart) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)group);
        ActivityCreator creator = null;
        ActivityGroupIsCreatedBy.ActivityCreator activityCreators = group.getActivityCreator();
        Iterator iterator = activityCreators.iterator();
        while (iterator.hasNext()) {
            ActivityCreator activityCreator = (ActivityCreator)iterator.next();
            if (activityCreator.getActivityType() == null || activityCreator.getActivityType().getActivityClass() != activityClass) continue;
            creator = activityCreator;
            break;
        }
        Activity activity = null;
        if (creator != null) {
            NewActivityParams params = (NewActivityParams)Structures.create(NewActivityParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)NewActivityParams.Member.creationContext, null), Datatypes.member((Enum)NewActivityParams.Member.description, null), Datatypes.member((Enum)NewActivityParams.Member.detailedDescription, (Object)detailedDescription), Datatypes.member((Enum)NewActivityParams.Member.dueBy, null), Datatypes.member((Enum)NewActivityParams.Member.icalType, (Object)0), Datatypes.member((Enum)NewActivityParams.Member.name, (Object)name), Datatypes.member((Enum)NewActivityParams.Member.priority, (Object)Activities.Priority.NORMAL.getValue()), Datatypes.member((Enum)NewActivityParams.Member.reportingContact, null), Datatypes.member((Enum)NewActivityParams.Member.scheduledEnd, null), Datatypes.member((Enum)NewActivityParams.Member.scheduledStart, (Object)scheduledStart)});
            pm.currentTransaction().begin();
            NewActivityResult result = creator.newActivity(params);
            pm.currentTransaction().commit();
            if (result.getActivity() != null) {
                activity = (Activity)pm.getObjectById((Object)result.getActivity().refGetPath());
            }
        }
        return activity;
    }

    protected Document createDocument(DocumentFolder documentFolder, String name) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)documentFolder);
        String providerName = documentFolder.refGetPath().get(2);
        String segmentName = documentFolder.refGetPath().get(4);
        Segment documentSegment = (Segment)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.document1").getDescendant(new String[]{"provider", providerName, "segment", segmentName}));
        Document document = (Document)pm.newInstance(Document.class);
        document.setName(name);
        document.setTitle(name);
        document.getOwningGroup().addAll(documentFolder.getOwningGroup());
        documentSegment.addDocument(Documents.getInstance().getUidAsString(), document);
        return document;
    }

    @Override
    public String createOrUpdateDataItem(SyncBackend.RequestContext requestContext, String profileName, SyncCollection collection, String itemId, IData data) throws ServiceException {
        PersistenceManager pm = this.newPersistenceManager(requestContext);
        if (pm != null) {
            UserHome user = this.getUserHome(pm, requestContext.getUserId());
            RefObject_1_0 folderAddDelete = this.findFolder(user, profileName, collection, true, false);
            RefObject_1_0 folderChange = this.findFolder(user, profileName, collection, false, true);
            RefObject_1_0 object = null;
            if (itemId == null) {
                itemId = this.datatypeMapper.matchItem(user, data);
            }
            if (itemId == null && folderAddDelete != null) {
                switch (data.getType()) {
                    case Calendar: {
                        if (!(folderAddDelete instanceof ActivityGroup)) break;
                        EventT eventT = (EventT)data;
                        object = this.createActivity((ActivityGroup)folderAddDelete, Activities.ActivityClass.MEETING.getValue(), eventT.getSubject(), this.datatypeMapper.normalizeMultilineString(eventT.getBody()), eventT.getStartTime());
                        break;
                    }
                    case Contacts: {
                        if (!(folderAddDelete instanceof AbstractGroup)) break;
                        pm.currentTransaction().begin();
                        AbstractGroup group = (AbstractGroup)folderAddDelete;
                        String providerName = group.refGetPath().getSegment(2).toString();
                        String segmentName = group.refGetPath().getSegment(4).toString();
                        org.opencrx.kernel.account1.jmi1.Segment accountSegment = Accounts.getInstance().getAccountSegment(pm, providerName, segmentName);
                        ContactT contactT = (ContactT)data;
                        Account account = this.datatypeMapper.newAccount(pm, contactT);
                        if (account instanceof Contact) {
                            Contact contact = (Contact)account;
                            contact.setLastName(contactT.getLastName());
                            contact.setFirstName(contactT.getFirstName());
                        } else if (account instanceof AbstractGroup) {
                            AbstractGroup g = (AbstractGroup)account;
                            g.setName(contactT.getLastName());
                        }
                        account.getOwningGroup().addAll(group.getOwningGroup());
                        Member member = (Member)pm.newInstance(Member.class);
                        member.setName(contactT.getLastName() + (contactT.getFirstName() == null ? "" : ", " + contactT.getFirstName()));
                        member.setAccount(account);
                        member.setQuality((short)5);
                        group.addMember(Base.getInstance().getUidAsString(), member);
                        accountSegment.addAccount(Base.getInstance().getUidAsString(), account);
                        pm.currentTransaction().commit();
                        object = account;
                        break;
                    }
                    case Tasks: {
                        if (!(folderAddDelete instanceof ActivityGroup)) break;
                        TaskT taskT = (TaskT)data;
                        object = this.createActivity((ActivityGroup)folderAddDelete, Activities.ActivityClass.TASK.getValue(), taskT.getSubject(), this.datatypeMapper.normalizeMultilineString(taskT.getBody()), taskT.getStartdate());
                        break;
                    }
                    case Email: {
                        if (!(folderAddDelete instanceof ActivityGroup)) break;
                        EmailT emailT = (EmailT)data;
                        object = this.createActivity((ActivityGroup)folderAddDelete, Activities.ActivityClass.EMAIL.getValue(), emailT.getSubject(), null, emailT.getDateReceived());
                        break;
                    }
                    case Notes: {
                        if (!(folderAddDelete instanceof DocumentFolder)) break;
                        NoteT noteT = (NoteT)data;
                        object = this.createDocument((DocumentFolder)folderAddDelete, noteT.getSubject());
                    }
                }
            } else if (folderChange != null) {
                Path objectIdentity = this.datatypeMapper.toObjectIdentity(itemId);
                if (objectIdentity != null) {
                    try {
                        object = (RefObject_1_0)pm.getObjectById((Object)objectIdentity);
                    }
                    catch (Exception providerName) {
                        // empty catch block
                    }
                }
                if (object != null) {
                    switch (data.getType()) {
                        case Contacts: {
                            Account account = (Account)object;
                            AbstractGroup group = (AbstractGroup)folderChange;
                            ContactT contactT = (ContactT)data;
                            MemberQuery memberQuery = (MemberQuery)pm.newQuery(Member.class);
                            memberQuery.thereExistsAccount().equalTo(account);
                            List members = group.getMember(memberQuery);
                            if (!members.isEmpty()) break;
                            pm.currentTransaction().begin();
                            Member member = (Member)pm.newInstance(Member.class);
                            member.setName(contactT.getLastName() + (contactT.getFirstName() == null ? "" : ", " + contactT.getFirstName()));
                            member.setAccount(account);
                            member.setQuality((short)5);
                            group.addMember(Base.getInstance().getUidAsString(), member);
                            pm.currentTransaction().commit();
                            break;
                        }
                        case Calendar: {
                            break;
                        }
                        case Tasks: {
                            break;
                        }
                        case Notes: {
                            Document document = (Document)object;
                            DocumentFolder documentFolder = (DocumentFolder)folderChange;
                            FolderAssignmentQuery folderAssignmentQuery = (FolderAssignmentQuery)pm.newQuery(FolderAssignment.class);
                            folderAssignmentQuery.thereExistsDocumentFolder().equalTo(documentFolder);
                            List assignments = document.getDocumentFolderAssignment(folderAssignmentQuery);
                            if (!assignments.isEmpty()) break;
                            pm.currentTransaction().begin();
                            FolderAssignment folderAssignment = (FolderAssignment)pm.newInstance(FolderAssignment.class);
                            folderAssignment.setName(documentFolder.getName());
                            folderAssignment.setDocumentFolder(documentFolder);
                            document.addDocumentFolderAssignment(Base.getInstance().getUidAsString(), folderAssignment);
                            pm.currentTransaction().commit();
                        }
                    }
                }
            }
            if (object != null) {
                pm.currentTransaction().begin();
                this.datatypeMapper.toObject(data, object, user, requestContext);
                pm.currentTransaction().commit();
                String objectId = this.datatypeMapper.toObjectId(object);
                pm.close();
                return objectId;
            }
            pm.close();
        }
        return null;
    }

    @Override
    public String moveDataItem(SyncBackend.RequestContext requestContext, String profileName, String srcFolderId, String dstFolderId, String itemId) throws ServiceException {
        PersistenceManager pm = this.newPersistenceManager(requestContext);
        if (pm != null) {
            UserHome user = this.getUserHome(pm, requestContext.getUserId());
            SyncCollection srcCollection = new SyncCollection();
            srcCollection.setCollectionId(srcFolderId);
            SyncCollection dstCollection = new SyncCollection();
            dstCollection.setCollectionId(dstFolderId);
            RefObject_1_0 srcFolder = this.findFolder(user, profileName, srcCollection, true, false);
            RefObject_1_0 dstFolder = this.findFolder(user, profileName, dstCollection, true, false);
            Path itemIdentity = this.datatypeMapper.toObjectIdentity(itemId);
            if (srcFolder != null && dstFolder != null && itemIdentity != null) {
                RefObject_1_0 item = (RefObject_1_0)pm.getObjectById((Object)itemIdentity);
                if (srcFolder instanceof ActivityGroup && dstFolder instanceof ActivityGroup && item instanceof Activity) {
                    Activity activity = (Activity)item;
                    ActivityGroup srcGroup = (ActivityGroup)srcFolder;
                    ActivityGroup dstGroup = (ActivityGroup)dstFolder;
                    ActivityHasTrackerAndGroupAssignment.AssignedGroup assignments = activity.getAssignedGroup();
                    Iterator iterator = assignments.iterator();
                    while (iterator.hasNext()) {
                        ActivityGroupAssignment assignment = (ActivityGroupAssignment)iterator.next();
                        if (!assignment.getActivityGroup().equals(srcGroup)) continue;
                        pm.currentTransaction().begin();
                        assignment.setActivityGroup(dstGroup);
                        pm.currentTransaction().commit();
                        break;
                    }
                } else if (srcFolder instanceof AbstractGroup && dstFolder instanceof AbstractGroup && item instanceof Contact) {
                    Contact contact = (Contact)item;
                    AbstractGroup srcGroup = (AbstractGroup)srcFolder;
                    AbstractGroup dstGroup = (AbstractGroup)dstFolder;
                    MemberQuery query = (MemberQuery)pm.newQuery(Member.class);
                    query.thereExistsAccount().equalTo(contact);
                    List members = srcGroup.getMember(query);
                    if (!members.isEmpty()) {
                        Member srcMember = (Member)members.iterator().next();
                        pm.currentTransaction().begin();
                        srcMember.refDelete();
                        Member dstMember = (Member)pm.newInstance(Member.class);
                        dstMember.setName(srcMember.getName());
                        dstMember.setAccount(contact);
                        dstGroup.addMember(Base.getInstance().getUidAsString(), dstMember);
                        pm.currentTransaction().commit();
                    }
                }
                pm.close();
                return itemId;
            }
            pm.close();
        }
        return null;
    }

    @Override
    public void setDataItemReadFlag(SyncBackend.RequestContext requestContext, String folderId, String itemId, boolean read) throws ServiceException {
        PersistenceManager pm = this.newPersistenceManager(requestContext);
        if (pm != null) {
            RefObject_1_0 item;
            Path itemIdentity = this.datatypeMapper.toObjectIdentity(itemId);
            if (itemIdentity != null && (item = (RefObject_1_0)pm.getObjectById((Object)itemIdentity)) instanceof Alert) {
                Alert alert = (Alert)item;
                pm.currentTransaction().begin();
                if (read) {
                    UserHomes.getInstance().markAsRead(alert);
                } else {
                    UserHomes.getInstance().markAsNew(alert);
                }
                pm.currentTransaction().commit();
            }
            pm.close();
        }
    }

    @Override
    public GetChangedDataItemsResult getChangedDataItems(SyncBackend.RequestContext requestContext, String profileName, SyncCollection collection, boolean noData, int windowSize, SyncDataItem.State state, Set<String> excludes) throws ServiceException {
        PersistenceManager pm = this.newPersistenceManager(requestContext);
        String newSyncKey = collection.getSyncKey();
        TreeMap<String, List<SyncDataItem>> changedDataItems = new TreeMap<String, List<SyncDataItem>>();
        boolean hasMore = false;
        if (pm != null) {
            UserHome user = this.getUserHome(pm, requestContext.getUserId());
            RefObject_1_0 folder = this.findFolder(user, profileName, collection, false, false);
            Date since = new Date(Long.valueOf(collection.getSyncKey()));
            if (folder instanceof ActivityGroup) {
                ActivityGroup activityGroup = (ActivityGroup)folder;
                ArrayList<ActivityQuery> queries = new ArrayList<ActivityQuery>();
                switch (collection.getDataType()) {
                    case Calendar: {
                        ActivityQuery query = (ActivityQuery)pm.newQuery(Activity.class);
                        PersistenceHelper.setClasses((AnyTypePredicate)query, (Class[])new Class[]{Meeting.class, Incident.class, PhoneCall.class, Mailing.class, Absence.class, ExternalActivity.class});
                        queries.add(query);
                        break;
                    }
                    case Tasks: {
                        queries.add((ActivityQuery)pm.newQuery(Task.class));
                        break;
                    }
                    case Email: {
                        queries.add((ActivityQuery)pm.newQuery(EMail.class));
                    }
                }
                int n = 0;
                block10: for (ActivityQuery query : queries) {
                    query.forAllDisabled().isFalse();
                    if (state == SyncDataItem.State.NEW) {
                        query.createdAt().greaterThan((Comparable)since);
                        query.orderByCreatedAt().ascending();
                    } else {
                        query.modifiedAt().greaterThan((Comparable)since);
                        query.orderByModifiedAt().ascending();
                    }
                    List activities = activityGroup.getFilteredActivity(query);
                    for (Activity activity : activities) {
                        String syncKey = Long.toString(state == SyncDataItem.State.NEW ? activity.getCreatedAt().getTime() : activity.getModifiedAt().getTime());
                        if (n >= windowSize && !syncKey.equals(newSyncKey)) {
                            hasMore = true;
                            continue block10;
                        }
                        SyncDataItem dataItem = this.datatypeMapper.toDataItem(activity, noData, user, requestContext);
                        if (!excludes.contains(dataItem.getServerId())) {
                            ArrayList<SyncDataItem> items = (ArrayList<SyncDataItem>)changedDataItems.get(syncKey);
                            if (items == null) {
                                items = new ArrayList<SyncDataItem>();
                                changedDataItems.put(syncKey, items);
                            }
                            items.add(dataItem);
                            ++n;
                        }
                        newSyncKey = syncKey;
                    }
                }
            } else if (folder instanceof AbstractFilterActivity) {
                AbstractFilterActivity activityFilter = (AbstractFilterActivity)folder;
                ArrayList<ActivityQuery> queries = new ArrayList<ActivityQuery>();
                switch (collection.getDataType()) {
                    case Calendar: {
                        ActivityQuery query = (ActivityQuery)pm.newQuery(Activity.class);
                        PersistenceHelper.setClasses((AnyTypePredicate)query, (Class[])new Class[]{Meeting.class, Incident.class, PhoneCall.class, Mailing.class, Absence.class, ExternalActivity.class});
                        queries.add(query);
                        break;
                    }
                    case Tasks: {
                        queries.add((ActivityQuery)pm.newQuery(Task.class));
                        break;
                    }
                    case Email: {
                        queries.add((ActivityQuery)pm.newQuery(EMail.class));
                    }
                }
                int n = 0;
                block12: for (ActivityQuery query : queries) {
                    query.forAllDisabled().isFalse();
                    if (state == SyncDataItem.State.NEW) {
                        query.createdAt().greaterThan((Comparable)since);
                        query.orderByCreatedAt().ascending();
                    } else {
                        query.modifiedAt().greaterThan((Comparable)since);
                        query.orderByModifiedAt().ascending();
                    }
                    List activities = activityFilter.getFilteredActivity(query);
                    for (Activity activity : activities) {
                        String syncKey = Long.toString(state == SyncDataItem.State.NEW ? activity.getCreatedAt().getTime() : activity.getModifiedAt().getTime());
                        if (n >= windowSize && !syncKey.equals(newSyncKey)) {
                            hasMore = true;
                            continue block12;
                        }
                        SyncDataItem dataItem = this.datatypeMapper.toDataItem(activity, noData, user, requestContext);
                        if (!excludes.contains(dataItem.getServerId())) {
                            ArrayList<SyncDataItem> items = (ArrayList<SyncDataItem>)changedDataItems.get(syncKey);
                            if (items == null) {
                                items = new ArrayList<SyncDataItem>();
                                changedDataItems.put(syncKey, items);
                            }
                            items.add(dataItem);
                            ++n;
                        }
                        newSyncKey = syncKey;
                    }
                }
            } else if (folder instanceof AbstractGroup) {
                AbstractGroup group = (AbstractGroup)folder;
                HashSet<Path> changedContacts = new HashSet<Path>();
                AccountMembershipQuery query = (AccountMembershipQuery)pm.newQuery(AccountMembership.class);
                query.forAllDisabled().isFalse();
                query.thereExistsAccountTo().forAllDisabled().isFalse();
                query.distance().equalTo((Object)1);
                if (state == SyncDataItem.State.NEW) {
                    query.createdAt().greaterThan((Comparable)since);
                    query.orderByCreatedAt().ascending();
                } else {
                    query.modifiedAt().greaterThan((Comparable)since);
                    query.orderByModifiedAt().ascending();
                }
                QueryExtensionRecord queryExtension = PersistenceHelper.newQueryExtension((AnyTypePredicate)query);
                queryExtension.setClause("/*!DBOBJECT 1 */ (1=1)");
                List memberships = group.getAccountMembership(query);
                int n = 0;
                for (AccountMembership membership : memberships) {
                    if (changedContacts.contains(membership.getAccountTo().refGetPath())) continue;
                    String syncKey = Long.toString(state == SyncDataItem.State.NEW ? membership.getCreatedAt().getTime() : membership.getModifiedAt().getTime());
                    if (n >= windowSize && !syncKey.equals(newSyncKey)) {
                        hasMore = true;
                        break;
                    }
                    SyncDataItem dataItem = this.datatypeMapper.toDataItem(membership.getAccountTo(), noData, user, requestContext);
                    if (!excludes.contains(dataItem.getServerId())) {
                        ArrayList<SyncDataItem> items = (ArrayList<SyncDataItem>)changedDataItems.get(syncKey);
                        if (items == null) {
                            items = new ArrayList<SyncDataItem>();
                            changedDataItems.put(syncKey, items);
                        }
                        items.add(dataItem);
                        changedContacts.add(membership.getAccountTo().refGetPath());
                        ++n;
                    }
                    newSyncKey = syncKey;
                }
            } else if (folder instanceof UserHome) {
                UserHome home = (UserHome)folder;
                AlertQuery query = (AlertQuery)pm.newQuery(Alert.class);
                if (state == SyncDataItem.State.NEW) {
                    query.createdAt().greaterThan((Comparable)since);
                    query.orderByCreatedAt().ascending();
                    query.alertState().equalTo((Object)UserHomes.AlertState.NEW.getValue());
                    List alerts = home.getAlert(query);
                    int n = 0;
                    for (Alert alert : alerts) {
                        String syncKey = Long.toString(alert.getCreatedAt().getTime());
                        if (n >= windowSize && !syncKey.equals(newSyncKey)) {
                            hasMore = true;
                            break;
                        }
                        SyncDataItem dataItem = this.datatypeMapper.toDataItem(alert, noData, user, requestContext);
                        if (!excludes.contains(dataItem.getServerId())) {
                            ArrayList<SyncDataItem> items = (ArrayList<SyncDataItem>)changedDataItems.get(syncKey);
                            if (items == null) {
                                items = new ArrayList<SyncDataItem>();
                                changedDataItems.put(syncKey, items);
                            }
                            items.add(dataItem);
                            ++n;
                        }
                        newSyncKey = syncKey;
                    }
                }
            } else if (folder instanceof DocumentFolder) {
                DocumentFolder documentFolder = (DocumentFolder)folder;
                HashSet<Path> changedDocuments = new HashSet<Path>();
                DocumentQuery query = (DocumentQuery)pm.newQuery(Document.class);
                query.forAllDisabled().isFalse();
                query.thereExistsDocumentFolderAssignment().forAllDisabled().isFalse();
                query.thereExistsDocumentFolderAssignment().thereExistsDocumentFolder().equalTo(documentFolder);
                query.thereExistsContentType().equalTo((Object)NOTE_MIME_TYPE);
                if (state == SyncDataItem.State.NEW) {
                    query.createdAt().greaterThan((Comparable)since);
                    query.orderByCreatedAt().ascending();
                } else {
                    query.modifiedAt().greaterThan((Comparable)since);
                    query.orderByModifiedAt().ascending();
                }
                String providerName = documentFolder.refGetPath().get(2);
                String segmentName = documentFolder.refGetPath().get(4);
                Segment documentSegment = (Segment)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.document1").getDescendant(new String[]{"provider", providerName, "segment", segmentName}));
                List documents = documentSegment.getDocument(query);
                int n = 0;
                for (Document document : documents) {
                    if (changedDocuments.contains(document.refGetPath())) continue;
                    String syncKey = Long.toString(state == SyncDataItem.State.NEW ? document.getCreatedAt().getTime() : document.getModifiedAt().getTime());
                    if (n >= windowSize && !syncKey.equals(newSyncKey)) {
                        hasMore = true;
                        break;
                    }
                    SyncDataItem dataItem = this.datatypeMapper.toDataItem(document, noData, user, requestContext);
                    if (!excludes.contains(dataItem.getServerId())) {
                        ArrayList<SyncDataItem> items = (ArrayList<SyncDataItem>)changedDataItems.get(syncKey);
                        if (items == null) {
                            items = new ArrayList<SyncDataItem>();
                            changedDataItems.put(syncKey, items);
                        }
                        items.add(dataItem);
                        changedDocuments.add(document.refGetPath());
                        ++n;
                    }
                    newSyncKey = syncKey;
                }
            }
            pm.close();
        }
        return new GetChangedDataItemsResult(changedDataItems, hasMore, newSyncKey);
    }

    @Override
    public List<String> getDeletedDataItems(SyncBackend.RequestContext requestContext, String profileName, SyncCollection collection, String syncKeyTo) throws ServiceException {
        PersistenceManager pm = this.newPersistenceManager(requestContext);
        ArrayList<String> deletedDataItems = new ArrayList<String>();
        if (pm != null && !this.isInitialSync(requestContext, collection.getSyncKey())) {
            UserHome user = this.getUserHome(pm, requestContext.getUserId());
            RefObject_1_0 folder = this.findFolder(user, profileName, collection, false, false);
            Date since = new Date(Long.valueOf(collection.getSyncKey()));
            Date to = new Date(Long.valueOf(syncKeyTo));
            if (folder instanceof ActivityGroup) {
                ActivityGroup activityGroup = (ActivityGroup)folder;
                ArrayList<ActivityQuery> queries = new ArrayList<ActivityQuery>();
                switch (collection.getDataType()) {
                    case Calendar: {
                        queries.add((ActivityQuery)pm.newQuery(Meeting.class));
                        queries.add((ActivityQuery)pm.newQuery(Incident.class));
                        break;
                    }
                    case Tasks: {
                        queries.add((ActivityQuery)pm.newQuery(Task.class));
                        break;
                    }
                    case Email: {
                        queries.add((ActivityQuery)pm.newQuery(EMail.class));
                    }
                }
                for (ActivityQuery query : queries) {
                    query.thereExistsDisabled().isTrue();
                    query.modifiedAt().greaterThan((Comparable)since);
                    query.modifiedAt().lessThanOrEqualTo((Comparable)to);
                    query.orderByModifiedAt().ascending();
                    List activities = activityGroup.getFilteredActivity(query);
                    for (Activity activity : activities) {
                        deletedDataItems.add(this.datatypeMapper.toObjectId(activity));
                    }
                }
            } else if (folder instanceof AbstractGroup) {
                AbstractGroup group = (AbstractGroup)folder;
                HashSet<Path> deletedContacts = new HashSet<Path>();
                AccountMembershipQuery query = (AccountMembershipQuery)pm.newQuery(AccountMembership.class);
                query.thereExistsDisabled().isTrue();
                query.distance().equalTo((Object)1);
                query.modifiedAt().greaterThan((Comparable)since);
                query.modifiedAt().lessThanOrEqualTo((Comparable)to);
                query.orderByModifiedAt().ascending();
                QueryExtensionRecord queryExtension = PersistenceHelper.newQueryExtension((AnyTypePredicate)query);
                queryExtension.setClause("/*!DBOBJECT 1 */ (1=1)");
                List memberships = group.getAccountMembership(query);
                for (AccountMembership membership : memberships) {
                    if (!(membership.getAccountTo() instanceof Contact) || deletedContacts.contains(membership.getAccountTo().refGetPath())) continue;
                    deletedDataItems.add(this.datatypeMapper.toObjectId(membership.getAccountTo()));
                    deletedContacts.add(membership.getAccountTo().refGetPath());
                }
            } else if (folder instanceof UserHome) {
                UserHome home = (UserHome)folder;
                AlertQuery query = (AlertQuery)pm.newQuery(Alert.class);
                query.modifiedAt().greaterThan((Comparable)since);
                query.modifiedAt().lessThanOrEqualTo((Comparable)to);
                query.alertState().equalTo((Object)UserHomes.AlertState.ACCEPTED.getValue());
                query.orderByModifiedAt().ascending();
                List alerts = home.getAlert(query);
                for (Alert alert : alerts) {
                    deletedDataItems.add(this.datatypeMapper.toObjectId(alert));
                }
            } else if (folder instanceof DocumentFolder) {
                DocumentFolder documentFolder = (DocumentFolder)folder;
                HashSet<Path> deletedDocuments = new HashSet<Path>();
                DocumentQuery query = (DocumentQuery)pm.newQuery(Document.class);
                query.thereExistsDocumentFolderAssignment().thereExistsDisabled().isTrue();
                query.thereExistsDocumentFolderAssignment().thereExistsDocumentFolder().equalTo(documentFolder);
                query.thereExistsDocumentFolderAssignment().modifiedAt().greaterThan((Comparable)since);
                query.thereExistsDocumentFolderAssignment().modifiedAt().lessThanOrEqualTo((Comparable)to);
                query.thereExistsContentType().equalTo((Object)NOTE_MIME_TYPE);
                query.orderByModifiedAt().ascending();
                String providerName = documentFolder.refGetPath().get(2);
                String segmentName = documentFolder.refGetPath().get(4);
                Segment documentSegment = (Segment)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.document1").getDescendant(new String[]{"provider", providerName, "segment", segmentName}));
                List documents = documentSegment.getDocument(query);
                for (Document document : documents) {
                    if (deletedDocuments.contains(document.refGetPath())) continue;
                    deletedDataItems.add(this.datatypeMapper.toObjectId(document));
                    deletedDocuments.add(document.refGetPath());
                }
            }
            pm.close();
        }
        return deletedDataItems;
    }

    @Override
    public String createOrUpdateFolder(SyncBackend.RequestContext requestContext, SyncFolder folder) {
        return null;
    }

    @Override
    public String deleteFolder(SyncBackend.RequestContext requestContext, String folderId) {
        return null;
    }

    @Override
    public boolean folderIsValid(SyncBackend.RequestContext requestContext, String profileName, SyncCollection collection) throws ServiceException {
        PersistenceManager pm = this.newPersistenceManager(requestContext);
        UserHome user = this.getUserHome(pm, requestContext.getUserId());
        RefObject_1_0 folder = this.findFolder(user, profileName, collection, false, false);
        return folder != null;
    }

    public List<SyncFolder> getFolders(SyncBackend.RequestContext requestContext, String profileName, String syncKey, boolean activeFoldersOnly) throws ServiceException {
        PersistenceManager pm = this.newPersistenceManager(requestContext);
        ArrayList<SyncFolder> changedFolders = new ArrayList<SyncFolder>();
        if (pm != null) {
            Date since = new Date(Long.valueOf(syncKey));
            UserHome user = this.getUserHome(pm, requestContext.getUserId());
            AirSyncProfile profile = this.getSyncProfile(user, profileName);
            if (profile != null) {
                SyncFolder syncFolder = new SyncFolder();
                SyncFeedQuery feedQuery = (SyncFeedQuery)pm.newQuery(SyncFeed.class);
                feedQuery.modifiedAt().greaterThanOrEqualTo((Comparable)since);
                if (activeFoldersOnly) {
                    feedQuery.thereExistsIsActive().isTrue();
                } else {
                    feedQuery.forAllIsActive().isFalse();
                }
                List feeds = profile.getFeed(feedQuery);
                for (SyncFeed feed : feeds) {
                    if (feed instanceof ActivityFilterCalendarFeed) {
                        syncFolder = new SyncFolder();
                        syncFolder.setServerId(this.datatypeMapper.toObjectId(feed) + "?type=" + Activities.ActivityClass.MEETING.getValue());
                        syncFolder.setFolderType(feed.getName().endsWith("~Private") ? FolderType.DEFAULT_CALENDAR_FOLDER : FolderType.USER_CREATED_CALENDAR_FOLDER);
                        syncFolder.setDisplayName(feed.getName() + " - Calendar");
                        syncFolder.setParentId(INITIAL_SYNC_KEY);
                        changedFolders.add(syncFolder);
                        syncFolder = new SyncFolder();
                        syncFolder.setServerId(this.datatypeMapper.toObjectId(feed) + "?type=" + Activities.ActivityClass.EMAIL.getValue());
                        syncFolder.setFolderType(FolderType.USER_CREATED_EMAIL_FOLDER);
                        syncFolder.setDisplayName(feed.getName() + " - Mails");
                        syncFolder.setParentId(INITIAL_SYNC_KEY);
                        changedFolders.add(syncFolder);
                        syncFolder = new SyncFolder();
                        syncFolder.setServerId(this.datatypeMapper.toObjectId(feed) + "?type=" + Activities.ActivityClass.TASK.getValue());
                        syncFolder.setFolderType(feed.getName().endsWith("~Private") ? FolderType.DEFAULT_TASKS_FOLDER : FolderType.USER_CREATED_TASKS_FOLDER);
                        syncFolder.setDisplayName(feed.getName() + " - Tasks");
                        syncFolder.setParentId(INITIAL_SYNC_KEY);
                        changedFolders.add(syncFolder);
                        continue;
                    }
                    if (feed instanceof ActivityGroupCalendarFeed) {
                        ActivityGroupCalendarFeed activityGroupFeed = (ActivityGroupCalendarFeed)feed;
                        ActivityGroup activityGroup = activityGroupFeed.getActivityGroup();
                        ActivityGroupIsCreatedBy.ActivityCreator activityCreators = activityGroup.getActivityCreator();
                        Iterator iterator = activityCreators.iterator();
                        while (iterator.hasNext()) {
                            ActivityCreator activityCreator = (ActivityCreator)iterator.next();
                            short activityClass = activityCreator.getActivityType().getActivityClass();
                            if (activityClass == Activities.ActivityClass.MEETING.getValue()) {
                                syncFolder = new SyncFolder();
                                syncFolder.setServerId(this.datatypeMapper.toObjectId(feed) + "?type=" + Activities.ActivityClass.MEETING.getValue());
                                syncFolder.setFolderType(feed.getName().endsWith("~Private") ? FolderType.DEFAULT_CALENDAR_FOLDER : FolderType.USER_CREATED_CALENDAR_FOLDER);
                                syncFolder.setDisplayName(feed.getName() + " - Calendar");
                                syncFolder.setParentId(INITIAL_SYNC_KEY);
                                changedFolders.add(syncFolder);
                                continue;
                            }
                            if (activityClass == Activities.ActivityClass.EMAIL.getValue()) {
                                syncFolder = new SyncFolder();
                                syncFolder.setServerId(this.datatypeMapper.toObjectId(feed) + "?type=" + Activities.ActivityClass.EMAIL.getValue());
                                syncFolder.setFolderType(FolderType.USER_CREATED_EMAIL_FOLDER);
                                syncFolder.setDisplayName(feed.getName() + " - Mails");
                                syncFolder.setParentId(INITIAL_SYNC_KEY);
                                changedFolders.add(syncFolder);
                                continue;
                            }
                            if (activityClass != Activities.ActivityClass.TASK.getValue()) continue;
                            syncFolder = new SyncFolder();
                            syncFolder.setServerId(this.datatypeMapper.toObjectId(feed) + "?type=" + Activities.ActivityClass.TASK.getValue());
                            syncFolder.setFolderType(feed.getName().endsWith("~Private") ? FolderType.DEFAULT_TASKS_FOLDER : FolderType.USER_CREATED_TASKS_FOLDER);
                            syncFolder.setDisplayName(feed.getName() + " - Tasks");
                            syncFolder.setParentId(INITIAL_SYNC_KEY);
                            changedFolders.add(syncFolder);
                        }
                        continue;
                    }
                    if (feed instanceof ContactsFeed) {
                        syncFolder = new SyncFolder();
                        syncFolder.setServerId(this.datatypeMapper.toObjectId(feed));
                        syncFolder.setFolderType(feed.getName().endsWith("~Private") ? FolderType.DEFAULT_CONTACTS_FOLDER : FolderType.USER_CREATED_CONTACTS_FOLDER);
                        syncFolder.setDisplayName(feed.getName() + " - Contacts");
                        syncFolder.setParentId(INITIAL_SYNC_KEY);
                        changedFolders.add(syncFolder);
                        continue;
                    }
                    if (!(feed instanceof DocumentFeed)) continue;
                    syncFolder = new SyncFolder();
                    syncFolder.setServerId(this.datatypeMapper.toObjectId(feed));
                    syncFolder.setFolderType(feed.getName().endsWith("~Private") ? FolderType.DEFAULT_NOTES_FOLDER : FolderType.USER_CREATED_NOTES_FOLDER);
                    syncFolder.setDisplayName(feed.getName() + " - Notes");
                    syncFolder.setParentId(INITIAL_SYNC_KEY);
                    changedFolders.add(syncFolder);
                }
                if (activeFoldersOnly && user.getModifiedAt().compareTo(since) > 0) {
                    syncFolder = new SyncFolder();
                    syncFolder.setServerId(this.datatypeMapper.toObjectId(user));
                    syncFolder.setFolderType(FolderType.USER_CREATED_EMAIL_FOLDER);
                    syncFolder.setDisplayName(user.refGetPath().getLastSegment().toString() + " - Alerts");
                    syncFolder.setParentId(INITIAL_SYNC_KEY);
                    changedFolders.add(syncFolder);
                }
                if (activeFoldersOnly && since.getTime() == 0L) {
                    for (SyncFolder defaultFolder : DEFAULT_FOLDERS.values()) {
                        changedFolders.add(defaultFolder);
                    }
                }
            }
            pm.close();
        }
        return changedFolders;
    }

    @Override
    public List<SyncFolder> getChangedFolders(SyncBackend.RequestContext requestContext, String profileName, String syncKey) throws ServiceException {
        return this.getFolders(requestContext, profileName, syncKey, true);
    }

    @Override
    public List<SyncFolder> getDeletedFolders(SyncBackend.RequestContext requestContext, String profileName, String syncKey) throws ServiceException {
        return this.getFolders(requestContext, profileName, syncKey, false);
    }

    @Override
    public void sendMail(SyncBackend.RequestContext requestContext, InputStream mimeMessage) throws ServiceException {
        PersistenceManager pm = this.newPersistenceManager(requestContext);
        Transport transport = null;
        if (pm != null) {
            UserHome user = this.getUserHome(pm, requestContext.getUserId());
            if (user != null) {
                String providerName = user.refGetPath().get(2);
                String segmentName = user.refGetPath().get(4);
                MimeMessage message = null;
                try {
                    InitialContext initialContext = new InitialContext();
                    Session session = null;
                    String mailServiceName = "/mail/provider/" + providerName + "/segment/" + segmentName;
                    try {
                        session = (Session)initialContext.lookup("java:comp/env" + mailServiceName);
                    }
                    catch (Exception e) {
                        SysLog.detail((String)"Mail service not found", (Object)mailServiceName);
                        mailServiceName = "/mail/provider/" + providerName;
                        SysLog.detail((String)"Fall back to mail service", (Object)mailServiceName);
                        session = (Session)initialContext.lookup("java:comp/env" + mailServiceName);
                    }
                    message = new MimeMessage(session, mimeMessage);
                    transport = session.getTransport();
                    String protocol = transport.getURLName().getProtocol();
                    String port = session.getProperty("mail." + protocol + ".port");
                    transport.connect(session.getProperty("mail." + protocol + ".host"), port == null ? -1 : Integer.valueOf(port), session.getProperty("mail." + protocol + ".user"), session.getProperty("mail." + protocol + ".password"));
                    transport.sendMessage((Message)message, message.getAllRecipients());
                }
                catch (Exception e) {
                    pm.close();
                    throw new ServiceException(e);
                }
                finally {
                    if (transport != null) {
                        try {
                            transport.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                try {
                    ActivityCreator emailCreator = (ActivityCreator)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.activity1/provider/" + providerName + "/segment/" + segmentName + "/activityCreator/" + user.refGetPath().getLastSegment().toString() + "~E-Mails"));
                    if (emailCreator != null && message != null) {
                        Activities.getInstance().importMimeMessage(pm, providerName, segmentName, message, emailCreator);
                    }
                }
                catch (Exception e) {
                    pm.close();
                    throw new ServiceException(e);
                }
                finally {
                    try {
                        pm.currentTransaction().rollback();
                    }
                    catch (Exception exception) {}
                }
            }
            pm.close();
        }
    }

    @Override
    public File getContextTempDir(SyncBackend.RequestContext requestContext, File tempDir) throws ServiceException {
        PersistenceManager pm = this.newPersistenceManager(requestContext);
        UserHome user = this.getUserHome(pm, requestContext.getUserId());
        if (user != null) {
            String providerName = user.refGetPath().get(2);
            String segmentName = user.refGetPath().get(4);
            return new File(tempDir, providerName + File.separator + segmentName);
        }
        return tempDir;
    }

    @Override
    public ClientProfile getClientProfile(SyncBackend.RequestContext requestContext, String profileName) throws ServiceException {
        ClientProfile clientProfile = new ClientProfile();
        String userId = requestContext.getUserId();
        clientProfile.setUserId(userId);
        clientProfile.setName(profileName);
        clientProfile.setFolders(new ArrayList<ClientProfile.Folder>());
        PersistenceManager pm = this.newPersistenceManager(requestContext);
        if (pm != null) {
            UserHome user = this.getUserHome(pm, userId);
            AirSyncClientProfileQuery query = (AirSyncClientProfileQuery)pm.newQuery(AirSyncClientProfile.class);
            query.name().equalTo((Object)profileName);
            List profiles = user.getSyncProfile(query);
            if (!profiles.isEmpty()) {
                AirSyncClientProfile syncProfile = (AirSyncClientProfile)profiles.iterator().next();
                Properties properties = new Properties();
                if (syncProfile.getDescription() != null) {
                    try {
                        properties.load(new StringReader(syncProfile.getDescription()));
                        clientProfile.setUserAgent(properties.getProperty("UserAgent"));
                        clientProfile.setPolicyKey(properties.getProperty("PolicyKey"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                SyncFeedQuery feedQuery = (SyncFeedQuery)pm.newQuery(SyncFeed.class);
                feedQuery.thereExistsIsActive().isTrue();
                feedQuery.orderByName().ascending();
                List syncFeeds = syncProfile.getFeed(feedQuery);
                for (SyncFeed syncFeed : syncFeeds) {
                    String description;
                    String clientId = this.datatypeMapper.toObjectId(syncFeed);
                    if (clientId == null || (description = syncFeed.getDescription()) == null) continue;
                    try {
                        properties = new Properties();
                        properties.load(new StringReader(description));
                        String serverId = properties.getProperty("ServerId");
                        FolderType folderType = FolderType.valueOf(properties.getProperty("Type"));
                        String generation = properties.getProperty("Generation");
                        String syncKeyServer = properties.getProperty("SyncKey.Server");
                        String syncKeyClient = properties.getProperty("SyncKey.Client");
                        String parentId = properties.getProperty("ParentId");
                        ClientProfile.Folder folder = new ClientProfile.Folder();
                        folder.setName(syncFeed.getName());
                        folder.setGeneration(generation == null ? 0 : Integer.valueOf(generation));
                        folder.setClientId(clientId);
                        folder.setServerId(serverId == null ? null : serverId.trim());
                        folder.setParentId(parentId == null ? null : parentId.trim());
                        folder.setSyncKeyClient(syncKeyClient == null ? null : syncKeyClient.trim());
                        folder.setSyncKeyServer(syncKeyServer == null ? null : syncKeyServer.trim());
                        folder.setType(folderType);
                        Properties idMapping = new Properties();
                        SyncFeedHasData.SyncData syncDatas = syncFeed.getSyncData();
                        Iterator iterator = syncDatas.iterator();
                        while (iterator.hasNext()) {
                            SyncData syncData = (SyncData)iterator.next();
                            if (!"Mapping".equals(syncData.getTitle()) || syncData.getText() == null) continue;
                            idMapping.load(new StringReader(syncData.getText()));
                            break;
                        }
                        folder.setIdMap(idMapping);
                        clientProfile.getFolders().add(folder);
                    }
                    catch (Exception e) {
                        new ServiceException(e).log();
                    }
                }
            }
        }
        return clientProfile;
    }

    @Override
    public void updateClientProfile(SyncBackend.RequestContext requestContext, ClientProfile clientSyncProfile, Set<String> folderIds, boolean noSyncKeys, boolean noMappings) throws ServiceException {
        PersistenceManager pm = this.newPersistenceManager(requestContext);
        if (pm != null) {
            UserHome user = this.getUserHome(pm, clientSyncProfile.getUserId());
            AirSyncClientProfileQuery profileQuery = (AirSyncClientProfileQuery)pm.newQuery(AirSyncClientProfile.class);
            profileQuery.name().equalTo((Object)clientSyncProfile.getName());
            List profiles = user.getSyncProfile(profileQuery);
            if (!profiles.isEmpty()) {
                AirSyncClientProfile syncProfile = (AirSyncClientProfile)profiles.iterator().next();
                Properties properties = new Properties();
                try {
                    properties.load(new StringReader(syncProfile.getDescription() == null ? "" : syncProfile.getDescription()));
                    if (clientSyncProfile.getUserAgent() != null) {
                        properties.setProperty("UserAgent", clientSyncProfile.getUserAgent());
                    }
                    if (clientSyncProfile.getPolicyKey() != null) {
                        properties.setProperty("PolicyKey", clientSyncProfile.getPolicyKey());
                    }
                    ByteArrayOutputStream propertiesAsText = new ByteArrayOutputStream();
                    properties.store(propertiesAsText, syncProfile.getName());
                    propertiesAsText.close();
                    pm.currentTransaction().begin();
                    syncProfile.setDescription(propertiesAsText.toString("ISO8859-1"));
                    pm.currentTransaction().commit();
                }
                catch (Exception e) {
                    try {
                        pm.currentTransaction().rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                SyncProfileContainsSyncFeed.Feed feeds = syncProfile.getFeed();
                HashMap<String, SyncFeed> feedsById = new HashMap<String, SyncFeed>();
                Iterator<Object> iterator = feeds.iterator();
                while (iterator.hasNext()) {
                    SyncFeed feed = (SyncFeed)iterator.next();
                    try {
                        properties = new Properties();
                        properties.load(new StringReader(feed.getDescription() == null ? "" : feed.getDescription()));
                        String serverId = properties.getProperty("ServerId");
                        if (serverId == null) continue;
                        feedsById.put(serverId.trim(), feed);
                    }
                    catch (Exception e) {
                        new ServiceException(e).log();
                    }
                }
                for (ClientProfile.Folder folder : clientSyncProfile.getFolders()) {
                    if (folderIds != null && !folderIds.contains(folder.getClientId())) continue;
                    SyncFeed feed = (SyncFeed)feedsById.get(folder.getServerId());
                    if (feed != null) {
                        if (!noSyncKeys) {
                            try {
                                properties = new Properties();
                                properties.load(new StringReader(feed.getDescription() == null ? "" : feed.getDescription()));
                                properties.setProperty("Generation", Integer.toString(folder.getGeneration()));
                                if (folder.getSyncKeyServer() == null) {
                                    properties.remove("SyncKey.Server");
                                } else if (!INITIAL_SYNC_KEY.equals(folder.getSyncKeyServer())) {
                                    properties.setProperty("SyncKey.Server", folder.getSyncKeyServer());
                                }
                                if (folder.getSyncKeyClient() == null) {
                                    properties.remove("SyncKey.Client");
                                } else {
                                    properties.setProperty("SyncKey.Client", folder.getSyncKeyClient());
                                }
                                ByteArrayOutputStream propertiesAsText = new ByteArrayOutputStream();
                                properties.store(propertiesAsText, feed.getName());
                                propertiesAsText.close();
                                SysLog.log((Level)Level.FINE, (String)"Storing properties {0} for folder {1}", (Object[])new Object[]{properties, folder.getName()});
                                pm.currentTransaction().begin();
                                feed.setDescription(propertiesAsText.toString("ISO8859-1"));
                                pm.currentTransaction().commit();
                            }
                            catch (Exception e) {
                                new ServiceException(e).log();
                                try {
                                    pm.currentTransaction().rollback();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        if (noMappings) continue;
                        try {
                            SyncFeedHasData.SyncData syncDatas = feed.getSyncData();
                            SyncData mappingData = null;
                            Iterator iterator2 = syncDatas.iterator();
                            while (iterator2.hasNext()) {
                                SyncData syncData = (SyncData)iterator2.next();
                                if (!"Mapping".equals(syncData.getTitle())) continue;
                                mappingData = syncData;
                                break;
                            }
                            pm.currentTransaction().begin();
                            if (mappingData == null) {
                                mappingData = (SyncData)pm.newInstance(SyncData.class);
                                mappingData.setTitle("Mapping");
                                feed.addSyncData(Base.getInstance().getUidAsString(), mappingData);
                            }
                            ByteArrayOutputStream idMappingAsText = new ByteArrayOutputStream();
                            folder.getIdMap().store(idMappingAsText, "Mapping");
                            idMappingAsText.close();
                            mappingData.setText(idMappingAsText.toString("ISO8859-1"));
                            pm.currentTransaction().commit();
                        }
                        catch (Exception e) {
                            new ServiceException(e).log();
                            try {
                                pm.currentTransaction().rollback();
                            }
                            catch (Exception mappingData) {}
                        }
                        continue;
                    }
                    FolderType folderType = folder.getType();
                    switch (folderType) {
                        case DEFAULT_TASKS_FOLDER: 
                        case DEFAULT_CALENDAR_FOLDER: 
                        case USER_CREATED_CALENDAR_FOLDER: 
                        case USER_CREATED_TASKS_FOLDER: 
                        case USER_CREATED_EMAIL_FOLDER: {
                            feed = (SyncFeed)pm.newInstance(ActivityGroupCalendarFeed.class);
                            break;
                        }
                        case DEFAULT_CONTACTS_FOLDER: 
                        case USER_CREATED_CONTACTS_FOLDER: {
                            feed = (SyncFeed)pm.newInstance(ContactsFeed.class);
                        }
                    }
                    if (feed == null) continue;
                    feed.setName(folder.getName());
                    feed.setActive(false);
                    feed.setAllowAddDelete(true);
                    feed.setAllowChange(true);
                    properties = new Properties();
                    properties.setProperty("ServerId", folder.getServerId());
                    properties.setProperty("ParentId", folder.getParentId());
                    properties.setProperty("Type", folderType.toString());
                    ByteArrayOutputStream propertiesAsText = new ByteArrayOutputStream();
                    try {
                        properties.store(propertiesAsText, folder.getName());
                        propertiesAsText.close();
                        feed.setDescription(propertiesAsText.toString("ISO8859-1"));
                        pm.currentTransaction().begin();
                        syncProfile.addFeed(Base.getInstance().getUidAsString(), feed);
                        pm.currentTransaction().commit();
                    }
                    catch (Exception e) {
                        new ServiceException(e).log();
                        try {
                            pm.currentTransaction().rollback();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }

    static {
        SyncFolder syncFolder = new SyncFolder();
        syncFolder.setServerId("3");
        syncFolder.setFolderType(FolderType.DEFAULT_DELETED_ITEMS_FOLDERS);
        syncFolder.setDisplayName("Deleted Items");
        syncFolder.setParentId(INITIAL_SYNC_KEY);
        DEFAULT_FOLDERS.put("3", syncFolder);
        syncFolder = new SyncFolder();
        syncFolder.setServerId("4");
        syncFolder.setFolderType(FolderType.DEFAULT_DRAFTS_FOLDERS);
        syncFolder.setDisplayName("Drafts");
        syncFolder.setParentId(INITIAL_SYNC_KEY);
        DEFAULT_FOLDERS.put("4", syncFolder);
        syncFolder = new SyncFolder();
        syncFolder.setServerId("5");
        syncFolder.setFolderType(FolderType.DEFAULT_INBOX_FOLDER);
        syncFolder.setDisplayName("Inbox");
        syncFolder.setParentId(INITIAL_SYNC_KEY);
        DEFAULT_FOLDERS.put("5", syncFolder);
        syncFolder = new SyncFolder();
        syncFolder.setServerId("9");
        syncFolder.setFolderType(FolderType.DEFAULT_OUTBOX_FOLDER);
        syncFolder.setDisplayName("Outbox");
        syncFolder.setParentId(INITIAL_SYNC_KEY);
        DEFAULT_FOLDERS.put("9", syncFolder);
        syncFolder = new SyncFolder();
        syncFolder.setServerId("10");
        syncFolder.setFolderType(FolderType.DEFAULT_SENT_EMAIL_FOLDER);
        syncFolder.setDisplayName("Sent Items");
        syncFolder.setParentId(INITIAL_SYNC_KEY);
        DEFAULT_FOLDERS.put("10", syncFolder);
    }
}

