/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.airsync.backend.cci;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.opencrx.application.airsync.datatypes.FolderType;

public class ClientProfile {
    private String userId = null;
    private String name = null;
    private String policyKey = null;
    private String userAgent = null;
    private List<Folder> folders = null;

    public List<Folder> getFolders() {
        return this.folders;
    }

    public void setFolders(List<Folder> folders) {
        this.folders = folders;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPolicyKey() {
        return this.policyKey;
    }

    public void setPolicyKey(String policyKey) {
        this.policyKey = policyKey;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public static class Folder {
        private String name = null;
        protected int generation = 0;
        private String clientId = null;
        private String parentId = null;
        private String serverId = null;
        private String syncKeyServer = null;
        private String syncKeyClient = null;
        private FolderType type = null;
        protected Properties idMap = null;

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getServerId() {
            return this.serverId;
        }

        public void setServerId(String serverId) {
            this.serverId = serverId;
        }

        public String getSyncKeyServer() {
            return this.syncKeyServer;
        }

        public void setSyncKeyServer(String syncKeyServer) {
            this.syncKeyServer = syncKeyServer;
        }

        public String getSyncKeyClient() {
            return this.syncKeyClient;
        }

        public void setSyncKeyClient(String syncKeyClient) {
            this.syncKeyClient = syncKeyClient;
        }

        public FolderType getType() {
            return this.type;
        }

        public void setType(FolderType type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getParentId() {
            return this.parentId;
        }

        public void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public int getGeneration() {
            return this.generation;
        }

        public void setGeneration(int generation) {
            this.generation = generation;
        }

        public Properties getIdMap() {
            return this.idMap;
        }

        public void setIdMap(Properties idMap) {
            this.idMap = idMap;
        }

        protected int getGeneration(String key) {
            int pos1 = key.indexOf("{");
            int pos2 = key.indexOf("}");
            int generation = 0;
            if (pos1 > 0 && pos2 > pos1) {
                generation = Integer.valueOf(key.substring(pos1 + 1, pos2));
            }
            return generation;
        }

        public ItemIdMappings getItemIdMappings() {
            return new ItemIdMappings();
        }

        public class ItemIdMappings {
            public ItemIdMapping getMappingByClientId(String serverId) {
                for (Map.Entry<Object, Object> e : Folder.this.idMap.entrySet()) {
                    if (!serverId.equals(e.getValue())) continue;
                    String key = (String)e.getKey();
                    String clientId = key.indexOf("{") > 0 ? key.substring(0, key.indexOf("{")) : key;
                    return new ItemIdMapping(clientId, serverId);
                }
                return null;
            }

            public String getServerId(String clientId) {
                for (int g = Folder.this.generation; g >= -1; --g) {
                    String serverId = Folder.this.idMap.getProperty(clientId + (g < 0 ? "" : "{" + g + "}"));
                    if (serverId == null) continue;
                    return serverId;
                }
                return null;
            }

            public void removeAllMappingsByClientId(String clientId) {
                Iterator<Object> i = Folder.this.idMap.keySet().iterator();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    if (!key.startsWith(clientId)) continue;
                    i.remove();
                }
            }

            public void removeAllMappingsByServerId(String serverId) {
                Iterator<Map.Entry<Object, Object>> i = Folder.this.idMap.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry<Object, Object> e = i.next();
                    if (!serverId.equals(e.getValue())) continue;
                    i.remove();
                }
            }

            public void updateMappings(String clientId, String serverId) {
                this.removeAllMappingsByClientId(clientId);
                String key = clientId + "{" + Folder.this.generation + "}";
                Folder.this.idMap.put(key, serverId);
            }

            public List<ItemIdMapping> getOldMappings() {
                ArrayList<ItemIdMapping> oldMappings = new ArrayList<ItemIdMapping>();
                for (Map.Entry<Object, Object> e : Folder.this.idMap.entrySet()) {
                    String key = (String)e.getKey();
                    int generation = Folder.this.getGeneration(key);
                    if (generation >= Folder.this.generation) continue;
                    int pos = key.indexOf("{");
                    oldMappings.add(new ItemIdMapping(pos > 0 ? key.substring(0, pos) : key, (String)e.getValue()));
                }
                return oldMappings;
            }
        }

        public static class ItemIdMapping {
            private final String clientId;
            private final String serverId;

            public ItemIdMapping(String clientId, String serverId) {
                this.clientId = clientId;
                this.serverId = serverId;
            }

            public String getClientId() {
                return this.clientId;
            }

            public String getServerId() {
                return this.serverId;
            }
        }
    }
}

