/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.adapter;

import java.net.Socket;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import org.opencrx.application.adapter.AbstractServer;
import org.opencrx.kernel.utils.Utils;
import org.opencrx.security.realm1.jmi1.Principal;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;
import org.openmdx.security.authentication1.jmi1.Password;
import org.openmdx.security.realm1.jmi1.Credential;

public abstract class AbstractSession
implements Runnable {
    public static final String PASSWORD_ENCODING_ALGORITHM = "MD5";
    protected final AbstractServer server;
    protected Socket socket;
    protected String username = null;
    protected String segmentName = null;

    public AbstractSession(Socket client, AbstractServer server) {
        this.socket = client;
        this.server = server;
    }

    public void stop() {
        if (this.socket != null) {
            try {
                this.socket.close();
                this.socket = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static PersistenceManager newPersistenceManager(PersistenceManagerFactory pmf, String username) {
        String principalName = username.substring(0, username.indexOf("@"));
        return pmf.getPersistenceManager(principalName, null);
    }

    protected boolean login(String username, String password) {
        try {
            if (username.indexOf("@") > 0) {
                Credential credential;
                this.segmentName = username.substring(username.indexOf("@") + 1);
                this.username = username;
                String principalName = username.substring(0, username.indexOf("@"));
                PersistenceManager rootPm = this.server.getPersistenceManagerFactory().getPersistenceManager("admin-Root", null);
                Principal principal = (Principal)rootPm.getObjectById((Object)new Path("xri://@openmdx*org.openmdx.security.realm1").getDescendant(new String[]{"provider", this.server.getProviderName(), "segment", "Root", "realm", "Default", "principal", principalName}));
                if (principal != null && (credential = principal.getCredential()) instanceof Password) {
                    boolean success = Utils.getPasswordDigest(password, PASSWORD_ENCODING_ALGORITHM).equals("{MD5}" + ((Password)credential).getPassword());
                    return success;
                }
                rootPm.close();
            }
        }
        catch (Exception e) {
            new ServiceException(e).log();
        }
        return false;
    }

    protected void logout() {
    }
}

