package org.opencrx.security.jpa3;

/**
 * <code>Segment$Slice</code> object hold the <code>Segment</code>'s multivalued attributes
 */
@SuppressWarnings("serial")
public class Segment$Slice implements java.io.Serializable {


  /**
   * Constructor
   */
  public Segment$Slice(
  ){
    // Implements Serializable
  }

  /**
   * Constructor
   */
  protected Segment$Slice(
    Segment object,
    int index
  ){
    this.openmdxjdoIdentity = object;
    this.openmdxjdoIndex = index;
  }

  /**
   * The slice's index
   */
  @SuppressWarnings("unused")
  private int openmdxjdoIndex;

  /**
   * The slice's owner
   */
  @SuppressWarnings("unused")
  private Segment openmdxjdoIdentity;

// ----------------------------------------------------------------------------
// Instance/SliceId
// ----------------------------------------------------------------------------
  /**
   * The slices' compound identity class
   */
  public static class SliceId implements java.io.Serializable {

    /**
     * The parent's object id
     */
    public java.lang.String openmdxjdoIdentity;

    /**
     * The slice's index
     */
    public int openmdxjdoIndex;

    /**
     * Test for equality.
     * <p>
     * This method is required by JPA.
     * @param that the object to be compared
     * @return <code>true</code> if the two ids refer to the same slice object
     */
    @Override
    public boolean equals(java.lang.Object that) {
      return this == that || (
        that instanceof SliceId &&
        this.openmdxjdoIndex == ((SliceId)that).openmdxjdoIndex &&
        (this.openmdxjdoIdentity == null ? ((SliceId)that).openmdxjdoIdentity == null : this.openmdxjdoIdentity.equals(((SliceId)that).openmdxjdoIdentity))
      );
    }

    /**
     * Calculate the slice id's hash code.
     * <p>
     * This method is should be overridden together with {@link #equals(java.lang.Object)}.
     * @return the slice id's hash code
     */
    @Override
    public int hashCode() {
      return this.openmdxjdoIndex + (this.openmdxjdoIdentity == null ? 0 : this.openmdxjdoIdentity.hashCode());
    }

    /**
     * Provide the slice id's string representation
     * @return the slice id's string representation
     */
    @Override
    public java.lang.String toString() {
      return new java.lang.StringBuilder().append(this.openmdxjdoIdentity).append('#').append(this.openmdxjdoIndex).toString();
    }

  }


}

