/*
 * Decompiled with CFR 0.152.
 */
package org.openbaton.nfvo.common.utils.schema;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.ValidationMessage;
import java.io.IOException;
import java.util.Set;
import org.openbaton.exceptions.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaValidator {
    private static Logger log = LoggerFactory.getLogger(SchemaValidator.class);

    private static JsonNode getJsonNodeFromStringContent(String content) throws BadRequestException, IOException {
        JsonNode node;
        ObjectMapper mapper = new ObjectMapper();
        try {
            node = mapper.readTree(content);
        }
        catch (JsonParseException e) {
            log.error(e.getMessage());
            throw new BadRequestException((Throwable)e);
        }
        return node;
    }

    private static JsonSchema getJsonSchemaFromStringContent(String schemaContent) {
        JsonSchemaFactory factory = new JsonSchemaFactory();
        return factory.getSchema(schemaContent);
    }

    public static Set<ValidationMessage> validateSchema(String jsonClassSchema, String jsonInstance) throws BadRequestException, IOException {
        JsonSchema finalSchema = SchemaValidator.getJsonSchemaFromStringContent(jsonClassSchema);
        JsonNode node = SchemaValidator.getJsonNodeFromStringContent(jsonInstance);
        return finalSchema.validate(node);
    }
}

