/*
 * Decompiled with CFR 0.152.
 */
package org.openbaton.nfvo.common.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import org.openbaton.catalogue.nfvo.Action;
import org.openbaton.catalogue.nfvo.messages.Interfaces.NFVMessage;
import org.openbaton.catalogue.nfvo.messages.OrVnfmErrorMessage;
import org.openbaton.catalogue.nfvo.messages.OrVnfmGenericMessage;
import org.openbaton.catalogue.nfvo.messages.OrVnfmGrantLifecycleOperationMessage;
import org.openbaton.catalogue.nfvo.messages.OrVnfmHealVNFRequestMessage;
import org.openbaton.catalogue.nfvo.messages.OrVnfmInstantiateMessage;
import org.openbaton.catalogue.nfvo.messages.OrVnfmLogMessage;
import org.openbaton.catalogue.nfvo.messages.OrVnfmScalingMessage;
import org.openbaton.catalogue.nfvo.messages.OrVnfmStartStopMessage;
import org.openbaton.catalogue.nfvo.messages.OrVnfmUpdateMessage;
import org.openbaton.catalogue.nfvo.viminstances.BaseVimInstance;
import org.openbaton.nfvo.common.configuration.NfvoGsonDeserializerVimInstance;
import org.openbaton.nfvo.common.configuration.NfvoGsonSerializerVimInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class VnfmGsonDeserializerNFVMessage
implements JsonDeserializer<NFVMessage> {
    private Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(BaseVimInstance.class, (Object)new NfvoGsonDeserializerVimInstance()).registerTypeAdapter(BaseVimInstance.class, (Object)new NfvoGsonSerializerVimInstance()).create();
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public NFVMessage deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        NFVMessage result;
        String action;
        switch (action = json.getAsJsonObject().get("action").getAsString()) {
            case "INSTANTIATE": {
                result = (NFVMessage)this.gson.fromJson(json, OrVnfmInstantiateMessage.class);
                break;
            }
            case "GRANT_OPERATION": {
                result = (NFVMessage)this.gson.fromJson(json, OrVnfmGrantLifecycleOperationMessage.class);
                break;
            }
            case "SCALING": {
                result = (NFVMessage)this.gson.fromJson(json, OrVnfmScalingMessage.class);
                break;
            }
            case "SCALE_OUT": {
                result = (NFVMessage)this.gson.fromJson(json, OrVnfmScalingMessage.class);
                break;
            }
            case "SCALE_IN": {
                result = (NFVMessage)this.gson.fromJson(json, OrVnfmScalingMessage.class);
                break;
            }
            case "HEAL": {
                result = (NFVMessage)this.gson.fromJson(json, OrVnfmHealVNFRequestMessage.class);
                break;
            }
            case "UPDATE": {
                result = (NFVMessage)this.gson.fromJson(json, OrVnfmUpdateMessage.class);
                break;
            }
            case "START": {
                result = (NFVMessage)this.gson.fromJson(json, OrVnfmStartStopMessage.class);
                break;
            }
            case "STOP": {
                result = (NFVMessage)this.gson.fromJson(json, OrVnfmStartStopMessage.class);
                break;
            }
            case "ERROR": {
                result = (NFVMessage)this.gson.fromJson(json, OrVnfmErrorMessage.class);
                break;
            }
            case "LOG_REQUEST": {
                result = (NFVMessage)this.gson.fromJson(json, OrVnfmLogMessage.class);
                break;
            }
            default: {
                result = (NFVMessage)this.gson.fromJson(json, OrVnfmGenericMessage.class);
            }
        }
        result.setAction(Action.valueOf((String)action));
        this.log.trace("Deserialized message is " + result);
        return result;
    }
}

