/*
 * Decompiled with CFR 0.152.
 */
package org.openbaton.nfvo.common.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.openbaton.catalogue.nfvo.viminstances.BaseVimInstance;
import org.openbaton.catalogue.nfvo.viminstances.DockerVimInstance;
import org.openbaton.catalogue.nfvo.viminstances.GenericVimInstance;
import org.openbaton.catalogue.nfvo.viminstances.OpenstackVimInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NfvoGsonSerializerVimInstance
implements JsonSerializer<BaseVimInstance> {
    private Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public JsonElement serialize(BaseVimInstance src, Type typeOfSrc, JsonSerializationContext context) {
        if (src instanceof OpenstackVimInstance) {
            return this.gson.toJsonTree((Object)src, OpenstackVimInstance.class);
        }
        if (src instanceof DockerVimInstance) {
            return this.gson.toJsonTree((Object)src, DockerVimInstance.class);
        }
        return this.gson.toJsonTree((Object)src, GenericVimInstance.class);
    }
}

