/*
 * Decompiled with CFR 0.152.
 */
package org.openbaton.nfvo.common.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import org.openbaton.catalogue.nfvo.viminstances.BaseVimInstance;
import org.openbaton.catalogue.nfvo.viminstances.GenericVimInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NfvoGsonDeserializerVimInstance
implements JsonDeserializer<BaseVimInstance> {
    private Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public BaseVimInstance deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        BaseVimInstance result;
        String type = json.getAsJsonObject().get("type").getAsString();
        try {
            String className = "org.openbaton.catalogue.nfvo.viminstances." + type.substring(0, 1).toUpperCase() + type.substring(1) + "VimInstance";
            this.log.debug("Looking for class " + className);
            Class<?> clz = Class.forName(className);
            result = (BaseVimInstance)this.gson.fromJson(json, clz);
        }
        catch (ClassNotFoundException e) {
            result = (BaseVimInstance)this.gson.fromJson(json, GenericVimInstance.class);
        }
        this.log.trace("Deserialized message is " + result);
        return result;
    }
}

