/*
 * Decompiled with CFR 0.152.
 */
package org.openbaton.nfvo.common.utils.rabbit;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.openbaton.exceptions.WrongStatusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope
public class RabbitManager {
    private static Logger log = LoggerFactory.getLogger(RabbitManager.class);
    private static Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static List<String> getQueues(String brokerIp, String username, String password, String virtualHost, int managementPort) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        String encoding = Base64.encodeBase64String((byte[])(username + ":" + password).getBytes());
        HttpGet httpGet = new HttpGet("http://" + brokerIp + ":" + managementPort + "/api/queues/" + virtualHost.replace("/", "%2f"));
        httpGet.setHeader("Authorization", "Basic " + encoding);
        log.trace("executing request " + httpGet.getRequestLine());
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
        HttpEntity entity = response.getEntity();
        InputStreamReader inputStreamReader = new InputStreamReader(entity.getContent());
        JsonArray array = (JsonArray)gson.fromJson((Reader)inputStreamReader, JsonArray.class);
        if (array != null) {
            for (JsonElement queueJson : array) {
                String name = queueJson.getAsJsonObject().get("name").getAsString();
                result.add(name);
                log.trace("found queue: " + name);
            }
        }
        log.trace("found queues: " + ((Object)result).toString());
        return result;
    }

    public static void createRabbitMqUser(String rabbitUsername, String rabbitPassword, String brokerIp, String managementPort, String newUserName, String newUserPwd, String vHost) throws IOException, WrongStatusException {
        String uri = "http://" + brokerIp + ":" + managementPort + "/api/users/" + newUserName;
        Gson gson = new Gson();
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("password", newUserPwd);
        map.put("tags", "administrator");
        map.put("vhost", vHost);
        String pass = gson.toJson(map);
        log.trace("Body is: " + pass);
        StringEntity requestEntity = new StringEntity(pass, ContentType.APPLICATION_JSON);
        HttpPut put = new HttpPut(uri);
        String authStr = rabbitUsername + ":" + rabbitPassword;
        String encoding = Base64.encodeBase64String((byte[])authStr.getBytes());
        put.setHeader("Authorization", "Basic " + encoding);
        put.setHeader((Header)new BasicHeader("Accept", "application/json"));
        put.setHeader((Header)new BasicHeader("Content-type", "application/json"));
        put.setEntity((HttpEntity)requestEntity);
        log.trace("Executing request: " + put.getMethod() + " on " + uri);
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)put);
        log.trace(String.valueOf("Status: " + response.getStatusLine().getStatusCode()));
        log.trace("Received status: " + response.getStatusLine().getStatusCode());
        if (response.getStatusLine().getStatusCode() != 204 && response.getStatusLine().getStatusCode() != 201) {
            httpclient.close();
            throw new WrongStatusException("Error creating RabbitMQ user " + newUserName + ": " + response.getStatusLine());
        }
        httpclient.close();
    }

    public static void setRabbitMqUserPermissions(String rabbitUsername, String rabbitPassword, String brokerIp, String managementPort, String username, String vHost, String configurePermission, String writePermission, String readPermission) throws IOException, WrongStatusException {
        Gson gson = new Gson();
        if (configurePermission == null) {
            configurePermission = "";
        }
        if (writePermission == null) {
            writePermission = "";
        }
        if (readPermission == null) {
            readPermission = "";
        }
        String uri = "http://" + brokerIp + ":" + managementPort + "/api/permissions/" + vHost.replace("/", "%2f") + "/" + username;
        HttpPut put = new HttpPut(uri);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("configure", configurePermission);
        map.put("write", writePermission);
        map.put("read", readPermission);
        String stringEntity = gson.toJson(map);
        log.trace("Body is: " + stringEntity);
        String authStr = rabbitUsername + ":" + rabbitPassword;
        String encoding = Base64.encodeBase64String((byte[])authStr.getBytes());
        put.setHeader("Authorization", "Basic " + encoding);
        put.setHeader((Header)new BasicHeader("Accept", "application/json"));
        put.setHeader((Header)new BasicHeader("Content-type", "application/json"));
        put.setEntity((HttpEntity)new StringEntity(stringEntity, ContentType.APPLICATION_JSON));
        CloseableHttpClient httpclient = HttpClients.createDefault();
        log.trace("Executing request: " + put.getMethod() + " on " + uri);
        httpclient.execute((HttpUriRequest)put);
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)put);
        log.trace(String.valueOf("Status: " + response.getStatusLine().getStatusCode()));
        if (response.getStatusLine().getStatusCode() != 204) {
            httpclient.close();
            throw new WrongStatusException("Error setting permissions of RabbitMQ user" + username + ": " + response.getStatusLine());
        }
        httpclient.close();
    }

    public static void removeRabbitMqUser(String rabbitUsername, String rabbitPassword, String brokerIp, String managementPort, String userToRemove) throws IOException, WrongStatusException {
        String uri = "http://" + brokerIp + ":" + managementPort + "/api/users/" + userToRemove;
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpDelete delete = new HttpDelete(uri);
        String authStr = rabbitUsername + ":" + rabbitPassword;
        String encoding = Base64.encodeBase64String((byte[])authStr.getBytes());
        delete.setHeader("Authorization", "Basic " + encoding);
        delete.setHeader((Header)new BasicHeader("Accept", "application/json"));
        log.trace("Executing request: " + delete.getMethod() + " on " + uri);
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)delete);
        log.trace(String.valueOf("Status: " + response.getStatusLine().getStatusCode()));
        if (response.getStatusLine().getStatusCode() != 204) {
            throw new WrongStatusException("Error removing RabbitMQ user " + userToRemove + ": " + response.getStatusLine());
        }
        if (response.getStatusLine().getStatusCode() == 404) {
            log.warn("User not found... the database is not consistent...");
            return;
        }
    }

    public static void createQueue(String brokerIp, int port, String rabbitUsername, String rabbitPassword, String virtualHost, String queue, String exchange) throws IOException, TimeoutException {
        ConnectionFactory factory = RabbitManager.getConnectionFactory(brokerIp, port, rabbitUsername, rabbitPassword, virtualHost);
        Connection connection = factory.newConnection();
        Channel channel = connection.createChannel();
        channel.exchangeDeclare(exchange, "topic", true);
        channel.queueDeclare(queue, false, false, true, null);
        channel.queueBind(queue, exchange, queue);
        channel.basicQos(1);
        channel.close();
        connection.close();
    }

    private static ConnectionFactory getConnectionFactory(String brokerIp, int port, String rabbitUsername, String rabbitPassword, String virtualHost) {
        ConnectionFactory factory = new ConnectionFactory();
        factory.setHost(brokerIp);
        factory.setPort(port);
        factory.setUsername(rabbitUsername);
        factory.setPassword(rabbitPassword);
        factory.setVirtualHost(virtualHost);
        return factory;
    }

    public static void main(String[] args) throws IOException {
        System.out.println(RabbitManager.getQueues("localhost", "admin", "openbaton", "/", 5672));
    }
}

