/*
 * Decompiled with CFR 0.152.
 */
package org.openbaton.nfvo.common.utils.key;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.openbaton.exceptions.BadFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyHelper {
    private static final Logger log = LoggerFactory.getLogger(KeyHelper.class);
    public static String DESEDE_ALGORITHM = "DESede";
    private static String AES_ALGORITHM = "AES";
    private static final char[] ALPHANUMERIC = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();

    public static String genKey() {
        SecureRandom secureRandom = new SecureRandom();
        StringBuilder stringBuilder = new StringBuilder(16);
        for (int i = 0; i < 16; ++i) {
            stringBuilder.append(ALPHANUMERIC[secureRandom.nextInt(ALPHANUMERIC.length)]);
        }
        return stringBuilder.toString();
    }

    private static Key restoreKey(byte[] keyBytes) {
        return new SecretKeySpec(keyBytes, AES_ALGORITHM);
    }

    private static byte[] encrypt(byte[] bytes, Key key) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchPaddingException, NoSuchAlgorithmException {
        Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
        cipher.init(1, key);
        return cipher.doFinal(bytes);
    }

    private static byte[] encrypt(String text, Key key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        return KeyHelper.encrypt(text.getBytes(StandardCharsets.UTF_8), key);
    }

    public static String encryptNew(String valueToEnc, String keyValue) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Key key = KeyHelper.generateKey(keyValue.getBytes(StandardCharsets.UTF_8));
        Cipher c = Cipher.getInstance(AES_ALGORITHM);
        c.init(1, key);
        byte[] encValue = c.doFinal(valueToEnc.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(encValue);
    }

    public static String decryptNew(String encryptedValue, String keyValue) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IOException, BadPaddingException, IllegalBlockSizeException {
        Key key = KeyHelper.generateKey(keyValue.getBytes(StandardCharsets.UTF_8));
        Cipher c = Cipher.getInstance(AES_ALGORITHM);
        c.init(2, key);
        byte[] decodedValue = org.apache.commons.codec.binary.Base64.decodeBase64((String)encryptedValue);
        byte[] decValue = c.doFinal(decodedValue);
        return new String(decValue);
    }

    private static Key generateKey(byte[] keyValue) {
        return new SecretKeySpec(keyValue, AES_ALGORITHM);
    }

    private static String decrypt(byte[] bytes, Key key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
        cipher.init(2, key);
        return new String(cipher.doFinal(bytes), StandardCharsets.UTF_8);
    }

    public static String encodePublicKey(PublicKey publicKey, String user) throws IOException {
        RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
        ByteArrayOutputStream byteOs = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(byteOs);
        dos.writeInt("ssh-rsa".getBytes().length);
        dos.write("ssh-rsa".getBytes());
        dos.writeInt(rsaPublicKey.getPublicExponent().toByteArray().length);
        dos.write(rsaPublicKey.getPublicExponent().toByteArray());
        dos.writeInt(rsaPublicKey.getModulus().toByteArray().length);
        dos.write(rsaPublicKey.getModulus().toByteArray());
        String publicKeyEncoded = new String(org.apache.commons.codec.binary.Base64.encodeBase64((byte[])byteOs.toByteArray()));
        return "ssh-rsa " + publicKeyEncoded + " " + user;
    }

    public static String calculateFingerprint(byte[] publicKey) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA1");
        String start = Hex.encodeHexString((byte[])digest.digest(publicKey));
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < start.length(); ++i) {
            if (i != 0 && i % 2 == 0) {
                res.append(":");
            }
            res.append(start.charAt(i));
        }
        log.debug(res.toString());
        return res.toString();
    }

    public static byte[] parsePublicKey(String decodedKey) throws UnsupportedEncodingException, BadFormatException {
        String[] decodedKeyArray = decodedKey.split(" ");
        if (decodedKeyArray.length <= 1) {
            throw new BadFormatException("The public key must have the following format: ssh-rsa [the_public_key]");
        }
        decodedKey = decodedKeyArray[1];
        return Base64.getDecoder().decode(decodedKey);
    }

    public static String parsePrivateKey(byte[] encodedKey) {
        StringBuilder sb = new StringBuilder();
        sb.append("-----BEGIN RSA PRIVATE KEY-----\n");
        sb.append(new String(Base64.getEncoder().encode(encodedKey)).replaceAll("(.{72})", "$1\n"));
        sb.append("\n");
        sb.append("-----END RSA PRIVATE KEY-----\n");
        return sb.toString();
    }

    private String encodePublicKey(RSAPublicKey key, String keyname) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] sshrsa = new byte[]{0, 0, 0, 7, 115, 115, 104, 45, 114, 115, 97};
        out.write(sshrsa);
        BigInteger e = key.getPublicExponent();
        byte[] data = e.toByteArray();
        this.encodeUInt32(data.length, out);
        out.write(data);
        BigInteger m = key.getModulus();
        data = m.toByteArray();
        this.encodeUInt32(data.length, out);
        out.write(data);
        return "ssh-rsa " + Base64.getEncoder().encodeToString(out.toByteArray()) + " " + keyname + "@openbaton";
    }

    private void encodeUInt32(int value, OutputStream out) throws IOException {
        byte[] tmp = new byte[]{(byte)(value >>> 24 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        out.write(tmp);
    }

    public static KeyPair generateRSAKey() throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048);
        return keyGen.genKeyPair();
    }

    public static void main(String[] args) throws Exception {
        String key = KeyHelper.genKey();
        System.out.println("Key is: " + key);
        String message = "long message to be encrypted";
        System.out.println("Value clean: " + message);
        String res = KeyHelper.encryptNew(message, key);
        System.out.println("Value encrypted: " + res);
        message = KeyHelper.decryptNew(res, key);
        System.out.println("Value cleat: " + message);
    }
}

