/*
 * Decompiled with CFR 0.152.
 */
package org.openbaton.nfvo.common.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import org.openbaton.catalogue.nfvo.networks.BaseNetwork;
import org.openbaton.catalogue.nfvo.networks.DockerNetwork;
import org.openbaton.catalogue.nfvo.networks.Network;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NfvoGsonDeserializerNetwork
implements JsonDeserializer<BaseNetwork> {
    private Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public BaseNetwork deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.getAsJsonObject().has("subnet")) {
            return (BaseNetwork)this.gson.fromJson(json, DockerNetwork.class);
        }
        if (json.getAsJsonObject().has("subnets")) {
            return (BaseNetwork)this.gson.fromJson(json, Network.class);
        }
        return (BaseNetwork)this.gson.fromJson(json, BaseNetwork.class);
    }
}

