/*
 * Decompiled with CFR 0.152.
 */
package org.openbaton.nfvo.common.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import org.openbaton.catalogue.nfvo.Action;
import org.openbaton.catalogue.nfvo.messages.Interfaces.NFVMessage;
import org.openbaton.catalogue.nfvo.messages.VnfmOrAllocateResourcesMessage;
import org.openbaton.catalogue.nfvo.messages.VnfmOrErrorMessage;
import org.openbaton.catalogue.nfvo.messages.VnfmOrGenericMessage;
import org.openbaton.catalogue.nfvo.messages.VnfmOrHealedMessage;
import org.openbaton.catalogue.nfvo.messages.VnfmOrInstantiateMessage;
import org.openbaton.catalogue.nfvo.messages.VnfmOrLogMessage;
import org.openbaton.catalogue.nfvo.messages.VnfmOrScaledMessage;
import org.openbaton.catalogue.nfvo.messages.VnfmOrScalingMessage;
import org.openbaton.catalogue.nfvo.messages.VnfmOrStartStopMessage;
import org.openbaton.catalogue.nfvo.viminstances.BaseVimInstance;
import org.openbaton.nfvo.common.configuration.NfvoGsonDeserializerVimInstance;
import org.openbaton.nfvo.common.configuration.NfvoGsonSerializerVimInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NfvoGsonDeserializerNFVMessage
implements JsonDeserializer<NFVMessage> {
    private Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(BaseVimInstance.class, (Object)new NfvoGsonDeserializerVimInstance()).registerTypeAdapter(BaseVimInstance.class, (Object)new NfvoGsonSerializerVimInstance()).create();
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public NFVMessage deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        NFVMessage result;
        String action;
        switch (action = json.getAsJsonObject().get("action").getAsString()) {
            case "ALLOCATE_RESOURCES": {
                result = (NFVMessage)this.gson.fromJson(json, VnfmOrAllocateResourcesMessage.class);
                break;
            }
            case "ERROR": {
                result = (NFVMessage)this.gson.fromJson(json, VnfmOrErrorMessage.class);
                break;
            }
            case "INSTANTIATE": {
                this.log.trace("gson is: " + this.gson);
                result = (NFVMessage)this.gson.fromJson(json, VnfmOrInstantiateMessage.class);
                break;
            }
            case "SCALED": {
                result = (NFVMessage)this.gson.fromJson(json, VnfmOrScaledMessage.class);
                break;
            }
            case "SCALING": {
                result = (NFVMessage)this.gson.fromJson(json, VnfmOrScalingMessage.class);
                break;
            }
            case "HEAL": {
                result = (NFVMessage)this.gson.fromJson(json, VnfmOrHealedMessage.class);
                break;
            }
            case "START": {
                result = (NFVMessage)this.gson.fromJson(json, VnfmOrStartStopMessage.class);
                break;
            }
            case "STOP": {
                result = (NFVMessage)this.gson.fromJson(json, VnfmOrStartStopMessage.class);
                break;
            }
            case "LOG_REQUEST": {
                result = (NFVMessage)this.gson.fromJson(json, VnfmOrLogMessage.class);
                break;
            }
            default: {
                result = (NFVMessage)this.gson.fromJson(json, VnfmOrGenericMessage.class);
            }
        }
        result.setAction(Action.valueOf((String)action));
        this.log.trace("Deserialized message is " + result);
        return result;
    }
}

