/*
 * Decompiled with CFR 0.152.
 */
package org.openbaton.nfvo.common.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import org.openbaton.catalogue.nfvo.images.BaseNfvImage;
import org.openbaton.catalogue.nfvo.images.DockerImage;
import org.openbaton.catalogue.nfvo.images.NFVImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NfvoGsonDeserializerImage
implements JsonDeserializer<BaseNfvImage> {
    private Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public BaseNfvImage deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.getAsJsonObject().has("tags")) {
            return (BaseNfvImage)this.gson.fromJson(json, DockerImage.class);
        }
        if (json.getAsJsonObject().has("diskFormat")) {
            return (BaseNfvImage)this.gson.fromJson(json, NFVImage.class);
        }
        return (BaseNfvImage)this.gson.fromJson(json, BaseNfvImage.class);
    }
}

