/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.pattern.trigger;

import com.google.protobuf.MessageOrBuilder;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.type.processing.TimestampProcessor;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.pattern.trigger.AbstractTrigger;
import org.openbase.jul.pattern.trigger.Trigger;
import org.openbase.type.domotic.state.ActivationStateType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\f\u0018\u0000 #2\u00020\u0001:\u0002\"#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0001J\b\u0010\u0014\u001a\u00020\u000fH\u0002J\b\u0010\u0015\u001a\u00020\u0005H\u0002J\b\u0010\u0016\u001a\u00020\u0005H\u0002J\b\u0010\u001d\u001a\u00020\u000fH\u0016J\b\u0010\u001e\u001a\u00020\u000fH\u0016J\b\u0010\u001f\u001a\u00020\u0005H\u0016J\u0006\u0010 \u001a\u00020\u000fJ\b\u0010!\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006$"}, d2={"Lorg/openbase/jul/pattern/trigger/TriggerPool;", "Lorg/openbase/jul/pattern/trigger/AbstractTrigger;", "<init>", "()V", "active", "", "triggerListAND", "", "Lorg/openbase/jul/pattern/trigger/Trigger;", "triggerListOR", "triggerAndObserver", "Lorg/openbase/jul/pattern/Observer;", "Lorg/openbase/type/domotic/state/ActivationStateType$ActivationState;", "triggerOrObserver", "addTrigger", "", "trigger", "triggerAggregation", "Lorg/openbase/jul/pattern/trigger/TriggerPool$TriggerAggregation;", "removeTrigger", "verifyCondition", "verifyAndCondition", "verifyOrCondition", "size", "", "getSize", "()I", "isEmpty", "()Z", "activate", "deactivate", "isActive", "forceNotification", "shutdown", "TriggerAggregation", "Companion", "jul.pattern.trigger"})
public final class TriggerPool
extends AbstractTrigger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean active = false;
    @NotNull
    private final List<Trigger> triggerListAND = new ArrayList();
    @NotNull
    private final List<Trigger> triggerListOR = new ArrayList();
    @NotNull
    private final Observer<Trigger, ActivationStateType.ActivationState> triggerAndObserver = (arg_0, arg_1) -> TriggerPool._init_$lambda$0(this, arg_0, arg_1);
    @NotNull
    private final Observer<Trigger, ActivationStateType.ActivationState> triggerOrObserver = (arg_0, arg_1) -> TriggerPool._init_$lambda$1(this, arg_0, arg_1);
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTrigger.class);

    public TriggerPool() {
        super(null, 1, null);
        try {
            ActivationStateType.ActivationState activationState = ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.UNKNOWN).build();
            Intrinsics.checkNotNullExpressionValue((Object)activationState, (String)"build(...)");
            MessageOrBuilder messageOrBuilder = TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)((MessageOrBuilder)activationState));
            Intrinsics.checkNotNullExpressionValue((Object)messageOrBuilder, (String)"updateTimestampWithCurrentTime(...)");
            this.notifyChange((ActivationStateType.ActivationState)messageOrBuilder);
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException("Could not set initial state", (Throwable)ex);
        }
    }

    public final void addTrigger(@NotNull Trigger trigger, @NotNull TriggerAggregation triggerAggregation) throws CouldNotPerformException {
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        Intrinsics.checkNotNullParameter((Object)((Object)triggerAggregation), (String)"triggerAggregation");
        boolean bl = triggerAggregation == TriggerAggregation.AND ? this.triggerListAND.add(trigger) : this.triggerListOR.add(trigger);
        if (this.active) {
            TriggerAggregation triggerAggregation2 = triggerAggregation;
            switch (WhenMappings.$EnumSwitchMapping$0[triggerAggregation2.ordinal()]) {
                case 1: {
                    trigger.addObserver(this.triggerOrObserver);
                    break;
                }
                case 2: {
                    trigger.addObserver(this.triggerAndObserver);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            try {
                trigger.activate();
            }
            catch (InterruptedException ex) {
                throw new CouldNotPerformException("Could not activate Trigger.", (Throwable)ex);
            }
            try {
                this.verifyCondition();
            }
            catch (NotAvailableException notAvailableException) {
                // empty catch block
            }
        }
    }

    public final void removeTrigger(@NotNull AbstractTrigger trigger) {
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        if (this.triggerListAND.contains(trigger)) {
            trigger.removeObserver(this.triggerAndObserver);
            this.triggerListAND.remove(trigger);
        } else if (this.triggerListOR.contains(trigger)) {
            trigger.removeObserver(this.triggerOrObserver);
            this.triggerListOR.remove(trigger);
        }
    }

    private final void verifyCondition() throws CouldNotPerformException {
        if (this.verifyOrCondition() || this.verifyAndCondition()) {
            if (this.getActivationState().getValue() != ActivationStateType.ActivationState.State.ACTIVE) {
                ActivationStateType.ActivationState activationState = ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.ACTIVE).build();
                Intrinsics.checkNotNullExpressionValue((Object)activationState, (String)"build(...)");
                MessageOrBuilder messageOrBuilder = TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)((MessageOrBuilder)activationState));
                Intrinsics.checkNotNullExpressionValue((Object)messageOrBuilder, (String)"updateTimestampWithCurrentTime(...)");
                this.notifyChange((ActivationStateType.ActivationState)messageOrBuilder);
            }
        } else if (this.getActivationState().getValue() != ActivationStateType.ActivationState.State.INACTIVE) {
            ActivationStateType.ActivationState activationState = ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.INACTIVE).build();
            Intrinsics.checkNotNullExpressionValue((Object)activationState, (String)"build(...)");
            MessageOrBuilder messageOrBuilder = TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)((MessageOrBuilder)activationState));
            Intrinsics.checkNotNullExpressionValue((Object)messageOrBuilder, (String)"updateTimestampWithCurrentTime(...)");
            this.notifyChange((ActivationStateType.ActivationState)messageOrBuilder);
        }
    }

    private final boolean verifyAndCondition() throws CouldNotPerformException {
        return this.triggerListAND.isEmpty() ? false : this.triggerListAND.stream().allMatch(arg_0 -> TriggerPool.verifyAndCondition$lambda$3(TriggerPool::verifyAndCondition$lambda$2, arg_0));
    }

    private final boolean verifyOrCondition() throws CouldNotPerformException {
        return this.triggerListOR.stream().anyMatch(arg_0 -> TriggerPool.verifyOrCondition$lambda$5(TriggerPool::verifyOrCondition$lambda$4, arg_0));
    }

    public final int getSize() {
        return this.triggerListAND.size() + this.triggerListOR.size();
    }

    public final boolean isEmpty() {
        return this.triggerListAND.isEmpty() && this.triggerListOR.isEmpty();
    }

    public void activate() throws CouldNotPerformException, InterruptedException {
        for (Trigger trigger : this.triggerListAND) {
            trigger.addObserver(this.triggerAndObserver);
            trigger.activate();
        }
        for (Trigger trigger : this.triggerListOR) {
            trigger.addObserver(this.triggerOrObserver);
            trigger.activate();
        }
        this.verifyCondition();
        this.active = true;
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        for (Trigger trigger : this.triggerListAND) {
            trigger.removeObserver(this.triggerAndObserver);
            trigger.deactivate();
        }
        for (Trigger trigger : this.triggerListOR) {
            trigger.removeObserver(this.triggerOrObserver);
            trigger.deactivate();
        }
        ActivationStateType.ActivationState activationState = ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.UNKNOWN).build();
        Intrinsics.checkNotNullExpressionValue((Object)activationState, (String)"build(...)");
        MessageOrBuilder messageOrBuilder = TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)((MessageOrBuilder)activationState));
        Intrinsics.checkNotNullExpressionValue((Object)messageOrBuilder, (String)"updateTimestampWithCurrentTime(...)");
        this.notifyChange((ActivationStateType.ActivationState)messageOrBuilder);
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public final void forceNotification() throws CouldNotPerformException {
        try {
            if (this.verifyOrCondition() || this.verifyAndCondition()) {
                ActivationStateType.ActivationState activationState = ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.ACTIVE).build();
                Intrinsics.checkNotNullExpressionValue((Object)activationState, (String)"build(...)");
                MessageOrBuilder messageOrBuilder = TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)((MessageOrBuilder)activationState));
                Intrinsics.checkNotNullExpressionValue((Object)messageOrBuilder, (String)"updateTimestampWithCurrentTime(...)");
                this.notifyChange((ActivationStateType.ActivationState)messageOrBuilder);
            } else {
                ActivationStateType.ActivationState activationState = ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.INACTIVE).build();
                Intrinsics.checkNotNullExpressionValue((Object)activationState, (String)"build(...)");
                MessageOrBuilder messageOrBuilder = TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)((MessageOrBuilder)activationState));
                Intrinsics.checkNotNullExpressionValue((Object)messageOrBuilder, (String)"updateTimestampWithCurrentTime(...)");
                this.notifyChange((ActivationStateType.ActivationState)messageOrBuilder);
            }
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not force notify trigger pool!", (Throwable)ex);
        }
    }

    @Override
    public void shutdown() {
        try {
            this.deactivate();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((String)("Could not shutdown " + this), (Throwable)ex, (Logger)LoggerFactory.getLogger(this.getClass()));
        }
        super.shutdown();
    }

    private static final void _init_$lambda$0(TriggerPool this$0, Trigger source, ActivationStateType.ActivationState data) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.verifyCondition();
    }

    private static final void _init_$lambda$1(TriggerPool this$0, Trigger source, ActivationStateType.ActivationState data) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.verifyCondition();
    }

    private static final boolean verifyAndCondition$lambda$2(Trigger trigger) {
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        try {
            return trigger.getActivationState().getValue() == ActivationStateType.ActivationState.State.ACTIVE;
        }
        catch (NotAvailableException exception) {
            return false;
        }
    }

    private static final boolean verifyAndCondition$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean verifyOrCondition$lambda$4(Trigger trigger) {
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        try {
            return trigger.getActivationState().getValue() == ActivationStateType.ActivationState.State.ACTIVE;
        }
        catch (NotAvailableException exception) {
            return false;
        }
    }

    private static final boolean verifyOrCondition$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/openbase/jul/pattern/trigger/TriggerPool$Companion;", "", "<init>", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "jul.pattern.trigger"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/openbase/jul/pattern/trigger/TriggerPool$TriggerAggregation;", "", "<init>", "(Ljava/lang/String;I)V", "AND", "OR", "jul.pattern.trigger"})
    public static final class TriggerAggregation
    extends Enum<TriggerAggregation> {
        public static final /* enum */ TriggerAggregation AND = new TriggerAggregation();
        public static final /* enum */ TriggerAggregation OR = new TriggerAggregation();
        private static final /* synthetic */ TriggerAggregation[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TriggerAggregation[] values() {
            return (TriggerAggregation[])$VALUES.clone();
        }

        public static TriggerAggregation valueOf(String value) {
            return Enum.valueOf(TriggerAggregation.class, value);
        }

        @NotNull
        public static EnumEntries<TriggerAggregation> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = triggerAggregationArray = new TriggerAggregation[]{TriggerAggregation.AND, TriggerAggregation.OR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TriggerAggregation.values().length];
            try {
                nArray[TriggerAggregation.OR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TriggerAggregation.AND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

