/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.protobuf.processing;

import com.google.protobuf.GeneratedMessage;
import java.lang.reflect.InvocationTargetException;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.extension.protobuf.processing.MessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericMessageProcessor<M extends GeneratedMessage>
implements MessageProcessor<GeneratedMessage, M> {
    private static final String NEW_BUILDER_METHOD_NAME = "newBuilder";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private GeneratedMessage.Builder builder;
    private final Class<M> dataClass;

    public GenericMessageProcessor(Class<M> dataClass) throws InitializationException {
        this.dataClass = dataClass;
        try {
            this.builder = (GeneratedMessage.Builder)dataClass.getMethod(NEW_BUILDER_METHOD_NAME, new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new InitializationException((Object)this, (Throwable)new CouldNotPerformException("Could not create builder from dataClass[" + dataClass.getSimpleName() + "]!", (Throwable)ex));
        }
    }

    public M process(GeneratedMessage input) throws CouldNotPerformException, InterruptedException {
        if (this.dataClass.isInstance(input)) {
            return (M)input;
        }
        this.builder.clear();
        this.builder.getDescriptorForType().getFields().stream().forEach(fieldDescriptor -> input.getAllFields().keySet().stream().filter(inputFieldDescriptor -> fieldDescriptor.getType().equals((Object)inputFieldDescriptor.getType()) && fieldDescriptor.getName().equals(inputFieldDescriptor.getName())).forEach(inputFieldDescriptor -> this.builder.setField(fieldDescriptor, input.getField(inputFieldDescriptor))));
        return (M)((GeneratedMessage)this.builder.build());
    }
}

