/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.protobuf.container.transformer;

import com.google.protobuf.GeneratedMessage;
import java.lang.reflect.InvocationTargetException;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.extension.protobuf.container.MessageContainer;
import org.openbase.jul.extension.protobuf.processing.ProtoBufFileProcessor;

public abstract class MessageTransformer<T extends MessageContainer<M>, M extends GeneratedMessage, MB extends GeneratedMessage.Builder<MB>>
implements ProtoBufFileProcessor.TypeToMessageTransformer<T, M, MB> {
    private final Class<M> messageClass;

    public MessageTransformer(Class<M> messageClass) {
        this.messageClass = messageClass;
    }

    @Override
    public M transform(T type) {
        return type.getMessage();
    }

    @Override
    public MB newBuilderForType() throws CouldNotPerformException {
        try {
            Object invoke = this.messageClass.getMethod("newBuilder", new Class[0]).invoke(null, new Object[0]);
            return (MB)((GeneratedMessage.Builder)invoke);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException ex) {
            throw new CouldNotPerformException("Coult not generate builder out of message class!", (Throwable)ex);
        }
    }

    public Class<M> getMessageClass() {
        return this.messageClass;
    }
}

