/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import java.util.HashMap;
import java.util.Map;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.processing.StringProcessor;
import org.openbase.jul.processing.VariableProvider;

public class ProtobufVariableProvider
implements VariableProvider {
    public static final String NAME_SUFIX = "VariableProvider";
    private final GeneratedMessage message;

    public ProtobufVariableProvider(GeneratedMessage message) {
        this.message = message;
    }

    public String getName() {
        return this.message.getDescriptorForType().getName() + NAME_SUFIX;
    }

    public String getValue(String variable) throws NotAvailableException {
        for (Map.Entry fieldEntry : this.message.getAllFields().entrySet()) {
            String key = StringProcessor.transformToUpperCase((String)((Descriptors.FieldDescriptor)fieldEntry.getKey()).getName());
            if (!key.equals(variable) && !(StringProcessor.transformToUpperCase((String)this.message.getClass().getSimpleName()) + "/" + key).equals(variable) || fieldEntry.getValue().toString().isEmpty()) continue;
            return fieldEntry.getValue().toString();
        }
        throw new NotAvailableException("Value for Variable[" + variable + "]");
    }

    public Map<String, String> getValues(String variableContains) throws NotAvailableException {
        HashMap<String, String> variableSelection = new HashMap<String, String>();
        for (Map.Entry fieldEntry : this.message.getAllFields().entrySet()) {
            String key = StringProcessor.transformToUpperCase((String)((Descriptors.FieldDescriptor)fieldEntry.getKey()).getName());
            if (!key.contains(variableContains) && !(StringProcessor.transformToUpperCase((String)this.message.getClass().getSimpleName()) + "/" + key).contains(variableContains) || fieldEntry.getValue().toString().isEmpty()) continue;
            variableSelection.put(key, fieldEntry.getValue().toString());
        }
        if (variableSelection.isEmpty()) {
            throw new NotAvailableException("No values found because no protobuf fields are matching [" + variableContains + "]!");
        }
        return variableSelection;
    }
}

