/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.pattern.AbstractObservable;
import org.openbase.jul.pattern.provider.DataProvider;

public class MessageObservable<M extends Message>
extends AbstractObservable<M> {
    public static final String TIMESTAMP_MESSAGE_NAME = "Timestamp";
    public static final String RESOURCE_ALLOCATION_FIELD = "resource_allocation";
    private final DataProvider<M> dataProvider;

    public MessageObservable(DataProvider<M> source) {
        super(source);
        this.dataProvider = source;
        this.setHashGenerator(value -> this.removeTimestamps(value.toBuilder()).build().hashCode());
    }

    public void waitForValue(long timeout, TimeUnit timeUnit) throws CouldNotPerformException, InterruptedException {
        this.dataProvider.waitForData();
    }

    public M getValue() throws NotAvailableException {
        return (M)((Message)this.dataProvider.getData());
    }

    public boolean isValueAvailable() {
        return this.dataProvider.isDataAvailable();
    }

    public Future<M> getValueFuture() {
        return this.dataProvider.getDataFuture();
    }

    public Message.Builder removeTimestamps(Message.Builder builder) {
        Descriptors.Descriptor descriptorForType = builder.getDescriptorForType();
        for (Descriptors.FieldDescriptor field : descriptorForType.getFields()) {
            if (field.isRepeated() || field.getType() != Descriptors.FieldDescriptor.Type.MESSAGE || field.getName().equals(RESOURCE_ALLOCATION_FIELD)) continue;
            if (field.getMessageType().getName().equals(TIMESTAMP_MESSAGE_NAME)) {
                builder.clearField(field);
                continue;
            }
            this.removeTimestamps(builder.getFieldBuilder(field));
        }
        return builder;
    }
}

