/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.protobuf;

import com.google.protobuf.GeneratedMessage;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jps.preset.JPDebugMode;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.VerificationFailedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.protobuf.IdGenerator;
import org.openbase.jul.extension.protobuf.container.MessageContainer;
import org.openbase.jul.iface.Identifiable;
import org.openbase.jul.pattern.ObservableImpl;
import org.openbase.jul.pattern.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentifiableMessage<KEY, M extends GeneratedMessage, MB extends GeneratedMessage.Builder<MB>>
implements Identifiable<KEY>,
MessageContainer<M> {
    protected static final Logger logger = LoggerFactory.getLogger(IdentifiableMessage.class);
    private static boolean debugMode;
    private M internalMessage;
    private ObservableImpl<IdentifiableMessage<KEY, M, MB>> observable;

    public IdentifiableMessage(IdentifiableMessage<KEY, M, MB> identifiableMessage) throws InstantiationException {
        this(identifiableMessage.getMessage());
    }

    public IdentifiableMessage(M message, IdGenerator<KEY, M> idGenerator) throws InstantiationException {
        try {
            if (idGenerator == null) {
                throw new NotAvailableException("idGenerator");
            }
            if (message == null) {
                throw new NotAvailableException("message");
            }
            this.internalMessage = message;
            this.observable = new ObservableImpl();
            this.setupId(idGenerator);
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public IdentifiableMessage(M message) throws InstantiationException {
        try {
            if (message == null) {
                throw new NotAvailableException("message");
            }
            this.internalMessage = message;
            if (!this.verifyId()) {
                throw new InvalidStateException("message does not contain Field[id]");
            }
            this.observable = new ObservableImpl();
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public KEY getId() throws NotAvailableException {
        try {
            if (this.internalMessage == null) {
                throw new NotAvailableException("messageOrBuilder");
            }
            if (this.internalMessage.getDescriptorForType().findFieldByName("id") == null) {
                throw new VerificationFailedException("Given message has no id field!");
            }
            if (!this.internalMessage.hasField(this.internalMessage.getDescriptorForType().findFieldByName("id"))) {
                throw new VerificationFailedException("Given message has no id field!");
            }
            Object id = this.internalMessage.getField(this.internalMessage.getDescriptorForType().findFieldByName("id"));
            if (id.toString().isEmpty()) {
                throw new VerificationFailedException("Detected id is empty!");
            }
            return (KEY)id;
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("id", (Throwable)ex);
        }
    }

    private void setupId(IdGenerator<KEY, M> generator) throws CouldNotPerformException {
        try {
            if (this.verifyId()) {
                return;
            }
            if (generator == null) {
                throw new NotAvailableException("idGenerator");
            }
            this.setId(generator.generateId(this.internalMessage));
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not setup id for message: " + this.internalMessage, (Throwable)ex);
        }
    }

    private boolean verifyId() {
        return this.internalMessage.hasField(this.internalMessage.getDescriptorForType().findFieldByName("id"));
    }

    private void setId(KEY id) throws InvalidStateException, CouldNotPerformException {
        try {
            if (this.verifyId()) {
                throw new InvalidStateException("ID already specified!");
            }
            this.setMessage((M)((GeneratedMessage)this.internalMessage.toBuilder().setField(this.internalMessage.getDescriptorForType().findFieldByName("id"), id).build()));
        }
        catch (Exception ex) {
            throw new CouldNotPerformException("Could not setup id!", (Throwable)ex);
        }
    }

    public IdentifiableMessage<KEY, M, MB> setMessage(MB builder) throws CouldNotPerformException {
        if (builder == null) {
            throw new NotAvailableException("message");
        }
        return this.setMessage((M)((GeneratedMessage)builder.build()));
    }

    public IdentifiableMessage<KEY, M, MB> setMessage(M message) throws CouldNotPerformException {
        if (message == null) {
            throw new NotAvailableException("message");
        }
        this.internalMessage = message;
        this.notifyObservers();
        return this;
    }

    public void notifyObservers() {
        try {
            this.observable.notifyObservers((Object)this);
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)logger);
        }
    }

    @Override
    public M getMessage() {
        return this.internalMessage;
    }

    public String getMessageTypeName() {
        return this.internalMessage.getClass().getSimpleName();
    }

    public void addObserver(Observer<IdentifiableMessage<KEY, M, MB>> observer) {
        this.observable.addObserver(observer);
    }

    public void removeObserver(Observer<IdentifiableMessage<KEY, M, MB>> observer) {
        this.observable.removeObserver(observer);
    }

    public String toString() {
        return this.getMessageTypeName() + "[" + this.generateMessageDescription() + "]";
    }

    public String generateMessageDescription() {
        if (this.internalMessage.getDescriptorForType().findFieldByName("label") != null && this.internalMessage.hasField(this.internalMessage.getDescriptorForType().findFieldByName("label"))) {
            return (String)this.internalMessage.getField(this.internalMessage.getDescriptorForType().findFieldByName("label"));
        }
        try {
            return this.getId().toString();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not detect id value of internal message!", (Throwable)ex), (Logger)logger, (LogLevel)LogLevel.WARN);
            return "?";
        }
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.internalMessage).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IdentifiableMessage) {
            IdentifiableMessage other = (IdentifiableMessage)obj;
            return new EqualsBuilder().append(this.internalMessage, other.internalMessage).isEquals();
        }
        return false;
    }

    static {
        try {
            debugMode = (Boolean)((JPDebugMode)JPService.getProperty(JPDebugMode.class)).getValue();
        }
        catch (JPServiceException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not check debug mode state!", (Throwable)ex), (Logger)logger, (LogLevel)LogLevel.WARN);
            debugMode = false;
        }
    }
}

