/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.communication.controller.jp;

import java.util.List;
import org.openbase.jps.core.AbstractJavaProperty;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.extension.type.processing.ScopeProcessor;
import org.openbase.jul.processing.StringProcessor;
import org.openbase.type.communication.ScopeType;

public class JPScope
extends AbstractJavaProperty<ScopeType.Scope> {
    public static final String[] COMMAND_IDENTIFIERS = new String[]{"-s", "--scope"};

    public JPScope() {
        super(COMMAND_IDENTIFIERS);
    }

    public JPScope(String[] commandIdentifiers) {
        super(commandIdentifiers);
    }

    protected ScopeType.Scope getPropertyDefaultValue() throws JPNotAvailableException {
        if (JPService.testMode()) {
            String user = ScopeProcessor.convertIntoValidScopeComponent((String)System.getProperty("user.name"));
            return ScopeProcessor.generateScope((String)("/test/" + user));
        }
        return ScopeProcessor.generateScope((String)"/");
    }

    protected ScopeType.Scope parse(List<String> list) throws Exception {
        return ScopeProcessor.generateScope((String)this.getOneArgumentResult());
    }

    public String getDescription() {
        return "Setup the application scope which is used for the communication.";
    }

    protected String[] generateArgumentIdentifiers() {
        String[] args = new String[]{"SCOPE"};
        return args;
    }

    public String getDefaultExample() {
        try {
            return this.propertyIdentifiers[0] + " " + ScopeProcessor.generateStringRep((ScopeType.Scope)((ScopeType.Scope)this.getDefaultValue()));
        }
        catch (JPNotAvailableException | CouldNotPerformException ex) {
            return this.propertyIdentifiers[0];
        }
    }

    public static String convertIntoValidScopeComponent(String scopeComponent) {
        return StringProcessor.transformToIdString((String)scopeComponent.toLowerCase()).replaceAll("_", "");
    }
}

