/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.communication.controller;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.openbase.jul.communication.controller.RPCRemote;
import org.openbase.jul.communication.data.RPCResponse;
import org.openbase.jul.communication.iface.RPCClient;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.schedule.FutureProcessor;

public class RPCUtils {
    public static final long RPC_TIMEOUT = TimeUnit.MINUTES.toMillis(5L);
    public static final String USER_TIME_KEY = "USER_NANO_TIME";
    public static final String CREATE_TIMESTAMP = "CREATE_TIMESTAMP";
    public static final long USER_TIME_VALUE_INVALID = -1L;
    private static final String INTERNAL_CALL_REMOTE_METHOD_NAME = "internalCallRemoteMethod";

    public static Future<Object> callRemoteServerMethod(RPCRemote<?> remote) {
        return FutureProcessor.postProcess((input, timeout, timeUnit) -> input.getResponse(), RPCUtils.internalCallRemoteMethod(null, remote, Object.class));
    }

    public static Future<Object> callRemoteServerMethod(Object argument, RPCRemote<?> remote) {
        return FutureProcessor.postProcess((input, timeout, timeUnit) -> input.getResponse(), RPCUtils.internalCallRemoteMethod(argument, remote, Object.class));
    }

    public static <RETURN> Future<RETURN> callRemoteServerMethod(RPCRemote<?> remote, Class<RETURN> returnClass) {
        return FutureProcessor.postProcess((input, timeout, timeUnit) -> input.getResponse(), RPCUtils.internalCallRemoteMethod(null, remote, returnClass));
    }

    public static <RETURN> Future<RETURN> callRemoteServerMethod(Object argument, RPCRemote<?> remote, Class<RETURN> returnClass) {
        return FutureProcessor.postProcess((input, timeout, timeUnit) -> input.getResponse(), RPCUtils.internalCallRemoteMethod(argument, remote, returnClass));
    }

    private static <RETURN> Future<RPCResponse<RETURN>> internalCallRemoteMethod(Object argument, RPCRemote<?> remote, Class<RETURN> returnClass) {
        String methodName = "?";
        try {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            if (stackTrace == null) {
                throw new NotAvailableException("method stack");
            }
            if (stackTrace.length == 0) {
                throw new InvalidStateException("Could not detect method stack!");
            }
            try {
                for (int i = 0; i < stackTrace.length; ++i) {
                    if (!stackTrace[i].getMethodName().equals(INTERNAL_CALL_REMOTE_METHOD_NAME)) continue;
                    methodName = stackTrace[i + 2].getMethodName();
                    break;
                }
            }
            catch (IndexOutOfBoundsException | NullPointerException ex) {
                throw new CouldNotPerformException("Could not detect method name!");
            }
            return remote.callMethodAsync(methodName, returnClass, argument);
        }
        catch (CouldNotPerformException ex) {
            return FutureProcessor.canceledFuture((Exception)((Object)new CouldNotPerformException("Could not call remote Message[" + methodName + "]", (Throwable)ex)));
        }
    }

    public static Future<Object> callRemoteServerMethod(RPCClient remote) {
        return FutureProcessor.postProcess((input, timeout, timeUnit) -> input.getResponse(), RPCUtils.internalCallRemoteMethod(null, remote, Object.class));
    }

    public static Future<Object> callRemoteServerMethod(Object argument, RPCClient remote) {
        return FutureProcessor.postProcess((input, timeout, timeUnit) -> input.getResponse(), RPCUtils.internalCallRemoteMethod(argument, remote, Object.class));
    }

    public static <RETURN> Future<RETURN> callRemoteServerMethod(RPCClient remote, Class<RETURN> returnClass) {
        return FutureProcessor.postProcess((input, timeout, timeUnit) -> input.getResponse(), RPCUtils.internalCallRemoteMethod(null, remote, returnClass));
    }

    public static <RETURN> Future<RETURN> callRemoteServerMethod(Object argument, RPCClient remote, Class<RETURN> returnClass) {
        return FutureProcessor.postProcess((input, timeout, timeUnit) -> input.getResponse(), RPCUtils.internalCallRemoteMethod(argument, remote, returnClass));
    }

    private static <RETURN> Future<RPCResponse<RETURN>> internalCallRemoteMethod(Object argument, RPCClient remote, Class<RETURN> returnClass) {
        String methodName = "?";
        try {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            if (stackTrace == null) {
                throw new NotAvailableException("method stack");
            }
            if (stackTrace.length == 0) {
                throw new InvalidStateException("Could not detect method stack!");
            }
            try {
                for (int i = 0; i < stackTrace.length; ++i) {
                    if (!stackTrace[i].getMethodName().equals(INTERNAL_CALL_REMOTE_METHOD_NAME)) continue;
                    methodName = stackTrace[i + 2].getMethodName();
                    break;
                }
            }
            catch (IndexOutOfBoundsException | NullPointerException ex) {
                throw new CouldNotPerformException("Could not detect method name!");
            }
            return remote.callMethod(methodName, returnClass, new Object[]{argument});
        }
        catch (CouldNotPerformException ex) {
            return FutureProcessor.canceledFuture((Exception)((Object)new CouldNotPerformException("Could not call remote Message[" + methodName + "]", (Throwable)ex)));
        }
    }

    public static String argumentToString(Object argument) {
        if (argument == null) {
            return "Void";
        }
        String rep = argument.toString();
        if (rep.length() > 10) {
            return argument.getClass().getSimpleName();
        }
        return rep;
    }
}

